/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.ambiguity;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.MethodNameMatcher;
import org.evosuite.coverage.ambiguity.AmbiguityCoverageTestFitness;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.testsuite.AbstractFitnessFactory;
import org.evosuite.utils.MD5;

public class AmbiguityCoverageFactory
extends AbstractFitnessFactory<AmbiguityCoverageTestFitness> {
    private static boolean called = false;
    private static List<AmbiguityCoverageTestFitness> goals = new ArrayList<AmbiguityCoverageTestFitness>();
    private static List<StringBuilder> transposedMatrix = new ArrayList<StringBuilder>();
    private static LinkedHashSet<Integer> lineNumbers = new LinkedHashSet();

    private static void computeGoals() {
        if (called) {
            return;
        }
        String targetClass = Properties.TARGET_CLASS;
        MethodNameMatcher matcher = new MethodNameMatcher();
        for (String className : BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).knownClasses()) {
            if (!targetClass.equals("") && !className.endsWith(targetClass)) continue;
            for (String methodName : BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).knownMethods(className)) {
                if (!matcher.methodMatches(methodName)) continue;
                for (BytecodeInstruction ins : BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getInstructionsIn(className, methodName)) {
                    if (!AmbiguityCoverageFactory.isUsable(ins)) continue;
                    goals.add(new AmbiguityCoverageTestFitness(ins));
                }
            }
        }
        called = true;
        AmbiguityCoverageFactory.loadCoverage();
    }

    private static boolean isUsable(BytecodeInstruction ins) {
        if (!lineNumbers.add(ins.getLineNumber())) {
            return false;
        }
        return ins.isLineNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void loadCoverage() {
        BufferedReader br = null;
        try {
            String sCurrentLine;
            br = new BufferedReader(new FileReader(Properties.REPORT_DIR + File.separator + "data" + File.separator + Properties.TARGET_CLASS + ".matrix"));
            ArrayList<StringBuilder> matrix = new ArrayList<StringBuilder>();
            while ((sCurrentLine = br.readLine()) != null) {
                sCurrentLine = sCurrentLine.replace(" ", "");
                sCurrentLine = sCurrentLine.substring(0, sCurrentLine.length() - 1);
                matrix.add(new StringBuilder(sCurrentLine));
            }
            transposedMatrix = AmbiguityCoverageFactory.tranposeMatrix(matrix);
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public List<AmbiguityCoverageTestFitness> getCoverageGoals() {
        if (!called) {
            AmbiguityCoverageFactory.computeGoals();
        }
        return goals;
    }

    public static List<AmbiguityCoverageTestFitness> retrieveCoverageGoals() {
        if (!called) {
            AmbiguityCoverageFactory.computeGoals();
        }
        return goals;
    }

    public static List<StringBuilder> getTransposedMatrix() {
        return transposedMatrix;
    }

    public static double getAmbiguity(List<StringBuilder> matrix) {
        int number_of_components = matrix.size();
        LinkedHashMap<String, Integer> groups = new LinkedHashMap<String, Integer>();
        for (StringBuilder s : matrix) {
            String md5 = MD5.hash(s.toString());
            if (!groups.containsKey(md5)) {
                groups.put(md5, 1);
                continue;
            }
            groups.put(md5, (Integer)groups.get(md5) + 1);
        }
        double fit = 0.0;
        for (String s : groups.keySet()) {
            double cardinality = ((Integer)groups.get(s)).intValue();
            if (cardinality == 1.0) continue;
            fit += cardinality / (double)number_of_components * ((cardinality - 1.0) / 2.0);
        }
        return fit;
    }

    private static List<StringBuilder> tranposeMatrix(List<StringBuilder> matrix) {
        int number_of_components = matrix.get(0).length();
        ArrayList<StringBuilder> new_matrix = new ArrayList<StringBuilder>();
        for (int c_i = 0; c_i < number_of_components; ++c_i) {
            StringBuilder str = new StringBuilder();
            for (StringBuilder t_i : matrix) {
                str.append(t_i.charAt(c_i));
            }
            new_matrix.add(str);
        }
        return new_matrix;
    }
}

