/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.ambiguity;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.evosuite.coverage.branch.BranchCoverageFactory;
import org.evosuite.coverage.branch.BranchCoverageTestFitness;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.ControlDependency;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;

public class AmbiguityCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = 6439138527631268608L;
    protected BytecodeInstruction goalInstruction;
    protected List<BranchCoverageTestFitness> branchFitnesses = new ArrayList<BranchCoverageTestFitness>();

    public AmbiguityCoverageTestFitness(BytecodeInstruction goalInstruction) {
        if (goalInstruction == null) {
            throw new IllegalArgumentException("null given");
        }
        this.goalInstruction = goalInstruction;
        Set<ControlDependency> cds = goalInstruction.getControlDependencies();
        for (ControlDependency cd : cds) {
            BranchCoverageTestFitness fitness = BranchCoverageFactory.createBranchCoverageTestFitness(cd);
            this.branchFitnesses.add(fitness);
        }
        if (goalInstruction.isRootBranchDependent()) {
            this.branchFitnesses.add(BranchCoverageFactory.createRootBranchTestFitness(goalInstruction));
        }
        if (cds.isEmpty() && !goalInstruction.isRootBranchDependent()) {
            throw new IllegalStateException("expect control dependencies to be empty only for root dependent instructions: " + this.toString());
        }
        if (this.branchFitnesses.isEmpty()) {
            throw new IllegalStateException("an instruction is at least on the root branch of it's method");
        }
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        double fitness = Double.MAX_VALUE;
        for (BranchCoverageTestFitness branchFitness : this.branchFitnesses) {
            if (!branchFitness.isCovered(result)) continue;
            fitness = 0.0;
            break;
        }
        return fitness;
    }

    @Override
    public boolean isMaximizationFunction() {
        return false;
    }

    public String toString() {
        return this.goalInstruction.getMethodName() + " " + this.goalInstruction.toString();
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other instanceof AmbiguityCoverageTestFitness) {
            return this.goalInstruction.compareTo(((AmbiguityCoverageTestFitness)other).goalInstruction);
        }
        return 0;
    }

    @Override
    public String getTargetClass() {
        return this.goalInstruction.getClassName();
    }

    @Override
    public String getTargetMethod() {
        return this.goalInstruction.getMethodName();
    }
}

