/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.archive;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.setup.TestCluster;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.GenericAccessibleObject;
import org.evosuite.utils.GenericConstructor;
import org.evosuite.utils.GenericMethod;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TestsArchive implements Serializable
{
    instance;

    private static final long serialVersionUID = 6665770735812413289L;
    private static final Logger logger;
    private TestSuiteChromosome bestChromo;
    private final Set<Integer> coveredGoals;
    private Map<String, Set<TestFitnessFunction>> goalMap = new HashMap<String, Set<TestFitnessFunction>>();
    private Map<TestFitnessFunction, TestCase> testMap = new HashMap<TestFitnessFunction, TestCase>();

    private TestsArchive() {
        this.bestChromo = new TestSuiteChromosome();
        this.coveredGoals = new HashSet<Integer>();
    }

    public void addGoalToCover(TestFitnessFunction goal) {
        String key = goal.getTargetClass() + goal.getTargetMethod();
        if (!this.goalMap.containsKey(key)) {
            this.goalMap.put(key, new HashSet());
        }
        this.goalMap.get(key).add(goal);
    }

    protected boolean isMethodFullyCovered(String className, String methodName) {
        if (!this.goalMap.containsKey(className + methodName)) {
            return true;
        }
        return this.goalMap.get(className + methodName).isEmpty();
    }

    protected void removeTestCall(String className, String methodName) {
        TestCluster cluster = TestCluster.getInstance();
        List<GenericAccessibleObject<?>> calls = cluster.getTestCalls();
        for (GenericAccessibleObject<?> call : calls) {
            String desc;
            if (!call.getDeclaringClass().getName().equals(className)) continue;
            if (call instanceof GenericMethod) {
                GenericMethod genericMethod = (GenericMethod)call;
                if (!methodName.startsWith(genericMethod.getName())) continue;
                desc = Type.getMethodDescriptor((Method)genericMethod.getMethod());
                if (!(genericMethod.getName() + desc).equals(methodName)) continue;
                logger.info("Removing method " + methodName + " from cluster");
                cluster.removeTestCall(call);
                logger.info("Testcalls left: " + cluster.getNumTestCalls());
                continue;
            }
            if (!(call instanceof GenericConstructor)) continue;
            GenericConstructor genericConstructor = (GenericConstructor)call;
            if (!methodName.startsWith("<init>")) continue;
            desc = Type.getConstructorDescriptor(genericConstructor.getConstructor());
            if (!("<init>" + desc).equals(methodName)) continue;
            logger.info("Removing constructor " + methodName + " from cluster");
            cluster.removeTestCall(call);
            logger.info("Testcalls left: " + cluster.getNumTestCalls());
        }
    }

    private void updateGoalMap(TestFitnessFunction goal) {
        String key = goal.getTargetClass() + goal.getTargetMethod();
        if (!this.goalMap.containsKey(key)) {
            return;
        }
        this.goalMap.get(key).remove(goal);
    }

    public void putTest(TestFitnessFunction goal, TestCase test) {
        if (!this.coveredGoals.contains(goal.hashCode())) {
            logger.info("Adding covered goal to archive: " + goal);
            this.coveredGoals.add(goal.hashCode());
            this.bestChromo.addTest(test);
            this.testMap.put(goal, test);
            this.updateGoalMap(goal);
            if (this.isMethodFullyCovered(goal.getTargetClass(), goal.getTargetMethod())) {
                this.removeTestCall(goal.getTargetClass(), goal.getTargetMethod());
            }
        }
    }

    public void registerAllTests(Collection<TestChromosome> tests) {
        this.bestChromo.addTests(tests);
    }

    public TestSuiteChromosome getBestChromosome() {
        return this.bestChromo;
    }

    public TestSuiteChromosome getReducedChromosome() {
        TestSuiteChromosome suite = new TestSuiteChromosome();
        for (Map.Entry<TestFitnessFunction, TestCase> entry : this.testMap.entrySet()) {
            if (entry.getKey().isCoveredBy(suite)) continue;
            suite.addTest(entry.getValue());
        }
        logger.info("Reduced test suite from archive: " + suite.size() + " from " + this.bestChromo.size());
        return suite;
    }

    public int getNumberOfTestsInArchive() {
        return this.bestChromo.size();
    }

    public String toString() {
        return "Goals covered: " + this.coveredGoals.size() + ", tests: " + this.bestChromo.size();
    }

    public void reset() {
        this.bestChromo = new TestSuiteChromosome();
        this.coveredGoals.clear();
        this.goalMap.clear();
        this.testMap.clear();
    }

    static {
        logger = LoggerFactory.getLogger(TestsArchive.class);
    }
}

