/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.branch;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.coverage.MethodNameMatcher;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchCoverageGoal;
import org.evosuite.coverage.branch.BranchCoverageTestFitness;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.ControlDependency;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.testsuite.AbstractFitnessFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchCoverageFactory
extends AbstractFitnessFactory<BranchCoverageTestFitness> {
    private static final Logger logger = LoggerFactory.getLogger(BranchCoverageFactory.class);

    private boolean isCUT(String className) {
        return Properties.TARGET_CLASS.equals("") || className.equals(Properties.TARGET_CLASS) || className.startsWith(Properties.TARGET_CLASS + "$");
    }

    private List<BranchCoverageTestFitness> computeCoverageGoals(boolean limitToCUT) {
        long start = System.currentTimeMillis();
        ArrayList<BranchCoverageTestFitness> goals = new ArrayList<BranchCoverageTestFitness>();
        for (String className : BranchPool.knownClasses()) {
            if (limitToCUT && !this.isCUT(className) || !limitToCUT && !Properties.INSTRUMENT_LIBRARIES && !DependencyAnalysis.isTargetProject(className)) continue;
            MethodNameMatcher matcher = new MethodNameMatcher();
            for (String method : BranchPool.getBranchlessMethods(className)) {
                if (!matcher.fullyQualifiedMethodMatches(method)) continue;
                goals.add(BranchCoverageFactory.createRootBranchTestFitness(className, method));
            }
            for (String methodName : BranchPool.knownMethods(className)) {
                if (!matcher.methodMatches(methodName)) {
                    logger.info("Method " + methodName + " does not match criteria. ");
                    continue;
                }
                for (Branch b : BranchPool.retrieveBranchesInMethod(className, methodName)) {
                    if (b.getInstruction().isForcedBranch()) continue;
                    goals.add(BranchCoverageFactory.createBranchCoverageTestFitness(b, true));
                    goals.add(BranchCoverageFactory.createBranchCoverageTestFitness(b, false));
                }
            }
        }
        goalComputationTime = System.currentTimeMillis() - start;
        return goals;
    }

    @Override
    public List<BranchCoverageTestFitness> getCoverageGoals() {
        return this.computeCoverageGoals(true);
    }

    public List<BranchCoverageTestFitness> getCoverageGoalsForAllKnownClasses() {
        return this.computeCoverageGoals(false);
    }

    public static BranchCoverageTestFitness createBranchCoverageTestFitness(ControlDependency cd) {
        return BranchCoverageFactory.createBranchCoverageTestFitness(cd.getBranch(), cd.getBranchExpressionValue());
    }

    public static BranchCoverageTestFitness createBranchCoverageTestFitness(Branch b, boolean branchExpressionValue) {
        return new BranchCoverageTestFitness(new BranchCoverageGoal(b, branchExpressionValue, b.getClassName(), b.getMethodName()));
    }

    public static BranchCoverageTestFitness createRootBranchTestFitness(String className, String method) {
        return new BranchCoverageTestFitness(new BranchCoverageGoal(className, method.substring(method.lastIndexOf(".") + 1)));
    }

    public static BranchCoverageTestFitness createRootBranchTestFitness(BytecodeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("null given");
        }
        return BranchCoverageFactory.createRootBranchTestFitness(instruction.getClassName(), instruction.getMethodName());
    }
}

