/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.branch.archive;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.archive.TestsArchive;
import org.evosuite.coverage.branch.BranchCoverageFactory;
import org.evosuite.coverage.branch.BranchCoverageTestFitness;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.graphs.cfg.CFGMethodAdapter;
import org.evosuite.instrumentation.LinePool;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveBranchCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = 2991632394620406243L;
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteFitnessFunction.class);
    public int totalMethods;
    public int totalBranches;
    public int totalGoals;
    public final int numBranchlessMethods;
    public final Set<Integer> lines;
    private final Set<String> branchlessMethods;
    private final Set<String> methods;
    private final Set<Integer> branchesId;
    public int maxCoveredBranches = 0;
    public int maxCoveredMethods = 0;
    public double bestFitness = Double.MAX_VALUE;
    private final Map<Integer, TestFitnessFunction> branchCoverageTrueMap = new HashMap<Integer, TestFitnessFunction>();
    private final Map<Integer, TestFitnessFunction> branchCoverageFalseMap = new HashMap<Integer, TestFitnessFunction>();
    private final Map<String, TestFitnessFunction> branchlessMethodCoverageMap = new HashMap<String, TestFitnessFunction>();
    private final TestsArchive bestChromoBuilder;
    private final Set<Integer> toRemoveBranchesT = new HashSet<Integer>();
    private final Set<Integer> toRemoveBranchesF = new HashSet<Integer>();
    private final Set<String> toRemoveRootBranches = new HashSet<String>();
    private final Set<Integer> removedBranchesT = new HashSet<Integer>();
    private final Set<Integer> removedBranchesF = new HashSet<Integer>();
    private final Set<String> removedRootBranches = new HashSet<String>();

    public ArchiveBranchCoverageSuiteFitness() {
        this(TestsArchive.instance);
    }

    public ArchiveBranchCoverageSuiteFitness(TestsArchive bestChromoBuilder) {
        String prefix = Properties.TARGET_CLASS_PREFIX;
        this.bestChromoBuilder = bestChromoBuilder;
        if (prefix.isEmpty()) {
            prefix = Properties.TARGET_CLASS;
            this.totalMethods = CFGMethodAdapter.getNumMethodsPrefix(prefix);
            this.totalBranches = BranchPool.getBranchCountForPrefix(prefix);
            this.numBranchlessMethods = BranchPool.getNumBranchlessMethodsPrefix(prefix);
            this.branchlessMethods = BranchPool.getBranchlessMethodsPrefix(prefix);
            this.methods = CFGMethodAdapter.getMethodsPrefix(prefix);
        } else {
            this.totalMethods = CFGMethodAdapter.getNumMethodsPrefix(prefix);
            this.totalBranches = BranchPool.getBranchCountForPrefix(prefix);
            this.numBranchlessMethods = BranchPool.getNumBranchlessMethodsPrefix(prefix);
            this.branchlessMethods = BranchPool.getBranchlessMethodsPrefix(prefix);
            this.methods = CFGMethodAdapter.getMethodsPrefix(prefix);
        }
        this.branchesId = new HashSet<Integer>();
        this.lines = LinePool.getLines(Properties.TARGET_CLASS);
        this.totalGoals = 2 * this.totalBranches + this.numBranchlessMethods;
        logger.info("Total branch coverage goals: " + this.totalGoals);
        logger.info("Total branches: " + this.totalBranches);
        logger.info("Total branchless methods: " + this.numBranchlessMethods);
        logger.info("Total methods: " + this.totalMethods + ": " + this.methods);
        this.determineCoverageGoals();
    }

    private void determineCoverageGoals() {
        List<BranchCoverageTestFitness> goals = new BranchCoverageFactory().getCoverageGoals();
        for (BranchCoverageTestFitness goal : goals) {
            this.bestChromoBuilder.addGoalToCover(goal);
            if (goal.getBranch() == null) {
                this.branchlessMethodCoverageMap.put(goal.getClassName() + "." + goal.getMethod(), goal);
                continue;
            }
            this.branchesId.add(goal.getBranch().getActualBranchId());
            if (goal.getBranchExpressionValue()) {
                this.branchCoverageTrueMap.put(goal.getBranch().getActualBranchId(), goal);
                continue;
            }
            this.branchCoverageFalseMap.put(goal.getBranch().getActualBranchId(), goal);
        }
    }

    private void handleConstructorExceptions(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite, List<ExecutionResult> results, Map<String, Integer> callCount) {
        for (ExecutionResult result : results) {
            Statement statement;
            Integer exceptionPosition;
            if (result.hasTimeout() || result.hasTestException() || result.noThrownExceptions() || (exceptionPosition = result.getFirstPositionOfThrownException()) >= result.test.size() || !((statement = result.test.getStatement(exceptionPosition)) instanceof ConstructorStatement)) continue;
            ConstructorStatement c = (ConstructorStatement)statement;
            String className = c.getConstructor().getName();
            String methodName = "<init>" + Type.getConstructorDescriptor(c.getConstructor().getConstructor());
            String name = className + "." + methodName;
            if (callCount.containsKey(name)) continue;
            callCount.put(name, 1);
            if (!this.branchlessMethodCoverageMap.containsKey(name)) continue;
            result.test.addCoveredGoal(this.branchlessMethodCoverageMap.get(name));
            this.bestChromoBuilder.putTest(this.branchlessMethodCoverageMap.get(name), result.test);
            this.toRemoveRootBranches.add(name);
            suite.isToBeUpdated(true);
        }
    }

    private boolean analyzeTraces(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite, List<ExecutionResult> results, Map<Integer, Integer> predicateCount, Map<String, Integer> callCount, Map<Integer, Double> trueDistance, Map<Integer, Double> falseDistance) {
        boolean hasTimeoutOrTestException = false;
        for (ExecutionResult result : results) {
            if (result.hasTimeout() || result.hasTestException()) {
                hasTimeoutOrTestException = true;
            }
            for (Map.Entry<String, Integer> entry : result.getTrace().getMethodExecutionCount().entrySet()) {
                if (entry.getKey() == null || !this.methods.contains(entry.getKey()) || this.removedRootBranches.contains(entry.getKey())) continue;
                if (!callCount.containsKey(entry.getKey())) {
                    callCount.put(entry.getKey(), entry.getValue());
                } else {
                    callCount.put(entry.getKey(), callCount.get(entry.getKey()) + entry.getValue());
                }
                if (!this.branchlessMethodCoverageMap.containsKey(entry.getKey())) continue;
                result.test.addCoveredGoal(this.branchlessMethodCoverageMap.get(entry.getKey()));
                this.bestChromoBuilder.putTest(this.branchlessMethodCoverageMap.get(entry.getKey()), result.test);
                this.toRemoveRootBranches.add(entry.getKey());
                suite.isToBeUpdated(true);
            }
            for (Map.Entry<Object, Integer> entry : result.getTrace().getPredicateExecutionCount().entrySet()) {
                if (!this.branchesId.contains(entry.getKey()) || this.removedBranchesT.contains(entry.getKey()) && this.removedBranchesF.contains(entry.getKey())) continue;
                if (!predicateCount.containsKey(entry.getKey())) {
                    predicateCount.put((Integer)entry.getKey(), entry.getValue());
                    continue;
                }
                predicateCount.put((Integer)entry.getKey(), predicateCount.get(entry.getKey()) + entry.getValue());
            }
            for (Map.Entry<Object, Number> entry : result.getTrace().getTrueDistances().entrySet()) {
                if (!this.branchesId.contains(entry.getKey()) || this.removedBranchesT.contains(entry.getKey())) continue;
                if (!trueDistance.containsKey(entry.getKey())) {
                    trueDistance.put((Integer)entry.getKey(), (Double)entry.getValue());
                } else {
                    trueDistance.put((Integer)entry.getKey(), Math.min(trueDistance.get(entry.getKey()), (Double)entry.getValue()));
                }
                if (Double.compare((Double)entry.getValue(), 0.0) != 0) continue;
                result.test.addCoveredGoal(this.branchCoverageTrueMap.get(entry.getKey()));
                this.bestChromoBuilder.putTest(this.branchCoverageTrueMap.get(entry.getKey()), result.test);
                this.toRemoveBranchesT.add((Integer)entry.getKey());
                suite.isToBeUpdated(true);
            }
            for (Map.Entry<Object, Number> entry : result.getTrace().getFalseDistances().entrySet()) {
                if (!this.branchesId.contains(entry.getKey()) || this.removedBranchesF.contains(entry.getKey())) continue;
                if (!falseDistance.containsKey(entry.getKey())) {
                    falseDistance.put((Integer)entry.getKey(), (Double)entry.getValue());
                } else {
                    falseDistance.put((Integer)entry.getKey(), Math.min(falseDistance.get(entry.getKey()), (Double)entry.getValue()));
                }
                if (Double.compare((Double)entry.getValue(), 0.0) != 0) continue;
                result.test.addCoveredGoal(this.branchCoverageFalseMap.get(entry.getKey()));
                this.bestChromoBuilder.putTest(this.branchCoverageFalseMap.get(entry.getKey()), result.test);
                this.toRemoveBranchesF.add((Integer)entry.getKey());
                suite.isToBeUpdated(true);
            }
        }
        return hasTimeoutOrTestException;
    }

    @Override
    public boolean updateCoveredGoals() {
        for (String method : this.toRemoveRootBranches) {
            boolean removed = this.branchlessMethods.remove(method);
            TestFitnessFunction f = this.branchlessMethodCoverageMap.remove(method);
            if (removed && f != null) {
                --this.totalMethods;
                this.methods.remove(method);
                this.removedRootBranches.add(method);
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        for (Integer branch : this.toRemoveBranchesT) {
            TestFitnessFunction f = this.branchCoverageTrueMap.remove(branch);
            if (f != null) {
                this.removedBranchesT.add(branch);
                if (!this.removedBranchesF.contains(branch)) continue;
                --this.totalBranches;
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        for (Integer branch : this.toRemoveBranchesF) {
            TestFitnessFunction f = this.branchCoverageFalseMap.remove(branch);
            if (f != null) {
                this.removedBranchesF.add(branch);
                if (!this.removedBranchesT.contains(branch)) continue;
                --this.totalBranches;
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        this.toRemoveRootBranches.clear();
        this.toRemoveBranchesF.clear();
        this.toRemoveBranchesT.clear();
        logger.info("Current state of archive: " + this.bestChromoBuilder.toString());
        return true;
    }

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite) {
        logger.trace("Calculating branch fitness");
        double fitness = 0.0;
        List<ExecutionResult> results = this.runTestSuite(suite);
        HashMap<Integer, Double> trueDistance = new HashMap<Integer, Double>();
        HashMap<Integer, Double> falseDistance = new HashMap<Integer, Double>();
        HashMap<Integer, Integer> predicateCount = new HashMap<Integer, Integer>();
        HashMap<String, Integer> callCount = new HashMap<String, Integer>();
        HashSet<Integer> covered_lines = new HashSet<Integer>();
        boolean hasTimeoutOrTestException = this.analyzeTraces(suite, results, predicateCount, callCount, trueDistance, falseDistance);
        this.handleConstructorExceptions(suite, results, callCount);
        if (Properties.BRANCH_STATEMENT) {
            for (ExecutionResult result : results) {
                for (Map<String, Map<Integer, Integer>> coverage : result.getTrace().getCoverageData().values()) {
                    for (Map<Integer, Integer> coveredLines : coverage.values()) {
                        covered_lines.addAll(coveredLines.keySet());
                    }
                }
            }
        }
        int numCoveredBranches = 0;
        for (Integer key : predicateCount.keySet()) {
            double df = 0.0;
            double dt = 0.0;
            if (trueDistance.containsKey(key)) {
                dt = (Double)trueDistance.get(key);
            }
            if (falseDistance.containsKey(key)) {
                df = (Double)falseDistance.get(key);
            }
            fitness += ArchiveBranchCoverageSuiteFitness.normalize(df) + ArchiveBranchCoverageSuiteFitness.normalize(dt);
            if (falseDistance.containsKey(key) && Double.compare(df, 0.0) == 0) {
                ++numCoveredBranches;
            }
            if (!trueDistance.containsKey(key) || Double.compare(dt, 0.0) != 0) continue;
            ++numCoveredBranches;
        }
        fitness += (double)(2 * (this.totalBranches - predicateCount.size()));
        int missingMethods = 0;
        for (String e : this.methods) {
            if (callCount.containsKey(e)) continue;
            fitness += 1.0;
            ++missingMethods;
        }
        if (Properties.BRANCH_STATEMENT) {
            int totalLines = this.lines.size();
            logger.info("Covered " + covered_lines.size() + " out of " + totalLines + " lines");
            fitness += ArchiveBranchCoverageSuiteFitness.normalize(totalLines - covered_lines.size());
        }
        this.printStatusMessages(suite, numCoveredBranches, this.totalMethods - missingMethods, fitness);
        int coverage = numCoveredBranches;
        for (String e : this.branchlessMethods) {
            if (!callCount.keySet().contains(e)) continue;
            ++coverage;
        }
        coverage += this.removedBranchesF.size();
        coverage += this.removedBranchesT.size();
        coverage += this.removedRootBranches.size();
        if (this.totalGoals > 0) {
            suite.setCoverage(this, (double)coverage / (double)this.totalGoals);
        } else {
            suite.setCoverage(this, 0.0);
        }
        suite.setNumOfCoveredGoals(this, coverage);
        suite.setNumOfNotCoveredGoals(this, this.totalGoals - coverage);
        if (hasTimeoutOrTestException) {
            logger.info("Test suite has timed out, setting fitness to max value " + (this.totalBranches * 2 + this.totalMethods));
            fitness = this.totalBranches * 2 + this.totalMethods;
        }
        this.updateIndividual(this, suite, fitness);
        assert (coverage <= this.totalGoals) : "Covered " + coverage + " vs total goals " + this.totalGoals;
        assert (fitness >= 0.0);
        assert (fitness != 0.0 || coverage == this.totalGoals) : "Fitness: " + fitness + ", " + "coverage: " + coverage + "/" + this.totalGoals;
        assert (suite.getCoverage(this) <= 1.0 && suite.getCoverage(this) >= 0.0) : "Wrong coverage value " + suite.getCoverage(this);
        return fitness;
    }

    private void printStatusMessages(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite, int coveredBranches, int coveredMethods, double fitness) {
        if (coveredBranches > this.maxCoveredBranches) {
            this.maxCoveredBranches = coveredBranches;
            logger.info("(Branches) Best individual covers " + coveredBranches + "/" + this.totalBranches * 2 + " branches and " + coveredMethods + "/" + this.totalMethods + " methods");
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
        if (coveredMethods > this.maxCoveredMethods) {
            logger.info("(Methods) Best individual covers " + coveredBranches + "/" + this.totalBranches * 2 + " branches and " + coveredMethods + "/" + this.totalMethods + " methods");
            this.maxCoveredMethods = coveredMethods;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
        if (fitness < this.bestFitness) {
            logger.info("(Fitness) Best individual covers " + coveredBranches + "/" + this.totalBranches * 2 + " branches and " + coveredMethods + "/" + this.totalMethods + " methods");
            this.bestFitness = fitness;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
    }

    @Override
    public TestSuiteChromosome getBestStoredIndividual() {
        return this.bestChromoBuilder.getReducedChromosome();
    }
}

