/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.cbranch;

import java.util.Map;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchCoverageGoal;
import org.evosuite.coverage.branch.BranchCoverageTestFitness;
import org.evosuite.setup.CallContext;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;

public class CBranchTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = -1399396770125054561L;
    private final BranchCoverageGoal branchGoal;
    private final CallContext context;

    public CBranchTestFitness(BranchCoverageGoal branch, CallContext context) {
        this.branchGoal = branch;
        this.context = context;
    }

    public Branch getBranch() {
        return this.branchGoal.getBranch();
    }

    public boolean getValue() {
        return this.branchGoal.getValue();
    }

    public CallContext getContext() {
        return this.context;
    }

    public BranchCoverageGoal getBranchGoal() {
        return this.branchGoal;
    }

    public int getGenericContextBranchIdentifier() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.branchGoal == null ? 0 : this.branchGoal.hashCodeWithoutValue());
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        return result;
    }

    private double getMethodCallDistance(ExecutionResult result) {
        String key = this.branchGoal.getClassName() + "." + this.branchGoal.getMethodName();
        if (!result.getTrace().getMethodContextCount().containsKey(key)) {
            return Double.MAX_VALUE;
        }
        for (Map.Entry<CallContext, Integer> value : result.getTrace().getMethodContextCount().get(key).entrySet()) {
            if (!this.context.matches(value.getKey())) continue;
            return value.getValue() > 0 ? 0.0 : 1.0;
        }
        return Double.MAX_VALUE;
    }

    private double getPredicateDistance(Map<Integer, Map<CallContext, Double>> distanceMap) {
        if (!distanceMap.containsKey(this.branchGoal.getBranch().getActualBranchId())) {
            return Double.MAX_VALUE;
        }
        Map<CallContext, Double> distances = distanceMap.get(this.branchGoal.getBranch().getActualBranchId());
        for (Map.Entry<CallContext, Double> value : distances.entrySet()) {
            if (!this.context.matches(value.getKey())) continue;
            return value.getValue();
        }
        return Double.MAX_VALUE;
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        double fitness = 0.0;
        fitness = this.branchGoal.getBranch() == null ? this.getMethodCallDistance(result) : (this.branchGoal.getValue() ? this.getPredicateDistance(result.getTrace().getTrueDistancesContext()) : this.getPredicateDistance(result.getTrace().getFalseDistancesContext()));
        this.updateIndividual(this, individual, fitness);
        return fitness;
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other instanceof CBranchTestFitness) {
            CBranchTestFitness otherBranchFitness = (CBranchTestFitness)other;
            return this.branchGoal.compareTo(otherBranchFitness.branchGoal);
        }
        if (other instanceof BranchCoverageTestFitness) {
            BranchCoverageTestFitness otherBranchFitness = (BranchCoverageTestFitness)other;
            return this.branchGoal.compareTo(otherBranchFitness.getBranchGoal());
        }
        return 0;
    }

    @Override
    public String getTargetClass() {
        return this.branchGoal.getClassName();
    }

    @Override
    public String getTargetMethod() {
        return this.branchGoal.getMethodName();
    }

    public String toString() {
        return "Branch " + this.branchGoal + " in context: " + this.context.toString();
    }

    public String toStringContext() {
        return this.context.toString() + ":" + this.branchGoal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.branchGoal == null ? 0 : this.branchGoal.hashCode());
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CBranchTestFitness other = (CBranchTestFitness)obj;
        if (this.branchGoal == null ? other.branchGoal != null : !this.branchGoal.equals(other.branchGoal)) {
            return false;
        }
        return !(this.context == null ? other.context != null : !this.context.equals(other.context));
    }
}

