/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.dataflow;

import java.util.Map;
import org.evosuite.coverage.dataflow.DefUseCoverageTestFitness;
import org.evosuite.coverage.dataflow.Definition;
import org.evosuite.coverage.dataflow.Use;
import org.evosuite.coverage.statement.StatementCoverageTestFitness;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;

public class AllDefsCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = 1L;
    public static long singleFitnessTime = 0L;
    private final Definition targetDef;
    private final TestFitnessFunction goalDefinitionFitness;
    private final Map<Use, DefUseCoverageTestFitness> uses;

    public AllDefsCoverageTestFitness(Definition def, Map<Use, DefUseCoverageTestFitness> uses) {
        this.targetDef = def;
        this.goalDefinitionFitness = new StatementCoverageTestFitness(def);
        this.uses = uses;
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        double defFitness = this.goalDefinitionFitness.getFitness(individual, result);
        if (defFitness > 0.0) {
            return 1.0 + AllDefsCoverageTestFitness.normalize(defFitness);
        }
        double min = Double.MAX_VALUE;
        for (Use use : this.uses.keySet()) {
            double useFitness = this.uses.get(use).getFitness(individual, result);
            if (useFitness == 0.0) {
                return 0.0;
            }
            if (!(useFitness < min)) continue;
            min = useFitness;
        }
        return min;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.targetDef == null ? 0 : this.targetDef.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AllDefsCoverageTestFitness other = (AllDefsCoverageTestFitness)obj;
        return !(this.targetDef == null ? other.targetDef != null : !this.targetDef.equals(other.targetDef));
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other instanceof AllDefsCoverageTestFitness) {
            AllDefsCoverageTestFitness otherFitness = (AllDefsCoverageTestFitness)other;
            return this.targetDef.compareTo(otherFitness.targetDef);
        }
        return 0;
    }

    public String toString() {
        return "AllDef-Goal " + this.targetDef.toString();
    }

    @Override
    public String getTargetClass() {
        return this.targetDef.getClassName();
    }

    @Override
    public String getTargetMethod() {
        return this.targetDef.getMethodName();
    }
}

