/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.dataflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.dataflow.DefUseCoverageTestFitness;
import org.evosuite.coverage.dataflow.DefUsePool;
import org.evosuite.coverage.dataflow.Definition;
import org.evosuite.coverage.dataflow.Use;
import org.evosuite.coverage.dataflow.analysis.AllUsesAnalysis;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.ccfg.ClassControlFlowGraph;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.rmi.ClientServices;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.AbstractFitnessFactory;
import org.evosuite.utils.JdkPureMethodsList;
import org.evosuite.utils.LoggingUtils;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefUseCoverageFactory
extends AbstractFitnessFactory<DefUseCoverageTestFitness> {
    private static final Logger logger = LoggerFactory.getLogger(DefUseCoverageFactory.class);
    private static boolean called = false;
    private static List<DefUseCoverageTestFitness> duGoals;
    private static List<DefUseCoverageTestFitness> goals;
    private static Map<Definition, Map<Use, DefUseCoverageTestFitness>> goalMap;
    private static Map<DefUseCoverageTestFitness.DefUsePairType, Integer> goalCounts;

    public static List<DefUseCoverageTestFitness> getDUGoals() {
        if (!called) {
            DefUseCoverageFactory.computeGoals();
        }
        return duGoals;
    }

    @Override
    public List<DefUseCoverageTestFitness> getCoverageGoals() {
        if (!called) {
            DefUseCoverageFactory.computeGoals();
        }
        return goals;
    }

    public static void computeGoals() {
        DefUseCoverageFactory.categorizeFieldMethodCalls();
        long start = System.currentTimeMillis();
        LoggingUtils.getEvoLogger().info("starting DefUse-Coverage goal generation");
        duGoals = new ArrayList<DefUseCoverageTestFitness>();
        if (!GraphPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).canMakeCCFGForClass(Properties.TARGET_CLASS)) {
            goals = new ArrayList<DefUseCoverageTestFitness>();
            logger.info("Have no CFGs, is this an interface?");
            return;
        }
        LoggingUtils.getEvoLogger().info("* Creating DefUse-Pairs from CCFG...");
        duGoals.addAll(DefUseCoverageFactory.getCCFGPairs());
        LoggingUtils.getEvoLogger().info("  ..created " + DefUseCoverageFactory.getIntraMethodGoalsCount() + " intra-method-, " + DefUseCoverageFactory.getInterMethodGoalsCount() + " inter-method- and " + DefUseCoverageFactory.getIntraClassGoalsCount() + " intra-class-pairs");
        LoggingUtils.getEvoLogger().info("  " + duGoals.toString());
        LoggingUtils.getEvoLogger().info("* Creating parameter goals...");
        duGoals.addAll(DefUseCoverageFactory.getParameterGoals());
        LoggingUtils.getEvoLogger().info("  created " + DefUseCoverageFactory.getParamGoalsCount() + " parameter goals");
        called = true;
        goals = new ArrayList<DefUseCoverageTestFitness>();
        goals.addAll(duGoals);
        long end = System.currentTimeMillis();
        goalComputationTime = end - start;
        LoggingUtils.getEvoLogger().info("* Goal computation took: " + goalComputationTime + "ms");
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.IntraMethodPairs, DefUseCoverageFactory.getIntraMethodGoalsCount());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.InterMethodPairs, DefUseCoverageFactory.getInterMethodGoalsCount());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.ParameterPairs, DefUseCoverageFactory.getParamGoalsCount());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.IntraClassPairs, DefUseCoverageFactory.getIntraClassGoalsCount());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.DefUsePairs, goals.size());
    }

    private static void categorizeFieldMethodCalls() {
        Set<BytecodeInstruction> fieldMethodCalls = DefUsePool.retrieveFieldMethodCalls();
        LoggingUtils.getEvoLogger().info("Categorizing field method calls: " + fieldMethodCalls.size());
        for (BytecodeInstruction fieldMethodCall : fieldMethodCalls) {
            if (GraphPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).canMakeCCFGForClass(fieldMethodCall.getCalledMethodsClass())) {
                ClassControlFlowGraph ccfg = GraphPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getCCFG(fieldMethodCall.getCalledMethodsClass());
                if (ccfg.isPure(fieldMethodCall.getCalledMethod())) {
                    if (DefUsePool.addAsUse(fieldMethodCall)) continue;
                    throw new IllegalStateException("unable to register field method call as a use " + fieldMethodCall.toString());
                }
                if (DefUsePool.addAsDefinition(fieldMethodCall)) continue;
                throw new IllegalStateException("unable to register field method call as a definition " + fieldMethodCall.toString());
            }
            String toAnalyze = fieldMethodCall.getCalledMethodsClass() + "." + fieldMethodCall.getCalledMethodName();
            if (toAnalyze != null && toAnalyze.startsWith("java.")) {
                Type[] parameters = Type.getArgumentTypes((String)fieldMethodCall.getMethodCallDescriptor());
                String newParams = "";
                if (parameters.length != 0) {
                    for (Type i : parameters) {
                        newParams = newParams + "," + i.getClassName();
                    }
                    newParams = newParams.substring(1, newParams.length());
                }
                if (JdkPureMethodsList.instance.checkPurity(toAnalyze = fieldMethodCall.getCalledMethodsClass() + "." + fieldMethodCall.getCalledMethodName() + "(" + newParams + ")")) {
                    if (DefUsePool.addAsUse(fieldMethodCall)) continue;
                    throw new IllegalStateException("unable to register field method call as a use " + fieldMethodCall.toString());
                }
                if (DefUsePool.addAsDefinition(fieldMethodCall)) continue;
                throw new IllegalStateException("unable to register field method call as a definition " + fieldMethodCall.toString());
            }
            if (DefUsePool.addAsUse(fieldMethodCall)) continue;
            throw new IllegalStateException("unable to register field method call as a use " + fieldMethodCall.toString());
        }
    }

    private static Set<DefUseCoverageTestFitness> getCCFGPairs() {
        ClassControlFlowGraph ccfg = GraphPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getCCFG(Properties.TARGET_CLASS);
        AllUsesAnalysis aua = new AllUsesAnalysis(ccfg);
        Set<DefUseCoverageTestFitness> r = aua.determineDefUsePairs();
        return r;
    }

    public static DefUseCoverageTestFitness createGoal(Definition def, Use use, DefUseCoverageTestFitness.DefUsePairType type) {
        DefUseCoverageTestFitness goal = new DefUseCoverageTestFitness(def, use, type);
        if (DefUseCoverageFactory.registerGoal(goal)) {
            return goal;
        }
        return null;
    }

    public static DefUseCoverageTestFitness createGoal(BytecodeInstruction def, BytecodeInstruction use, DefUseCoverageTestFitness.DefUsePairType type) {
        if (def == null) {
            throw new IllegalArgumentException("null given as def");
        }
        if (use == null) {
            throw new IllegalArgumentException("null given as use");
        }
        Definition definition = DefUsePool.getDefinitionByInstruction(def);
        Use usee = DefUsePool.getUseByInstruction(use);
        if (definition == null || usee == null) {
            return null;
        }
        return DefUseCoverageFactory.createGoal(definition, usee, type);
    }

    private static boolean registerGoal(DefUseCoverageTestFitness goal) {
        if (!goalMap.containsKey(goal.getGoalDefinition())) {
            goalMap.put(goal.getGoalDefinition(), new HashMap());
        }
        if (goalMap.get(goal.getGoalDefinition()).containsKey(goal.getGoalUse())) {
            return false;
        }
        goalMap.get(goal.getGoalDefinition()).put(goal.getGoalUse(), goal);
        DefUseCoverageFactory.countGoal(goal);
        return true;
    }

    private static void countGoal(DefUseCoverageTestFitness goal) {
        if (goalCounts.get((Object)goal.getType()) == null) {
            goalCounts.put(goal.getType(), 0);
        }
        goalCounts.put(goal.getType(), goalCounts.get((Object)goal.getType()) + 1);
    }

    public static DefUseCoverageTestFitness retrieveGoal(int defId, int useId) {
        Definition def = DefUsePool.getDefinitionByDefId(defId);
        Use use = DefUsePool.getUseByUseId(useId);
        return DefUseCoverageFactory.retrieveGoal(def, use);
    }

    public static DefUseCoverageTestFitness retrieveGoal(Definition def, Use use) {
        if (!goalMap.containsKey(def)) {
            return null;
        }
        if (!goalMap.get(def).containsKey(use)) {
            return null;
        }
        return goalMap.get(def).get(use);
    }

    public static Set<DefUseCoverageTestFitness> getParameterGoals() {
        HashSet<DefUseCoverageTestFitness> r = new HashSet<DefUseCoverageTestFitness>();
        Set<Use> parameterUses = DefUsePool.retrieveRegisteredParameterUses();
        for (Use use : parameterUses) {
            DefUseCoverageTestFitness goal = new DefUseCoverageTestFitness(use);
            r.add(goal);
            DefUseCoverageFactory.countGoal(goal);
        }
        return r;
    }

    public static Set<Definition> getRegisteredDefinitions() {
        if (!called) {
            DefUseCoverageFactory.computeGoals();
        }
        return new HashSet<Definition>(goalMap.keySet());
    }

    public static Map<Use, DefUseCoverageTestFitness> getRegisteredGoalsForDefinition(Definition def) {
        if (!called) {
            DefUseCoverageFactory.computeGoals();
        }
        return goalMap.get(def);
    }

    public static int getParamGoalsCount() {
        Integer r = goalCounts.get((Object)DefUseCoverageTestFitness.DefUsePairType.PARAMETER);
        if (r == null) {
            return 0;
        }
        return r;
    }

    public static int getIntraMethodGoalsCount() {
        Integer r = goalCounts.get((Object)DefUseCoverageTestFitness.DefUsePairType.INTRA_METHOD);
        if (r == null) {
            return 0;
        }
        return r;
    }

    public static int getInterMethodGoalsCount() {
        Integer r = goalCounts.get((Object)DefUseCoverageTestFitness.DefUsePairType.INTER_METHOD);
        if (r == null) {
            return 0;
        }
        return r;
    }

    public static int getIntraClassGoalsCount() {
        Integer r = goalCounts.get((Object)DefUseCoverageTestFitness.DefUsePairType.INTRA_CLASS);
        if (r == null) {
            return 0;
        }
        return r;
    }

    public static void clear() {
        if (called) {
            called = false;
            duGoals.clear();
            goals.clear();
            goalMap.clear();
            goalCounts.clear();
        }
    }

    public static boolean detectAliasingGoals(List<ExecutionResult> results) {
        if (!Properties.DEFUSE_ALIASES) {
            return false;
        }
        HashSet<DefUseCoverageTestFitness> aliasingGoals = new HashSet<DefUseCoverageTestFitness>();
        for (ExecutionResult result : results) {
            aliasingGoals.addAll(DefUseCoverageFactory.detectAliasingGoals(result));
        }
        if (!aliasingGoals.isEmpty()) {
            goals.addAll(aliasingGoals);
            duGoals.addAll(aliasingGoals);
        }
        return !aliasingGoals.isEmpty();
    }

    private static Set<DefUseCoverageTestFitness> detectAliasingGoals(ExecutionResult result) {
        Map<String, HashMap<Integer, HashMap<Integer, Object>>> passedDefsObject = result.getTrace().getDefinitionDataObjects();
        Map<String, HashMap<Integer, HashMap<Integer, Object>>> passedUsesObject = result.getTrace().getUseDataObjects();
        Map<String, HashMap<Integer, HashMap<Integer, Integer>>> passedDefs = result.getTrace().getDefinitionData();
        Map<String, HashMap<Integer, HashMap<Integer, Integer>>> passedUses = result.getTrace().getUseData();
        HashSet<DefUseCoverageTestFitness> aliasingGoals = new HashSet<DefUseCoverageTestFitness>();
        for (String goalVariable : passedUsesObject.keySet()) {
            for (Integer objectId : passedUsesObject.get(goalVariable).keySet()) {
                for (Object o1 : passedUsesObject.get(goalVariable).get(objectId).values()) {
                    for (String otherGoalVariable : passedDefsObject.keySet()) {
                        for (Integer otherObjectId : passedDefsObject.get(otherGoalVariable).keySet()) {
                            for (Object o2 : passedDefsObject.get(otherGoalVariable).get(otherObjectId).values()) {
                                if (o1 == null || o1 != o2 || objectId != otherObjectId || goalVariable.equals(otherGoalVariable)) continue;
                                Map currentDefMap = passedDefs.get(otherGoalVariable).get(objectId);
                                Map currentUseMap = passedUses.get(goalVariable).get(objectId);
                                ArrayList duCounterTrace = new ArrayList(currentDefMap.keySet());
                                duCounterTrace.addAll(currentUseMap.keySet());
                                Collections.sort(duCounterTrace);
                                int traceLength = duCounterTrace.size();
                                Integer[] sortedDefDUTrace = duCounterTrace.toArray(new Integer[traceLength]);
                                int activeDef = -1;
                                for (int i = 0; i < traceLength; ++i) {
                                    int currentUse;
                                    DefUseCoverageTestFitness currentGoal;
                                    int currentDUCounter = sortedDefDUTrace[i];
                                    if (currentDefMap.containsKey(currentDUCounter)) {
                                        activeDef = (Integer)currentDefMap.get(currentDUCounter);
                                        continue;
                                    }
                                    if (activeDef == -1 || (currentGoal = DefUseCoverageFactory.retrieveGoal(activeDef, currentUse = ((Integer)currentUseMap.get(currentDUCounter)).intValue())) != null) continue;
                                    logger.info("New alias found: Variable defined as " + otherGoalVariable + " appeared in use as " + goalVariable);
                                    Definition def = DefUsePool.getDefinitionByDefId(activeDef);
                                    Use use = DefUsePool.getUseByUseId(currentUse);
                                    for (DefUseCoverageTestFitness defUse : duGoals) {
                                        if (!defUse.getGoalUse().equals(use)) continue;
                                        Map<Use, DefUseCoverageTestFitness> defUseMap = DefUseCoverageFactory.getRegisteredGoalsForDefinition(defUse.getGoalDefinition());
                                        for (Use otherUse : defUseMap.keySet()) {
                                            DefUseCoverageTestFitness goal = DefUseCoverageFactory.createGoal(def, otherUse, defUseMap.get(otherUse).getType());
                                            if (goal == null) continue;
                                            logger.info("Created new defuse pair: " + goal + " of type " + (Object)((Object)goal.getType()));
                                            aliasingGoals.add(goal);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return aliasingGoals;
    }

    static {
        goalMap = new HashMap<Definition, Map<Use, DefUseCoverageTestFitness>>();
        goalCounts = new HashMap<DefUseCoverageTestFitness.DefUsePairType, Integer>();
    }
}

