/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.dataflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.branch.BranchCoverageSuiteFitness;
import org.evosuite.coverage.dataflow.DefUseCoverageFactory;
import org.evosuite.coverage.dataflow.DefUseCoverageTestFitness;
import org.evosuite.coverage.dataflow.DefUseExecutionTraceAnalyzer;
import org.evosuite.coverage.dataflow.DefUseFitnessCalculator;
import org.evosuite.coverage.dataflow.DefUsePool;
import org.evosuite.coverage.dataflow.Definition;
import org.evosuite.ga.Chromosome;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.utils.LoggingUtils;

public class DefUseCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = 1L;
    List<DefUseCoverageTestFitness> goals = DefUseCoverageFactory.getDUGoals();
    public Map<DefUseCoverageTestFitness.DefUsePairType, Integer> totalGoals = DefUseCoverageSuiteFitness.initTotalGoals();
    public static final Map<DefUseCoverageTestFitness.DefUsePairType, Integer> mostCoveredGoals = new HashMap<DefUseCoverageTestFitness.DefUsePairType, Integer>();
    public Map<DefUseCoverageTestFitness.DefUsePairType, Integer> coveredGoals = new HashMap<DefUseCoverageTestFitness.DefUsePairType, Integer>();
    private final transient Map<Definition, Integer> maxDefinitionCount = new HashMap<Definition, Integer>();
    private final Map<String, Integer> maxMethodCount = new HashMap<String, Integer>();
    protected final BranchCoverageSuiteFitness branchFitness = new BranchCoverageSuiteFitness();

    public DefUseCoverageSuiteFitness() {
        for (DefUseCoverageTestFitness defUse : this.goals) {
            if (defUse.isParameterGoal()) {
                String methodName = defUse.getGoalUse().getMethodName();
                if (!this.maxMethodCount.containsKey(methodName)) {
                    this.maxMethodCount.put(methodName, 0);
                }
                this.maxMethodCount.put(methodName, this.maxMethodCount.get(methodName) + 1);
                continue;
            }
            Definition def = defUse.getGoalDefinition();
            if (def == null) {
                logger.warn("Def is null for " + defUse);
            }
            if (!this.maxDefinitionCount.containsKey(def)) {
                this.maxDefinitionCount.put(def, 0);
            }
            this.maxDefinitionCount.put(def, this.maxDefinitionCount.get(def) + 1);
        }
    }

    public double getFitnessAlternative(AbstractTestSuiteChromosome<? extends ExecutableChromosome> individual) {
        int max;
        boolean bl;
        TestSuiteChromosome suite = (TestSuiteChromosome)individual;
        List<ExecutionResult> results = this.runTestSuite(suite);
        if (DefUseCoverageFactory.detectAliasingGoals(results)) {
            logger.debug("New total number of goals: " + this.goals.size());
            this.totalGoals = DefUseCoverageSuiteFitness.initTotalGoals();
            for (DefUseCoverageTestFitness.DefUsePairType type : this.totalGoals.keySet()) {
                logger.info((Object)((Object)type) + ":" + this.totalGoals.get((Object)type));
            }
        }
        HashMap passedDefinitions = new HashMap();
        HashMap<Definition, Integer> passedDefinitionCount = new HashMap<Definition, Integer>();
        HashMap executedMethods = new HashMap();
        HashMap<Object, Integer> executedMethodsCount = new HashMap<Object, Integer>();
        for (Definition def : this.maxDefinitionCount.keySet()) {
            passedDefinitionCount.put(def, 0);
        }
        for (String methodName : this.maxMethodCount.keySet()) {
            executedMethodsCount.put(methodName, 0);
        }
        for (TestChromosome test : suite.getTestChromosomes()) {
            ExecutionResult result = test.getLastExecutionResult();
            if (result.hasTimeout()) {
                logger.debug("Skipping test with timeout");
                double fitness = this.goals.size() * 100;
                this.updateIndividual(this, individual, fitness);
                suite.setCoverage(this, 0.0);
                logger.debug("Test case has timed out, setting fitness to max value " + fitness);
                return fitness;
            }
            for (Map.Entry<Integer, Integer> entry : result.getTrace().getDefinitionExecutionCount().entrySet()) {
                Definition def = DefUsePool.getDefinitionByDefId(entry.getKey());
                if (def == null) {
                    logger.warn("Could not find def " + entry.getKey());
                    continue;
                }
                if (!passedDefinitions.containsKey(def)) {
                    passedDefinitions.put(def, new HashSet());
                }
                if (!passedDefinitionCount.containsKey(def)) {
                    passedDefinitionCount.put(def, 0);
                }
                ((Set)passedDefinitions.get(def)).add(test);
                passedDefinitionCount.put(def, (Integer)passedDefinitionCount.get(def) + entry.getValue());
            }
            for (Map.Entry<Object, Integer> entry : result.getTrace().getMethodExecutionCount().entrySet()) {
                if (executedMethodsCount.containsKey(entry.getKey())) {
                    executedMethodsCount.put(entry.getKey(), (Integer)executedMethodsCount.get(entry.getKey()) + entry.getValue());
                }
                if (!executedMethods.containsKey(entry.getKey())) {
                    executedMethods.put(entry.getKey(), new HashSet());
                }
                ((Set)executedMethods.get(entry.getKey())).add(test);
            }
        }
        double fitness = this.branchFitness.getFitness(individual);
        HashSet<DefUseCoverageTestFitness> coveredGoalsSet = new HashSet<DefUseCoverageTestFitness>();
        this.initCoverageMaps();
        HashSet<Definition> notFullyCoveredDefs = new HashSet<Definition>();
        boolean bl2 = false;
        for (DefUseCoverageTestFitness defUseCoverageTestFitness : this.goals) {
            if (coveredGoalsSet.contains(defUseCoverageTestFitness)) continue;
            double goalFitness = 2.0;
            HashSet coveringTests = new HashSet();
            if (defUseCoverageTestFitness.isParameterGoal()) {
                String methodKey = defUseCoverageTestFitness.getGoalUse().getClassName() + "." + defUseCoverageTestFitness.getGoalUse().getMethodName();
                if (executedMethods.containsKey(methodKey)) {
                    coveringTests.addAll((Collection)executedMethods.get(methodKey));
                }
            } else if (passedDefinitions.containsKey(defUseCoverageTestFitness.getGoalDefinition())) {
                coveringTests.addAll((Collection)passedDefinitions.get(defUseCoverageTestFitness.getGoalDefinition()));
            }
            if (coveringTests.isEmpty()) {
                logger.debug("No tests cover " + defUseCoverageTestFitness);
            } else {
                logger.debug("Checking " + coveringTests.size() + " tests covering " + defUseCoverageTestFitness);
            }
            for (TestChromosome test : coveringTests) {
                ExecutionResult result;
                DefUseFitnessCalculator calculator = new DefUseFitnessCalculator(defUseCoverageTestFitness, test, result = test.getLastExecutionResult());
                double resultFitness = calculator.calculateDUFitness();
                if (resultFitness < goalFitness) {
                    goalFitness = resultFitness;
                }
                if (goalFitness != 0.0) continue;
                result.test.addCoveredGoal(defUseCoverageTestFitness);
                coveredGoalsSet.add(defUseCoverageTestFitness);
                break;
            }
            if (goalFitness > 0.0) {
                if (defUseCoverageTestFitness.isParameterGoal()) {
                    notFullyCoveredDefs.add(defUseCoverageTestFitness.getGoalDefinition());
                } else {
                    bl = true;
                }
            }
            fitness += goalFitness;
        }
        for (Map.Entry entry : this.maxDefinitionCount.entrySet()) {
            int executionCount;
            if (!notFullyCoveredDefs.contains(entry.getKey()) || (executionCount = ((Integer)passedDefinitionCount.get(entry.getKey())).intValue()) >= (max = ((Integer)entry.getValue()).intValue())) continue;
            fitness += DefUseCoverageSuiteFitness.normalize(max - executionCount);
        }
        if (bl) {
            for (Map.Entry entry : this.maxMethodCount.entrySet()) {
                int executionCount = (Integer)executedMethodsCount.get(entry.getKey());
                if (executionCount >= (max = ((Integer)entry.getValue()).intValue())) continue;
                fitness += DefUseCoverageSuiteFitness.normalize(max - executionCount);
            }
        }
        this.countCoveredGoals(coveredGoalsSet);
        this.trackCoverageStatistics(suite);
        this.updateIndividual(this, individual, fitness);
        int coveredGoalCount = this.countCoveredGoals();
        int n = this.countTotalGoals();
        if (fitness == 0.0 && coveredGoalCount < n) {
            throw new IllegalStateException("Fitness 0 implies 100% coverage " + coveredGoalCount + " / " + this.totalGoals + " (covered / total)");
        }
        return fitness;
    }

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite) {
        if (Properties.ENABLE_ALTERNATIVE_SUITE_FITNESS) {
            return this.getFitnessAlternative(suite);
        }
        return this.getFitnessOld(suite);
    }

    public double getFitnessOld(Chromosome individual) {
        logger.trace("Calculating defuse fitness");
        TestSuiteChromosome suite = (TestSuiteChromosome)individual;
        List<ExecutionResult> results = this.runTestSuite(suite);
        double fitness = 0.0;
        if (DefUseCoverageFactory.detectAliasingGoals(results)) {
            this.goals = DefUseCoverageFactory.getDUGoals();
            logger.debug("New total number of goals: " + this.goals.size());
            this.totalGoals = DefUseCoverageSuiteFitness.initTotalGoals();
            for (DefUseCoverageTestFitness.DefUsePairType type : this.totalGoals.keySet()) {
                logger.info((Object)((Object)type) + ":" + this.totalGoals.get((Object)type));
            }
        }
        Set<DefUseCoverageTestFitness> coveredGoalsSet = DefUseExecutionTraceAnalyzer.getCoveredGoals(results);
        this.initCoverageMaps();
        for (DefUseCoverageTestFitness goal : this.goals) {
            if (coveredGoalsSet.contains(goal)) {
                goal.setCovered(true);
                continue;
            }
            double goalFitness = 2.0;
            for (ExecutionResult result : results) {
                TestChromosome tc = new TestChromosome();
                tc.setTestCase(result.test);
                double resultFitness = goal.getFitness(tc, result);
                if (resultFitness < goalFitness) {
                    goalFitness = resultFitness;
                }
                if (goalFitness != 0.0) continue;
                result.test.addCoveredGoal(goal);
                coveredGoalsSet.add(goal);
                goal.setCovered(true);
                break;
            }
            fitness += goalFitness;
        }
        this.countCoveredGoals(coveredGoalsSet);
        this.trackCoverageStatistics(suite);
        this.updateIndividual(this, suite, fitness);
        int coveredGoalCount = this.countCoveredGoals();
        int totalGoalCount = this.countTotalGoals();
        if (fitness == 0.0 && coveredGoalCount < totalGoalCount) {
            throw new IllegalStateException("Fitness 0 implies 100% coverage " + coveredGoalCount + " / " + this.totalGoals + " (covered / total)");
        }
        return fitness;
    }

    public static Map<DefUseCoverageTestFitness.DefUsePairType, Integer> initTotalGoals() {
        HashMap<DefUseCoverageTestFitness.DefUsePairType, Integer> r = new HashMap<DefUseCoverageTestFitness.DefUsePairType, Integer>();
        for (DefUseCoverageTestFitness.DefUsePairType type : DefUseCoverageTestFitness.DefUsePairType.values()) {
            r.put(type, 0);
        }
        int num = 0;
        for (DefUseCoverageTestFitness goal : DefUseCoverageFactory.getDUGoals()) {
            logger.info("Goal " + num);
            ++num;
            r.put(goal.getType(), (Integer)r.get((Object)goal.getType()) + 1);
        }
        return r;
    }

    private void initCoverageMaps() {
        for (DefUseCoverageTestFitness.DefUsePairType type : DefUseCoverageTestFitness.DefUsePairType.values()) {
            this.coveredGoals.put(type, 0);
            if (mostCoveredGoals.get((Object)type) != null) continue;
            mostCoveredGoals.put(type, 0);
        }
    }

    private int countCoveredGoals() {
        return DefUseCoverageSuiteFitness.countGoalsIn(this.coveredGoals);
    }

    public static int countMostCoveredGoals() {
        return DefUseCoverageSuiteFitness.countGoalsIn(mostCoveredGoals);
    }

    private int countTotalGoals() {
        return DefUseCoverageSuiteFitness.countGoalsIn(this.totalGoals);
    }

    private static int countGoalsIn(Map<DefUseCoverageTestFitness.DefUsePairType, Integer> goalMap) {
        int r = 0;
        for (DefUseCoverageTestFitness.DefUsePairType type : DefUseCoverageTestFitness.DefUsePairType.values()) {
            if (goalMap.get((Object)type) == null) continue;
            r += goalMap.get((Object)type).intValue();
        }
        return r;
    }

    private void trackCoverageStatistics(TestSuiteChromosome suite) {
        this.setMostCovered();
        this.setSuiteCoverage(suite);
    }

    private void countCoveredGoals(Set<DefUseCoverageTestFitness> coveredGoalsSet) {
        for (DefUseCoverageTestFitness goal : coveredGoalsSet) {
            this.coveredGoals.put(goal.getType(), this.coveredGoals.get((Object)goal.getType()) + 1);
        }
    }

    private void setSuiteCoverage(TestSuiteChromosome suite) {
        if (this.goals.size() > 0) {
            suite.setCoverage(this, (double)this.countCoveredGoals() / (double)this.goals.size());
        } else {
            suite.setCoverage(this, 1.0);
        }
    }

    private void setMostCovered() {
        for (DefUseCoverageTestFitness.DefUsePairType type : DefUseCoverageTestFitness.DefUsePairType.values()) {
            if (mostCoveredGoals.get((Object)type) >= this.coveredGoals.get((Object)type)) continue;
            mostCoveredGoals.put(type, this.coveredGoals.get((Object)type));
            if (mostCoveredGoals.get((Object)type) <= this.totalGoals.get((Object)type)) continue;
            throw new IllegalStateException("Can't cover more goals than there exist of type " + (Object)((Object)type) + " " + mostCoveredGoals.get((Object)type) + " / " + this.totalGoals.get((Object)type) + " (mostCovered / total)");
        }
    }

    public static void printCoverage() {
        LoggingUtils.getEvoLogger().info("* Time spent optimizing covered goals analysis: " + DefUseExecutionTraceAnalyzer.timeGetCoveredGoals + "ms");
        Map<DefUseCoverageTestFitness.DefUsePairType, Integer> totalGoals = DefUseCoverageSuiteFitness.initTotalGoals();
        for (DefUseCoverageTestFitness.DefUsePairType type : DefUseCoverageTestFitness.DefUsePairType.values()) {
            LoggingUtils.getEvoLogger().info("* Covered goals of type " + (Object)((Object)type) + ": " + mostCoveredGoals.get((Object)type) + " / " + totalGoals.get((Object)type));
            for (DefUseCoverageTestFitness pair : DefUseCoverageSuiteFitness.getPairsOfType(type)) {
                if (pair.isCovered()) {
                    LoggingUtils.getEvoLogger().info("*(X) " + pair.toString());
                    continue;
                }
                LoggingUtils.getEvoLogger().info("*( ) " + pair.toString());
            }
        }
        LoggingUtils.getEvoLogger().info("* Covered " + DefUseCoverageSuiteFitness.countMostCoveredGoals() + "/" + DefUseCoverageSuiteFitness.countGoalsIn(totalGoals) + " goals");
    }

    private static ArrayList<DefUseCoverageTestFitness> getPairsOfType(DefUseCoverageTestFitness.DefUsePairType type) {
        ArrayList<DefUseCoverageTestFitness> pairs = new ArrayList<DefUseCoverageTestFitness>();
        for (DefUseCoverageTestFitness pair : DefUseCoverageFactory.getDUGoals()) {
            if (pair.getType() != type) continue;
            pairs.add(pair);
        }
        return pairs;
    }
}

