/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.dataflow.analysis;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.evosuite.coverage.dataflow.DefUseCoverageFactory;
import org.evosuite.coverage.dataflow.DefUseCoverageTestFitness;
import org.evosuite.coverage.dataflow.analysis.MethodCall;
import org.evosuite.coverage.dataflow.analysis.VariableDefinition;
import org.evosuite.graphs.ccfg.CCFGCodeNode;
import org.evosuite.graphs.ccfg.CCFGEdge;
import org.evosuite.graphs.ccfg.CCFGFieldClassCallNode;
import org.evosuite.graphs.ccfg.CCFGFrameNode;
import org.evosuite.graphs.ccfg.CCFGMethodCallNode;
import org.evosuite.graphs.ccfg.CCFGMethodEntryNode;
import org.evosuite.graphs.ccfg.CCFGMethodExitNode;
import org.evosuite.graphs.ccfg.CCFGMethodReturnNode;
import org.evosuite.graphs.ccfg.CCFGNode;
import org.evosuite.graphs.ccfg.ClassControlFlowGraph;
import org.evosuite.graphs.ccg.ClassCallNode;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.utils.LoggingUtils;

public class AllUsesAnalysis {
    private final int UPPER_PAIR_SEARCH_INVOCATION_BOUND = 2000000;
    private boolean warnedAboutAbortion = false;
    private ClassControlFlowGraph ccfg;
    private Map<String, Set<Map<String, BytecodeInstruction>>> determinedActiveDefs = new HashMap<String, Set<Map<String, BytecodeInstruction>>>();
    private Map<String, Set<BytecodeInstruction>> determinedFreeUses = new HashMap<String, Set<BytecodeInstruction>>();
    private Set<CCFGMethodEntryNode> analyzedMethods = new HashSet<CCFGMethodEntryNode>();
    private long timeSpentMingling = 0L;

    public AllUsesAnalysis(ClassControlFlowGraph ccfg) {
        this.ccfg = ccfg;
    }

    public Set<DefUseCoverageTestFitness> determineDefUsePairs() {
        Set<DefUseCoverageTestFitness> r = this.preAnalyzeMethods();
        for (CCFGMethodEntryNode publicMethodEntry : this.ccfg.publicMethods) {
            if (this.analyzedMethods.contains(publicMethodEntry)) continue;
            if (publicMethodEntry.getEntryInstruction() == null) {
                throw new IllegalStateException("expect each CCFGMethodEntryNode to have its entryInstruction set");
            }
            r.addAll(this.determineIntraInterMethodPairs(publicMethodEntry));
        }
        r.addAll(this.createIntraClassPairs());
        this.freeMemory();
        return r;
    }

    private Set<DefUseCoverageTestFitness> preAnalyzeMethods() {
        HashSet<DefUseCoverageTestFitness> r = new HashSet<DefUseCoverageTestFitness>();
        LinkedList<ClassCallNode> toAnalyze = new LinkedList<ClassCallNode>();
        toAnalyze.addAll(this.getInitialPreAnalyzeableMethods());
        while (!toAnalyze.isEmpty()) {
            ClassCallNode currentMethod = (ClassCallNode)toAnalyze.poll();
            CCFGMethodEntryNode analyzeableEntry = this.ccfg.getMethodEntryNodeForClassCallNode(currentMethod);
            if (this.analyzedMethods.contains(analyzeableEntry)) continue;
            r.addAll(this.determineIntraInterMethodPairs(analyzeableEntry));
            Set<ClassCallNode> parents = this.ccfg.getCcg().getParents(currentMethod);
            for (ClassCallNode parent : parents) {
                if (toAnalyze.contains(parent) || this.analyzedMethods.contains(this.ccfg.getMethodEntryNodeForClassCallNode(parent))) continue;
                Set<ClassCallNode> parentsChildren = this.ccfg.getCcg().getChildren(parent);
                boolean canAnalyzeNow = true;
                for (ClassCallNode parentsChild : parentsChildren) {
                    if (parentsChild == null || parentsChild.equals(parent) || toAnalyze.contains(parentsChild) || this.analyzedMethods.contains(this.ccfg.getMethodEntryNodeForClassCallNode(parentsChild))) continue;
                    canAnalyzeNow = false;
                    break;
                }
                if (!canAnalyzeNow) continue;
                toAnalyze.offer(parent);
            }
        }
        return r;
    }

    private Set<ClassCallNode> getInitialPreAnalyzeableMethods() {
        HashSet<ClassCallNode> preAnalyzeable = new HashSet<ClassCallNode>();
        for (ClassCallNode ccgNode : this.ccfg.getCcg().vertexSet()) {
            boolean add = true;
            for (ClassCallNode child : this.ccfg.getCcg().getChildren(ccgNode)) {
                if (child == null || child.equals(ccgNode)) continue;
                add = false;
            }
            if (!add) continue;
            preAnalyzeable.add(ccgNode);
        }
        return preAnalyzeable;
    }

    private Set<DefUseCoverageTestFitness> createIntraClassPairs() {
        HashSet<DefUseCoverageTestFitness> r = new HashSet<DefUseCoverageTestFitness>();
        for (String method : this.determinedFreeUses.keySet()) {
            if (!this.ccfg.isPublicMethod(method)) continue;
            for (BytecodeInstruction freeUse : this.determinedFreeUses.get(method)) {
                r.addAll(this.createIntraClassPairsForFreeUse(freeUse));
            }
        }
        return r;
    }

    private Set<DefUseCoverageTestFitness> createIntraClassPairsForFreeUse(BytecodeInstruction freeUse) {
        this.checkFreeUseSanity(freeUse);
        HashSet<DefUseCoverageTestFitness> r = new HashSet<DefUseCoverageTestFitness>();
        for (String method : this.determinedActiveDefs.keySet()) {
            if (!this.ccfg.isPublicMethod(method)) continue;
            Set<Map<String, BytecodeInstruction>> activeDefss = this.determinedActiveDefs.get(method);
            for (Map<String, BytecodeInstruction> activeDefs : activeDefss) {
                BytecodeInstruction activeDef = activeDefs.get(freeUse.getVariableName());
                if (activeDef == null) continue;
                this.addNewGoalToFoundPairs(null, activeDef, freeUse, DefUseCoverageTestFitness.DefUsePairType.INTRA_CLASS, r);
            }
        }
        return r;
    }

    private Set<DefUseCoverageTestFitness> determineIntraInterMethodPairs(CCFGMethodEntryNode methodEntry) {
        long start = System.currentTimeMillis();
        long mingled = this.timeSpentMingling;
        LoggingUtils.getEvoLogger().debug("* Searching for pairs in " + methodEntry.getMethod() + " ... ");
        this.warnedAboutAbortion = false;
        HashSet<DefUseCoverageTestFitness> foundPairs = new HashSet<DefUseCoverageTestFitness>();
        Set<Map<String, VariableDefinition>> activeDefs = this.createInitialActiveDefs();
        HashSet<BytecodeInstruction> freeUses = new HashSet<BytecodeInstruction>();
        Stack<MethodCall> callStack = this.createInitialCallStack(methodEntry);
        Integer calls = this.determineIntraInterMethodPairs(methodEntry, methodEntry.getEntryInstruction(), new HashSet<CCFGNode>(), new HashSet<CCFGEdge>(), activeDefs, freeUses, foundPairs, callStack, 0, true);
        long spentTime = System.currentTimeMillis() - start;
        Integer rerunCalls = 0;
        mingled = this.timeSpentMingling - mingled;
        System.out.println("  invocations: " + (calls + rerunCalls) + " took " + spentTime + "ms (" + mingled + ") found " + foundPairs.size() + " pairs");
        this.analyzedMethods.add(methodEntry);
        return foundPairs;
    }

    private int determineIntraInterMethodPairs(CCFGMethodEntryNode investigatedMethod, CCFGNode node, Set<CCFGNode> handled, Set<CCFGEdge> handledBackEdges, Set<Map<String, VariableDefinition>> activeDefs, Set<BytecodeInstruction> freeUses, Set<DefUseCoverageTestFitness> foundPairs, Stack<MethodCall> callStack, int invocationCount, boolean handleLoops) {
        this.handleHandledNodesSet(node, handled);
        if (this.checkInvocationBound(++invocationCount, callStack)) {
            return invocationCount;
        }
        if (node instanceof CCFGFieldClassCallNode) {
            this.handleFieldCallNode(investigatedMethod, node, callStack, activeDefs, freeUses, foundPairs);
        } else if (node instanceof CCFGCodeNode) {
            this.handleCodeNode(investigatedMethod, node, callStack, activeDefs, freeUses, foundPairs);
        } else if (node instanceof CCFGMethodCallNode) {
            handled = this.handleMethodCallNode(node, callStack, handled);
        } else if (node instanceof CCFGMethodReturnNode) {
            this.handleMethodReturnNode(node, callStack);
        } else if (node instanceof CCFGFrameNode) {
            this.handleFrameNode();
        } else if (node instanceof CCFGMethodExitNode) {
            this.handleMethodExitNode(node, investigatedMethod, activeDefs, freeUses);
        }
        node = this.determineNextRelevantNode(node, handled);
        Set<CCFGNode> children = this.ccfg.getChildren(node);
        boolean skipChildren = this.shouldSkipChildren(node, handledBackEdges, children, handleLoops);
        if (!skipChildren) {
            for (CCFGNode child : children) {
                if (!this.shouldProcessChild(node, child, handled, handledBackEdges, handleLoops)) continue;
                Stack<MethodCall> nextCallStack = callStack;
                if (child instanceof CCFGMethodReturnNode) {
                    if (this.handleReturnNodeChild(child, callStack)) {
                        continue;
                    }
                } else {
                    CCFGMethodCallNode callNode;
                    if (child instanceof CCFGFrameNode) {
                        this.handleFrameNodeChild(child);
                        continue;
                    }
                    if (child instanceof CCFGMethodCallNode && this.alreadyAnalzedMethod((callNode = (CCFGMethodCallNode)child).getCalledMethod())) {
                        nextCallStack = this.copyCallStack(callStack);
                        activeDefs = this.handleMethodCallNodeChild(callNode, activeDefs, freeUses, foundPairs, nextCallStack, investigatedMethod);
                        child = callNode.getReturnNode();
                    }
                }
                if ((invocationCount = children.size() > 1 ? this.determineIntraInterMethodPairs(investigatedMethod, child, new HashSet<CCFGNode>(handled), new HashSet<CCFGEdge>(handledBackEdges), this.copyActiveDefs(activeDefs), new HashSet<BytecodeInstruction>(freeUses), foundPairs, this.copyCallStack(nextCallStack), invocationCount, handleLoops) : this.determineIntraInterMethodPairs(investigatedMethod, child, handled, handledBackEdges, activeDefs, freeUses, foundPairs, nextCallStack, invocationCount, handleLoops)) < 2000000) continue;
            }
        }
        return invocationCount;
    }

    private Set<Map<String, VariableDefinition>> handleMethodCallNodeChild(CCFGMethodCallNode callNode, Set<Map<String, VariableDefinition>> activeDefs, Set<BytecodeInstruction> freeUses, Set<DefUseCoverageTestFitness> foundPairs, Stack<MethodCall> callStack, CCFGMethodEntryNode investigatedMethod) {
        MethodCall call = MethodCall.constructForCallNode(callNode);
        activeDefs = this.useStoredInformationForMethodCall(investigatedMethod, callNode, activeDefs, freeUses, foundPairs, call);
        this.updateCallStackForCall(callStack, call);
        return activeDefs;
    }

    private void handleHandledNodesSet(CCFGNode node, Set<CCFGNode> handled) {
        if (handled.contains(node)) {
            LoggingUtils.getEvoLogger().info("We are in a recursive call. Skipping the node");
        }
        handled.add(node);
    }

    private Set<CCFGNode> handleMethodCallNode(CCFGNode node, Stack<MethodCall> callStack, Set<CCFGNode> handled) {
        CCFGMethodCallNode callNode = (CCFGMethodCallNode)node;
        this.updateCallStackForCallNode(callStack, callNode);
        return this.filterHandledMapForMethodCallNode(callNode, handled);
    }

    private void handleMethodReturnNode(CCFGNode node, Stack<MethodCall> callStack) {
        if (callStack.peek().isInitialMethodCall()) {
            throw new IllegalStateException("found method return but had no more method calls on stack");
        }
        CCFGMethodReturnNode retrn = (CCFGMethodReturnNode)node;
        if (!callStack.peek().isMethodCallFor(retrn.getCallInstruction())) {
            throw new IllegalStateException("visiting MethodReturnNode even though lastly visited MethodCallNode was from a different method");
        }
        callStack.pop();
    }

    private void handleFrameNode() {
        throw new IllegalStateException("visiting CCFGFrameNode during pair search, which should not happen");
    }

    private void handleMethodExitNode(CCFGNode node, CCFGMethodEntryNode investigatedMethod, Set<Map<String, VariableDefinition>> activeDefs, Set<BytecodeInstruction> freeUses) {
        CCFGMethodExitNode exitNode = (CCFGMethodExitNode)node;
        if (exitNode.isExitOfMethodEntry(investigatedMethod)) {
            this.rememberActiveDefs(exitNode.getMethod(), activeDefs);
            this.rememberFreeUses(exitNode.getMethod(), freeUses);
        }
    }

    private void handleFieldCallNode(CCFGMethodEntryNode investigatedMethod, CCFGNode node, Stack<MethodCall> callStack, Set<Map<String, VariableDefinition>> activeDefs, Set<BytecodeInstruction> freeUses, Set<DefUseCoverageTestFitness> foundPairs) {
        BytecodeInstruction code = ((CCFGCodeNode)node).getCodeInstruction();
        this.handleDefUse(investigatedMethod, code, callStack, activeDefs, freeUses, foundPairs);
    }

    private void handleCodeNode(CCFGMethodEntryNode investigatedMethod, CCFGNode node, Stack<MethodCall> callStack, Set<Map<String, VariableDefinition>> activeDefs, Set<BytecodeInstruction> freeUses, Set<DefUseCoverageTestFitness> foundPairs) {
        BytecodeInstruction code = ((CCFGCodeNode)node).getCodeInstruction();
        this.handleDefUse(investigatedMethod, code, callStack, activeDefs, freeUses, foundPairs);
    }

    private void handleDefUse(CCFGMethodEntryNode investigatedMethod, BytecodeInstruction code, Stack<MethodCall> callStack, Set<Map<String, VariableDefinition>> activeDefs, Set<BytecodeInstruction> freeUses, Set<DefUseCoverageTestFitness> foundPairs) {
        this.checkCallStackSanity(callStack, code);
        if (code.isUse()) {
            this.handleUseInstruction(investigatedMethod, code, callStack, activeDefs, freeUses, foundPairs);
        }
        if (code.isDefinition()) {
            this.handleDefInstruction(code, callStack, activeDefs);
        }
    }

    private void handleDefInstruction(BytecodeInstruction code, Stack<MethodCall> callStack, Set<Map<String, VariableDefinition>> activeDefMaps) {
        VariableDefinition def = new VariableDefinition(code, callStack.peek());
        for (Map<String, VariableDefinition> activeDefMap : activeDefMaps) {
            activeDefMap.put(code.getVariableName(), def);
        }
    }

    private void handleUseInstruction(CCFGMethodEntryNode investigatedMethod, BytecodeInstruction code, Stack<MethodCall> callStack, Set<Map<String, VariableDefinition>> activeDefMaps, Set<BytecodeInstruction> freeUses, Set<DefUseCoverageTestFitness> foundPairs) {
        String varName = code.getVariableName();
        for (Map<String, VariableDefinition> activeDefs : activeDefMaps) {
            VariableDefinition activeDef = activeDefs.get(varName);
            if (activeDef != null) {
                boolean isIntraPair = activeDef.getMethodCall().equals(callStack.peek());
                DefUseCoverageTestFitness.DefUsePairType type = isIntraPair ? DefUseCoverageTestFitness.DefUsePairType.INTRA_METHOD : DefUseCoverageTestFitness.DefUsePairType.INTER_METHOD;
                if (activeDef.getDefinition().isLocalDU() && !type.equals((Object)DefUseCoverageTestFitness.DefUsePairType.INTRA_METHOD)) continue;
                this.addNewGoalToFoundPairs(investigatedMethod, activeDef, code, type, foundPairs);
                continue;
            }
            if (!code.isFieldUse()) continue;
            freeUses.add(code);
        }
    }

    private boolean shouldSkipChildren(CCFGNode node, Set<CCFGEdge> handledBackEdges, Set<CCFGNode> children, boolean handleLoops) {
        if (node == null || children == null) {
            return true;
        }
        boolean skipChildren = false;
        if (handleLoops) {
            for (CCFGNode child : children) {
                CCFGEdge currentEdge = (CCFGEdge)((Object)this.ccfg.getEdge(node, child));
                if (!handledBackEdges.contains((Object)currentEdge)) continue;
                skipChildren = true;
                break;
            }
        }
        return skipChildren;
    }

    private boolean shouldProcessChild(CCFGNode node, CCFGNode child, Set<CCFGNode> handled, Set<CCFGEdge> handledBackEdges, boolean handleLoops) {
        if (handleLoops) {
            CCFGEdge currentEdge = (CCFGEdge)((Object)this.ccfg.getEdge(node, child));
            if (handledBackEdges.contains((Object)currentEdge)) {
                throw new IllegalStateException("should have been detected earlier");
            }
            if (handled.contains(child)) {
                handledBackEdges.add(currentEdge);
                handled.clear();
            }
        } else if (handled.contains(child)) {
            return false;
        }
        return true;
    }

    private CCFGNode determineNextRelevantNode(CCFGNode node, Set<CCFGNode> handled) {
        CCFGNode nextNode;
        while (this.ccfg.outDegreeOf(node) == 1 && (nextNode = this.ccfg.getSingleChild(node)) instanceof CCFGCodeNode && !((CCFGCodeNode)nextNode).getCodeInstruction().isDefUse() && !handled.contains(nextNode)) {
            node = nextNode;
        }
        return node;
    }

    private Set<Map<String, VariableDefinition>> copyActiveDefs(Set<Map<String, VariableDefinition>> activeDefs) {
        HashSet<Map<String, VariableDefinition>> r = new HashSet<Map<String, VariableDefinition>>();
        for (Map<String, VariableDefinition> activeDef : activeDefs) {
            r.add(new HashMap<String, VariableDefinition>(activeDef));
        }
        return r;
    }

    private Set<Map<String, VariableDefinition>> useStoredInformationForMethodCall(CCFGMethodEntryNode investigatedMethod, CCFGMethodCallNode callNode, Set<Map<String, VariableDefinition>> activeDefMapsInCaller, Set<BytecodeInstruction> freeUses, Set<DefUseCoverageTestFitness> foundPairs, MethodCall call) {
        Set<BytecodeInstruction> freeUsesInCalledMethod = this.determinedFreeUses.get(callNode.getCalledMethod());
        for (BytecodeInstruction freeUseInCalledMethod : freeUsesInCalledMethod) {
            for (Map<String, VariableDefinition> activeDefMap : activeDefMapsInCaller) {
                VariableDefinition activeDef = activeDefMap.get(freeUseInCalledMethod.getVariableName());
                if (activeDef == null) {
                    freeUses.add(freeUseInCalledMethod);
                    continue;
                }
                if (!freeUseInCalledMethod.isFieldUse()) continue;
                this.addNewGoalToFoundPairs(investigatedMethod, activeDef, freeUseInCalledMethod, DefUseCoverageTestFitness.DefUsePairType.INTER_METHOD, foundPairs);
            }
        }
        Set<Map<String, BytecodeInstruction>> activeDefMapsInCallee = this.determinedActiveDefs.get(callNode.getCalledMethod());
        HashSet<Map<String, VariableDefinition>> activeDefMapsAfterCurrentCall = new HashSet<Map<String, VariableDefinition>>();
        long start = System.currentTimeMillis();
        for (Map<String, BytecodeInstruction> activeDefMapInCallee : activeDefMapsInCallee) {
            for (Map<String, VariableDefinition> activeDefMapInCaller : activeDefMapsInCaller) {
                HashSet<String> relevantVariables = new HashSet<String>(activeDefMapInCallee.keySet());
                relevantVariables.addAll(activeDefMapInCaller.keySet());
                HashMap<String, VariableDefinition> activeDefMapAfterCurrentCall = new HashMap<String, VariableDefinition>();
                for (String variable : relevantVariables) {
                    BytecodeInstruction activeDefAfterCall = activeDefMapInCallee.get(variable);
                    VariableDefinition activeDefPriorToCall = activeDefMapInCaller.get(variable);
                    if (activeDefAfterCall == null) {
                        if (activeDefPriorToCall == null) {
                            throw new IllegalStateException("expect activeDefMaps not to map to null values");
                        }
                        activeDefMapAfterCurrentCall.put(variable, activeDefPriorToCall);
                        continue;
                    }
                    VariableDefinition overwritingDefinition = new VariableDefinition(activeDefAfterCall, call);
                    activeDefMapAfterCurrentCall.put(variable, overwritingDefinition);
                }
                activeDefMapsAfterCurrentCall.add(activeDefMapAfterCurrentCall);
            }
        }
        this.timeSpentMingling += System.currentTimeMillis() - start;
        return activeDefMapsAfterCurrentCall;
    }

    private boolean alreadyAnalzedMethod(String method) {
        if (this.determinedFreeUses.get(method) != null) {
            if (this.determinedActiveDefs.get(method) == null) {
                throw new IllegalStateException("found already determined freeUse but no activeDefs for method " + method);
            }
            return true;
        }
        return false;
    }

    private void updateCallStackForCallNode(Stack<MethodCall> callStack, CCFGMethodCallNode callNode) {
        MethodCall call = MethodCall.constructForCallNode(callNode);
        this.updateCallStackForCall(callStack, call);
    }

    private void updateCallStackForCall(Stack<MethodCall> callStack, MethodCall call) {
        callStack.push(call);
    }

    private void addNewGoalToFoundPairs(CCFGMethodEntryNode investigatedMethod, VariableDefinition activeDef, BytecodeInstruction code, DefUseCoverageTestFitness.DefUsePairType type, Set<DefUseCoverageTestFitness> foundPairs) {
        this.addNewGoalToFoundPairs(investigatedMethod, activeDef.getDefinition(), code, type, foundPairs);
    }

    private void addNewGoalToFoundPairs(CCFGMethodEntryNode investigatedMethod, BytecodeInstruction activeDef, BytecodeInstruction freeUse, DefUseCoverageTestFitness.DefUsePairType type, Set<DefUseCoverageTestFitness> foundPairs) {
        this.checkDefinitionSanity(activeDef);
        this.checkUseSanity(freeUse);
        if (type.equals((Object)DefUseCoverageTestFitness.DefUsePairType.INTER_METHOD) && !this.ccfg.isPublicMethod(investigatedMethod)) {
            return;
        }
        DefUseCoverageTestFitness goal = DefUseCoverageFactory.createGoal(activeDef, freeUse, type);
        if (goal != null) {
            foundPairs.add(goal);
        }
    }

    private boolean handleReturnNodeChild(CCFGNode child, Stack<MethodCall> callStack) {
        if (callStack.peek().isInitialMethodCall()) {
            return true;
        }
        CCFGMethodReturnNode retrn = (CCFGMethodReturnNode)child;
        return !callStack.peek().isMethodCallFor(retrn.getCallInstruction());
    }

    private void handleFrameNodeChild(CCFGNode child) {
        CCFGFrameNode frameNode = (CCFGFrameNode)child;
        if (!frameNode.getType().equals((Object)ClassControlFlowGraph.FrameNodeType.RETURN)) {
            throw new IllegalStateException("found CCFGFrameNode that was not of type RETURN. should not be possible " + frameNode.toString());
        }
    }

    private void rememberActiveDefs(String method, Set<Map<String, VariableDefinition>> activeDefMaps) {
        if (this.determinedActiveDefs.get(method) == null) {
            this.determinedActiveDefs.put(method, new HashSet());
        }
        Set<Map<String, BytecodeInstruction>> defMaps = this.toRememberableBytecodeInstructionMap(activeDefMaps);
        for (Map<String, BytecodeInstruction> defMap : defMaps) {
            this.determinedActiveDefs.get(method).add(defMap);
        }
    }

    private void rememberFreeUses(String method, Set<BytecodeInstruction> freeUses) {
        if (this.determinedFreeUses.get(method) == null) {
            this.determinedFreeUses.put(method, new HashSet());
        }
        this.determinedFreeUses.get(method).addAll(freeUses);
    }

    private Stack<MethodCall> copyCallStack(Stack<MethodCall> callStack) {
        Stack<MethodCall> r = new Stack<MethodCall>();
        r.setSize(callStack.size());
        Collections.copy(r, callStack);
        return r;
    }

    private Set<CCFGNode> filterHandledMapForMethodCallNode(CCFGMethodCallNode callNode, Set<CCFGNode> handled) {
        HashSet<CCFGNode> r = new HashSet<CCFGNode>();
        for (CCFGNode node : handled) {
            if (this.nodeBelongsToMethod(node, callNode.getCalledMethod()) && !(node instanceof CCFGMethodCallNode)) continue;
            r.add(node);
        }
        r.add(callNode);
        return r;
    }

    private boolean nodeBelongsToMethod(CCFGNode node, String method) {
        if (node instanceof CCFGCodeNode) {
            return ((CCFGCodeNode)node).getMethod().equals(method);
        }
        if (node instanceof CCFGMethodCallNode) {
            return ((CCFGMethodCallNode)node).getMethod().equals(method);
        }
        if (node instanceof CCFGMethodReturnNode) {
            return ((CCFGMethodReturnNode)node).getMethod().equals(method);
        }
        if (node instanceof CCFGMethodEntryNode) {
            return ((CCFGMethodEntryNode)node).getMethod().equals(method);
        }
        if (node instanceof CCFGMethodExitNode) {
            return ((CCFGMethodExitNode)node).getMethod().equals(method);
        }
        return false;
    }

    private void freeMemory() {
        this.determinedActiveDefs = null;
        this.determinedFreeUses = null;
        this.analyzedMethods = null;
    }

    private boolean checkInvocationBound(int invocationCount, Stack<MethodCall> callStack) {
        if (invocationCount % 200000 == 0) {
            int percent = invocationCount / 200000;
            System.out.print(percent + "0% .. ");
        }
        if (invocationCount >= 2000000) {
            if (!this.warnedAboutAbortion) {
                System.out.println();
                System.out.println("* ABORTED inter method pair search in " + callStack.peek() + "! Reached maximum invocation limit: " + 2000000);
                this.warnedAboutAbortion = true;
            }
            return true;
        }
        return false;
    }

    private void checkCallStackSanity(Stack<MethodCall> callStack, BytecodeInstruction code) {
        if (!callStack.peek().getCalledMethodName().equals(code.getMethodName())) {
            for (MethodCall mc : callStack) {
                System.out.println("  " + mc.toString());
            }
            throw new IllegalStateException("insane callStack: peek is in method " + callStack.peek().getCalledMethodName() + " and i encountered code of method " + code.getMethodName());
        }
    }

    private void checkFreeUseSanity(BytecodeInstruction freeUse) {
        this.checkUseSanity(freeUse);
        if (!freeUse.isFieldUse()) {
            throw new IllegalStateException("expect all freeUses to be Use instructions for field variable");
        }
    }

    private void checkUseSanity(BytecodeInstruction freeUse) {
        if (freeUse == null) {
            throw new IllegalStateException("null values not allowed in freeUses map");
        }
        if (!freeUse.isUse()) {
            throw new IllegalStateException("expect all freeUses to be Use instructions");
        }
    }

    private void checkDefinitionSanity(BytecodeInstruction activeDef) {
        if (activeDef == null) {
            throw new IllegalStateException("null values not allowed in activeDef map");
        }
        if (!activeDef.isDefinition()) {
            throw new IllegalStateException("expect all activeDefs to be Definition instructions");
        }
    }

    private Set<Map<String, BytecodeInstruction>> toRememberableBytecodeInstructionMap(Set<Map<String, VariableDefinition>> activeDefMaps) {
        HashSet<Map<String, BytecodeInstruction>> r = new HashSet<Map<String, BytecodeInstruction>>();
        for (Map<String, VariableDefinition> activeDefMap : activeDefMaps) {
            HashMap<String, BytecodeInstruction> instructionMap = new HashMap<String, BytecodeInstruction>();
            for (String var : activeDefMap.keySet()) {
                VariableDefinition activeDef = activeDefMap.get(var);
                if (activeDef.getDefinition().isLocalDU()) continue;
                instructionMap.put(var, activeDef.getDefinition());
            }
            r.add(instructionMap);
        }
        return r;
    }

    private Set<Map<String, VariableDefinition>> createInitialActiveDefs() {
        HashSet<Map<String, VariableDefinition>> activeDefs = new HashSet<Map<String, VariableDefinition>>();
        activeDefs.add(new HashMap());
        return activeDefs;
    }

    private Stack<MethodCall> createInitialCallStack(CCFGMethodEntryNode publicMethodEntry) {
        Stack<MethodCall> callStack = new Stack<MethodCall>();
        callStack.add(new MethodCall(null, publicMethodEntry.getMethod()));
        return callStack;
    }
}

