/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.exception;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.exception.ExceptionCoverageFactory;
import org.evosuite.coverage.exception.ExceptionCoverageTestFitness;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = 1565793073526627496L;
    private static Logger logger = LoggerFactory.getLogger(ExceptionCoverageSuiteFitness.class);
    private static int maxExceptionsCovered = 0;

    public static int getMaxExceptionsCovered() {
        return maxExceptionsCovered;
    }

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite) {
        logger.trace("Calculating exception fitness");
        HashMap implicitTypesOfExceptions = new HashMap();
        HashMap explicitTypesOfExceptions = new HashMap();
        HashMap declaredTypesOfExceptions = new HashMap();
        List<ExecutionResult> results = this.runTestSuite(suite);
        ExceptionCoverageSuiteFitness.calculateExceptionInfo(results, implicitTypesOfExceptions, explicitTypesOfExceptions, declaredTypesOfExceptions);
        int nExc = ExceptionCoverageSuiteFitness.getNumExceptions(implicitTypesOfExceptions) + ExceptionCoverageSuiteFitness.getNumExceptions(explicitTypesOfExceptions) + ExceptionCoverageSuiteFitness.getNumExceptions(declaredTypesOfExceptions);
        if (nExc > maxExceptionsCovered) {
            logger.info("(Exceptions) Best individual covers " + nExc + " exceptions");
            maxExceptionsCovered = nExc;
        }
        suite.setCoverage(this, (double)nExc / ((double)nExc + 1.0));
        double exceptionFitness = 1.0 / (1.0 + (double)nExc);
        suite.setFitness(this, exceptionFitness);
        return exceptionFitness;
    }

    public static void calculateExceptionInfo(List<ExecutionResult> results, Map<String, Set<Class<?>>> implicitTypesOfExceptions, Map<String, Set<Class<?>>> explicitTypesOfExceptions, Map<String, Set<Class<?>>> declaredTypesOfExceptions) throws IllegalArgumentException {
        if (!(results != null && implicitTypesOfExceptions != null && explicitTypesOfExceptions != null && implicitTypesOfExceptions.isEmpty() && explicitTypesOfExceptions.isEmpty() && declaredTypesOfExceptions != null && declaredTypesOfExceptions.isEmpty())) {
            throw new IllegalArgumentException();
        }
        HashMap<TestCase, Map<Integer, Boolean>> isExceptionExplicit = new HashMap<TestCase, Map<Integer, Boolean>>();
        for (ExecutionResult result : results) {
            isExceptionExplicit.put(result.test, result.explicitExceptions);
            for (Integer i : result.getPositionsWhereExceptionsWereThrown()) {
                Throwable t;
                if (i >= result.test.size() || (t = result.getExceptionThrownAtPosition(i)) instanceof SecurityException && Properties.SANDBOX || t.getStackTrace().length > 0 && t.getStackTrace()[0].getClassName().startsWith("org.evosuite.testcase") || t instanceof CodeUnderTestException) continue;
                String methodName = "";
                boolean sutException = false;
                if (result.test.getStatement(i) instanceof MethodStatement) {
                    MethodStatement ms = (MethodStatement)result.test.getStatement(i);
                    Method method = ms.getMethod().getMethod();
                    methodName = method.getName() + Type.getMethodDescriptor((Method)method);
                    if (method.getDeclaringClass().equals(Properties.getTargetClass())) {
                        sutException = true;
                    }
                } else if (result.test.getStatement(i) instanceof ConstructorStatement) {
                    ConstructorStatement cs = (ConstructorStatement)result.test.getStatement(i);
                    Constructor<?> constructor = cs.getConstructor().getConstructor();
                    methodName = "<init>" + Type.getConstructorDescriptor(constructor);
                    if (constructor.getDeclaringClass().equals(Properties.getTargetClass())) {
                        sutException = true;
                    }
                }
                boolean notDeclared = true;
                for (Class<?> declaredExceptionClass : result.test.getStatement(i).getDeclaredExceptions()) {
                    if (!declaredExceptionClass.isAssignableFrom(t.getClass())) continue;
                    notDeclared = false;
                    break;
                }
                if (!sutException) continue;
                if (notDeclared) {
                    boolean isExplicit;
                    boolean bl = isExplicit = ((Map)isExceptionExplicit.get(result.test)).containsKey(i) && (Boolean)((Map)isExceptionExplicit.get(result.test)).get(i) != false;
                    if (isExplicit) {
                        if (!explicitTypesOfExceptions.containsKey(methodName)) {
                            explicitTypesOfExceptions.put(methodName, new HashSet());
                        }
                        explicitTypesOfExceptions.get(methodName).add(t.getClass());
                    } else {
                        if (!implicitTypesOfExceptions.containsKey(methodName)) {
                            implicitTypesOfExceptions.put(methodName, new HashSet());
                        }
                        implicitTypesOfExceptions.get(methodName).add(t.getClass());
                    }
                } else {
                    if (!declaredTypesOfExceptions.containsKey(methodName)) {
                        declaredTypesOfExceptions.put(methodName, new HashSet());
                    }
                    declaredTypesOfExceptions.get(methodName).add(t.getClass());
                }
                ExceptionCoverageFactory.getGoals().put(methodName + t.getClass().getName(), new ExceptionCoverageTestFitness(methodName, t.getClass()));
            }
        }
    }

    public static int getNumExceptions(Map<String, Set<Class<?>>> exceptions) {
        int total = 0;
        for (Set<Class<?>> exceptionSet : exceptions.values()) {
            total += exceptionSet.size();
        }
        return total;
    }

    public static int getNumClassExceptions(Map<String, Set<Class<?>>> exceptions) {
        HashSet classExceptions = new HashSet();
        for (Set<Class<?>> exceptionSet : exceptions.values()) {
            classExceptions.addAll(exceptionSet);
        }
        return classExceptions.size();
    }
}

