/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.ibranch;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.ibranch.IBranchFitnessFactory;
import org.evosuite.coverage.ibranch.IBranchTestFitness;
import org.evosuite.rmi.ClientServices;
import org.evosuite.setup.Call;
import org.evosuite.setup.CallContext;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class IBranchSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = -4745892521350308986L;
    private final List<IBranchTestFitness> branchGoals;
    private final Map<Integer, Map<CallContext, Set<IBranchTestFitness>>> goalsMap = new HashMap<Integer, Map<CallContext, Set<IBranchTestFitness>>>();
    private final Map<String, Map<CallContext, IBranchTestFitness>> methodsMap = new HashMap<String, Map<CallContext, IBranchTestFitness>>();

    public IBranchSuiteFitness() {
        IBranchFitnessFactory factory = new IBranchFitnessFactory();
        this.branchGoals = factory.getCoverageGoals();
        this.countGoals(this.branchGoals);
        for (IBranchTestFitness goal : this.branchGoals) {
            Map<CallContext, Object> innermap;
            if (goal.getBranchGoal() != null && goal.getBranchGoal().getBranch() != null) {
                Set<IBranchTestFitness> tempInSet;
                int branchId = goal.getBranchGoal().getBranch().getActualBranchId();
                innermap = this.goalsMap.get(branchId);
                if (innermap == null) {
                    innermap = new HashMap();
                    this.goalsMap.put(branchId, innermap);
                }
                if ((tempInSet = innermap.get(goal.getContext())) == null) {
                    tempInSet = new HashSet<IBranchTestFitness>();
                    innermap.put(goal.getContext(), tempInSet);
                }
                tempInSet.add(goal);
                continue;
            }
            String methodName = goal.getTargetClass() + "." + goal.getTargetMethod();
            innermap = this.methodsMap.get(methodName);
            if (innermap == null) {
                innermap = new HashMap();
                this.methodsMap.put(methodName, innermap);
            }
            innermap.put(goal.getContext(), (Set<IBranchTestFitness>)((Object)goal));
        }
    }

    private void countGoals(List<IBranchTestFitness> branchGoals) {
        int totalGoals = branchGoals.size();
        int goalsInTarget = 0;
        for (IBranchTestFitness g : branchGoals) {
            boolean flag = true;
            for (Call call : g.getContext().getContext()) {
                if (call.getClassName().equals(Properties.TARGET_CLASS)) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            ++goalsInTarget;
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.IBranchInitialGoals, totalGoals);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.IBranchInitialGoalsInTargetClass, goalsInTarget);
    }

    private IBranchTestFitness getContextGoal(String classAndMethodName, CallContext context) {
        if (this.methodsMap.get(classAndMethodName) == null || this.methodsMap.get(classAndMethodName).get(context) == null) {
            return null;
        }
        return this.methodsMap.get(classAndMethodName).get(context);
    }

    private IBranchTestFitness getContextGoal(Integer branchId, CallContext context, boolean value) {
        if (this.goalsMap.get(branchId) == null || this.goalsMap.get(branchId).get(context) == null) {
            return null;
        }
        for (IBranchTestFitness iBranchTestFitness : this.goalsMap.get(branchId).get(context)) {
            if (iBranchTestFitness.getValue() != value) continue;
            return iBranchTestFitness;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite) {
        double fitness = 0.0;
        List<ExecutionResult> results = this.runTestSuite(suite);
        HashMap<IBranchTestFitness, Double> distanceMap = new HashMap<IBranchTestFitness, Double>();
        HashMap<Integer, Integer> callCounter = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> branchCounter = new HashMap<Integer, Integer>();
        for (ExecutionResult result : results) {
            assert (result.getTrace().getTrueDistancesContext().keySet().size() == result.getTrace().getFalseDistancesContext().keySet().size());
            for (Integer n : result.getTrace().getTrueDistancesContext().keySet()) {
                Map<CallContext, Double> trueMap = result.getTrace().getTrueDistancesContext().get(n);
                Map<CallContext, Double> falseMap = result.getTrace().getFalseDistancesContext().get(n);
                for (CallContext context : trueMap.keySet()) {
                    IBranchTestFitness goalF;
                    IBranchTestFitness goalT = this.getContextGoal(n, context, true);
                    if (goalT == null) continue;
                    double distanceT = IBranchSuiteFitness.normalize(trueMap.get(context));
                    if (distanceMap.get(goalT) == null || (Double)distanceMap.get(goalT) > distanceT) {
                        distanceMap.put(goalT, distanceT);
                    }
                    if (Double.compare(distanceT, 0.0) == 0) {
                        result.test.addCoveredGoal(goalT);
                    }
                    if ((goalF = this.getContextGoal(n, context, false)) == null) continue;
                    double distanceF = IBranchSuiteFitness.normalize(falseMap.get(context));
                    if (distanceMap.get(goalF) == null || (Double)distanceMap.get(goalF) > distanceF) {
                        distanceMap.put(goalF, distanceF);
                    }
                    if (Double.compare(distanceF, 0.0) != 0) continue;
                    result.test.addCoveredGoal(goalF);
                }
            }
            for (Map.Entry entry : result.getTrace().getPredicateContextExecutionCount().entrySet()) {
                for (Map.Entry value : ((Map)entry.getValue()).entrySet()) {
                    int count = (Integer)value.getValue();
                    IBranchTestFitness goalT = this.getContextGoal((Integer)entry.getKey(), (CallContext)value.getKey(), true);
                    if (goalT != null) {
                        if (branchCounter.get(goalT.getGenericContextBranchIdentifier()) != null && (Integer)branchCounter.get(goalT.getGenericContextBranchIdentifier()) >= count) continue;
                        branchCounter.put(goalT.getGenericContextBranchIdentifier(), count);
                        continue;
                    }
                    IBranchTestFitness goalF = this.getContextGoal((Integer)entry.getKey(), (CallContext)value.getKey(), false);
                    if (goalF == null || branchCounter.get(goalF.getGenericContextBranchIdentifier()) != null && (Integer)branchCounter.get(goalF.getGenericContextBranchIdentifier()) >= count) continue;
                    branchCounter.put(goalF.getGenericContextBranchIdentifier(), count);
                }
            }
            for (Map.Entry entry : result.getTrace().getMethodContextCount().entrySet()) {
                for (Map.Entry value : ((Map)entry.getValue()).entrySet()) {
                    IBranchTestFitness goal = this.getContextGoal((String)entry.getKey(), (CallContext)value.getKey());
                    if (goal == null) continue;
                    int count = (Integer)value.getValue();
                    if (callCounter.get(goal.hashCode()) == null || (Integer)callCounter.get(goal.hashCode()) < count) {
                        callCounter.put(goal.hashCode(), count);
                    }
                    if (count <= 0) continue;
                    result.test.addCoveredGoal(goal);
                }
            }
        }
        int numCoveredGoals = 0;
        for (IBranchTestFitness goal : this.branchGoals) {
            void var11_18;
            Integer count;
            Double d = (Double)distanceMap.get(goal);
            if (d == null) {
                Double d2 = 1.0;
            }
            if (goal.getBranch() == null) {
                count = (Integer)callCounter.get(goal.hashCode());
                if (count == null || count == 0) {
                    fitness += 1.0;
                    continue;
                }
                ++numCoveredGoals;
                continue;
            }
            count = (Integer)branchCounter.get(goal.getGenericContextBranchIdentifier());
            if (count == null || count == 0) {
                fitness += 1.0;
                continue;
            }
            if (count == 1) {
                fitness += 0.5;
                continue;
            }
            if (Double.compare(var11_18.doubleValue(), 0.0) == 0) {
                ++numCoveredGoals;
            }
            fitness += var11_18.doubleValue();
        }
        if (!this.branchGoals.isEmpty()) {
            suite.setCoverage(this, (double)numCoveredGoals / (double)this.branchGoals.size());
        }
        suite.setNumOfCoveredGoals(this, numCoveredGoals);
        suite.setNumOfNotCoveredGoals(this, this.branchGoals.size() - numCoveredGoals);
        this.updateIndividual(this, suite, fitness);
        return fitness;
    }
}

