/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.ibranch.archive;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.archive.TestsArchive;
import org.evosuite.coverage.ibranch.IBranchFitnessFactory;
import org.evosuite.coverage.ibranch.IBranchTestFitness;
import org.evosuite.rmi.ClientServices;
import org.evosuite.setup.Call;
import org.evosuite.setup.CallContext;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class ArchiveIBranchSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = -4745892521350308986L;
    private final List<IBranchTestFitness> branchGoals;
    private int totGoals;
    private final Map<Integer, Map<CallContext, Set<IBranchTestFitness>>> goalsMap;
    private final Map<String, Map<CallContext, IBranchTestFitness>> methodsMap;
    private final TestsArchive bestChromoBuilder;
    private final Set<IBranchTestFitness> toRemoveBranchesT = new HashSet<IBranchTestFitness>();
    private final Set<IBranchTestFitness> toRemoveBranchesF = new HashSet<IBranchTestFitness>();
    private final Set<IBranchTestFitness> toRemoveRootBranches = new HashSet<IBranchTestFitness>();
    private final Set<IBranchTestFitness> removedBranchesT = new HashSet<IBranchTestFitness>();
    private final Set<IBranchTestFitness> removedBranchesF = new HashSet<IBranchTestFitness>();
    private final Set<IBranchTestFitness> removedRootBranches = new HashSet<IBranchTestFitness>();

    public ArchiveIBranchSuiteFitness() {
        this(TestsArchive.instance);
    }

    public ArchiveIBranchSuiteFitness(TestsArchive bestChromoBuilder) {
        this.bestChromoBuilder = bestChromoBuilder;
        this.goalsMap = new HashMap<Integer, Map<CallContext, Set<IBranchTestFitness>>>();
        this.methodsMap = new HashMap<String, Map<CallContext, IBranchTestFitness>>();
        IBranchFitnessFactory factory = new IBranchFitnessFactory();
        this.branchGoals = factory.getCoverageGoals();
        this.countGoals(this.branchGoals);
        for (IBranchTestFitness goal : this.branchGoals) {
            Map<CallContext, Object> innermap;
            if (goal.getBranchGoal() != null && goal.getBranchGoal().getBranch() != null) {
                Set<IBranchTestFitness> tempInSet;
                int branchId = goal.getBranchGoal().getBranch().getActualBranchId();
                innermap = this.goalsMap.get(branchId);
                if (innermap == null) {
                    innermap = new HashMap();
                    this.goalsMap.put(branchId, innermap);
                }
                if ((tempInSet = innermap.get(goal.getContext())) == null) {
                    tempInSet = new HashSet<IBranchTestFitness>();
                    innermap.put(goal.getContext(), tempInSet);
                }
                tempInSet.add(goal);
            } else {
                String methodName = goal.getTargetClass() + "." + goal.getTargetMethod();
                innermap = this.methodsMap.get(methodName);
                if (innermap == null) {
                    innermap = new HashMap();
                    this.methodsMap.put(methodName, innermap);
                }
                innermap.put(goal.getContext(), (Set<IBranchTestFitness>)((Object)goal));
            }
            logger.info("Context goal: " + goal.toString());
        }
        this.totGoals = this.branchGoals.size();
    }

    private void countGoals(List<IBranchTestFitness> branchGoals) {
        int totalGoals = branchGoals.size();
        int goalsInTarget = 0;
        for (IBranchTestFitness g : branchGoals) {
            boolean flag = true;
            for (Call call : g.getContext().getContext()) {
                if (call.getClassName().equals(Properties.TARGET_CLASS)) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            ++goalsInTarget;
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.IBranchInitialGoals, totalGoals);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.IBranchInitialGoalsInTargetClass, goalsInTarget);
    }

    private IBranchTestFitness getContextGoal(String classAndMethodName, CallContext context) {
        if (this.methodsMap.get(classAndMethodName) == null || this.methodsMap.get(classAndMethodName).get(context) == null) {
            return null;
        }
        return this.methodsMap.get(classAndMethodName).get(context);
    }

    private IBranchTestFitness getContextGoal(Integer branchId, CallContext context, boolean value) {
        if (this.goalsMap.get(branchId) == null) {
            return null;
        }
        if (this.goalsMap.get(branchId).get(context) == null) {
            return null;
        }
        for (IBranchTestFitness iBranchTestFitness : this.goalsMap.get(branchId).get(context)) {
            if (iBranchTestFitness.getValue() != value) continue;
            return iBranchTestFitness;
        }
        return null;
    }

    @Override
    public TestSuiteChromosome getBestStoredIndividual() {
        return this.bestChromoBuilder.getBestChromosome();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite) {
        double fitness = 0.0;
        List<ExecutionResult> results = this.runTestSuite(suite);
        HashMap<IBranchTestFitness, Double> distanceMap = new HashMap<IBranchTestFitness, Double>();
        HashMap<IBranchTestFitness, Integer> callCount = new HashMap<IBranchTestFitness, Integer>();
        for (ExecutionResult result : results) {
            for (Integer n : result.getTrace().getTrueDistancesContext().keySet()) {
                Map<CallContext, Double> trueMap = result.getTrace().getTrueDistancesContext().get(n);
                for (CallContext context : trueMap.keySet()) {
                    IBranchTestFitness goalT = this.getContextGoal(n, context, true);
                    if (goalT == null || this.removedBranchesT.contains(goalT)) continue;
                    double distanceT = ArchiveIBranchSuiteFitness.normalize(trueMap.get(context));
                    if (distanceMap.get(goalT) == null || (Double)distanceMap.get(goalT) > distanceT) {
                        distanceMap.put(goalT, distanceT);
                    }
                    if (Double.compare(distanceT, 0.0) != 0) continue;
                    result.test.addCoveredGoal(goalT);
                    this.bestChromoBuilder.putTest(goalT, result.test);
                    this.toRemoveBranchesT.add(goalT);
                    suite.isToBeUpdated(true);
                }
            }
            for (Integer n : result.getTrace().getFalseDistancesContext().keySet()) {
                Map<CallContext, Double> falseMap = result.getTrace().getFalseDistancesContext().get(n);
                for (CallContext context : falseMap.keySet()) {
                    IBranchTestFitness goalF = this.getContextGoal(n, context, false);
                    if (goalF == null || this.removedBranchesF.contains(goalF)) continue;
                    double distanceF = ArchiveIBranchSuiteFitness.normalize(falseMap.get(context));
                    if (distanceMap.get(goalF) == null || (Double)distanceMap.get(goalF) > distanceF) {
                        distanceMap.put(goalF, distanceF);
                    }
                    if (Double.compare(distanceF, 0.0) != 0) continue;
                    result.test.addCoveredGoal(goalF);
                    this.bestChromoBuilder.putTest(goalF, result.test);
                    this.toRemoveBranchesF.add(goalF);
                    suite.isToBeUpdated(true);
                }
            }
            for (Map.Entry entry : result.getTrace().getMethodContextCount().entrySet()) {
                for (Map.Entry value : ((Map)entry.getValue()).entrySet()) {
                    IBranchTestFitness goal = this.getContextGoal((String)entry.getKey(), (CallContext)value.getKey());
                    if (goal == null || this.removedRootBranches.contains(goal)) continue;
                    int count = (Integer)value.getValue();
                    if (callCount.get(goal) == null || (Integer)callCount.get(goal) < count) {
                        callCount.put(goal, count);
                    }
                    if (count <= 0) continue;
                    result.test.addCoveredGoal(goal);
                    this.bestChromoBuilder.putTest(goal, result.test);
                    this.toRemoveRootBranches.add(goal);
                    suite.isToBeUpdated(true);
                }
            }
        }
        int numCoveredGoals = 0;
        for (IBranchTestFitness goal : this.branchGoals) {
            void var10_17;
            Double d = (Double)distanceMap.get(goal);
            if (d == null) {
                Double d2 = 1.0;
            }
            if (goal.getBranch() == null) {
                Integer count = (Integer)callCount.get(goal);
                if (count == null || count == 0) {
                    fitness += 1.0;
                    continue;
                }
                ++numCoveredGoals;
                continue;
            }
            if (var10_17.doubleValue() == 0.0) {
                ++numCoveredGoals;
            }
            fitness += var10_17.doubleValue();
        }
        numCoveredGoals += this.removedBranchesF.size();
        numCoveredGoals += this.removedBranchesT.size();
        numCoveredGoals += this.removedRootBranches.size();
        if (this.totGoals > 0) {
            suite.setCoverage(this, (double)numCoveredGoals / (double)this.totGoals);
        }
        suite.setNumOfCoveredGoals(this, numCoveredGoals);
        suite.setNumOfNotCoveredGoals(this, this.totGoals - numCoveredGoals);
        this.updateIndividual(this, suite, fitness);
        return fitness;
    }

    @Override
    public boolean updateCoveredGoals() {
        boolean f;
        Set set;
        Map<CallContext, Object> map;
        boolean removed;
        for (IBranchTestFitness method : this.toRemoveRootBranches) {
            removed = this.branchGoals.remove(method);
            map = this.methodsMap.get(method.getTargetClass() + "." + method.getTargetMethod());
            IBranchTestFitness f2 = (IBranchTestFitness)map.remove(method.getContext());
            if (removed && f2 != null) {
                this.removedRootBranches.add(method);
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        for (IBranchTestFitness branch : this.toRemoveBranchesT) {
            removed = this.branchGoals.remove(branch);
            map = this.goalsMap.get(branch.getBranch().getActualBranchId());
            set = (Set)map.get(branch.getContext());
            f = set.remove(branch);
            if (removed && f) {
                this.removedBranchesT.add(branch);
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        for (IBranchTestFitness branch : this.toRemoveBranchesF) {
            removed = this.branchGoals.remove(branch);
            map = this.goalsMap.get(branch.getBranch().getActualBranchId());
            set = (Set)map.get(branch.getContext());
            f = set.remove(branch);
            if (removed && f) {
                this.removedBranchesF.add(branch);
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        this.toRemoveRootBranches.clear();
        this.toRemoveBranchesF.clear();
        this.toRemoveBranchesT.clear();
        return true;
    }
}

