/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.line;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.evosuite.coverage.line.LineCoverageTestFitness;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.instrumentation.LinePool;
import org.evosuite.testsuite.AbstractFitnessFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineCoverageFactory
extends AbstractFitnessFactory<LineCoverageTestFitness> {
    private static final Logger logger = LoggerFactory.getLogger(LineCoverageFactory.class);

    @Override
    public List<LineCoverageTestFitness> getCoverageGoals() {
        ArrayList<LineCoverageTestFitness> goals = new ArrayList<LineCoverageTestFitness>();
        long start = System.currentTimeMillis();
        for (String className : LinePool.getKnownClasses()) {
            for (String methodName : LinePool.getKnownMethodsFor(className)) {
                Set<Integer> lines = LinePool.getLines(className, methodName);
                for (Integer line : lines) {
                    logger.info("Adding goal for method " + className + "." + methodName + ", Line " + line + ".");
                    goals.add(new LineCoverageTestFitness(className, methodName, line));
                }
            }
        }
        goalComputationTime = System.currentTimeMillis() - start;
        return goals;
    }

    public static LineCoverageTestFitness createLineTestFitness(String className, String method, Integer line) {
        return new LineCoverageTestFitness(className, method.substring(method.lastIndexOf(".") + 1), line);
    }

    public static LineCoverageTestFitness createLineTestFitness(BytecodeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("null given");
        }
        return LineCoverageFactory.createLineTestFitness(instruction.getClassName(), instruction.getMethodName(), instruction.getLineNumber());
    }
}

