/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.line;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.line.LineCoverageFactory;
import org.evosuite.coverage.line.LineCoverageTestFitness;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.graphs.cfg.ControlDependency;
import org.evosuite.instrumentation.LinePool;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = 7075862615475014070L;
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteFitnessFunction.class);
    public final Set<Integer> lines = new HashSet<Integer>();
    private Set<Integer> branchesToCoverTrue = new HashSet<Integer>();
    private Set<Integer> branchesToCoverFalse = new HashSet<Integer>();
    private Set<Integer> branchesToCoverBoth = new HashSet<Integer>();
    public int maxCoveredLines = 0;
    public double bestFitness = Double.MAX_VALUE;
    private final Map<Integer, TestFitnessFunction> linesCoverageMap = new HashMap<Integer, TestFitnessFunction>();

    public LineCoverageSuiteFitness() {
        String prefix = Properties.TARGET_CLASS_PREFIX;
        for (String className : LinePool.getKnownClasses()) {
            this.lines.addAll(LinePool.getLines(className));
        }
        logger.info("Total line coverage goals: " + this.lines);
        List<LineCoverageTestFitness> goals = new LineCoverageFactory().getCoverageGoals();
        for (LineCoverageTestFitness goal : goals) {
            this.linesCoverageMap.put(goal.getLine(), goal);
        }
        this.initializeControlDependencies();
    }

    private void initializeControlDependencies() {
        for (BytecodeInstruction bi : BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllInstructions()) {
            if (bi.getBasicBlock() == null) continue;
            for (ControlDependency cd : bi.getControlDependencies()) {
                if (cd.getBranchExpressionValue()) {
                    this.branchesToCoverTrue.add(cd.getBranch().getActualBranchId());
                    continue;
                }
                this.branchesToCoverFalse.add(cd.getBranch().getActualBranchId());
            }
        }
        this.branchesToCoverBoth.addAll(this.branchesToCoverTrue);
        this.branchesToCoverBoth.retainAll(this.branchesToCoverFalse);
        this.branchesToCoverTrue.removeAll(this.branchesToCoverBoth);
        this.branchesToCoverFalse.removeAll(this.branchesToCoverBoth);
        logger.info("Covering branches true: " + this.branchesToCoverTrue);
        logger.info("Covering branches false: " + this.branchesToCoverFalse);
        logger.info("Covering branches both: " + this.branchesToCoverBoth);
    }

    private void handleConstructorExceptions(List<ExecutionResult> results, Map<String, Integer> callCount) {
        for (ExecutionResult result : results) {
            Integer exceptionPosition;
            Statement statement;
            if (result.hasTimeout() || result.hasTestException() || result.noThrownExceptions() || !((statement = result.test.getStatement(exceptionPosition = result.getFirstPositionOfThrownException())) instanceof ConstructorStatement)) continue;
            ConstructorStatement c = (ConstructorStatement)statement;
            String className = c.getConstructor().getName();
            String methodName = "<init>" + Type.getConstructorDescriptor(c.getConstructor().getConstructor());
            String name = className + "." + methodName;
            if (callCount.containsKey(name)) continue;
            callCount.put(name, 1);
        }
    }

    private boolean analyzeTraces(List<ExecutionResult> results, Map<String, Integer> callCount) {
        boolean hasTimeoutOrTestException = false;
        for (ExecutionResult result : results) {
            if (result.hasTimeout() || result.hasTestException()) {
                hasTimeoutOrTestException = true;
            }
            for (Integer line : result.getTrace().getCoveredLines()) {
                if (!this.linesCoverageMap.containsKey(line)) continue;
                result.test.addCoveredGoal(this.linesCoverageMap.get(line));
            }
        }
        return hasTimeoutOrTestException;
    }

    private double getControlDependencyGuidance(List<ExecutionResult> results) {
        HashMap predicateCount = new HashMap();
        HashMap trueDistance = new HashMap();
        HashMap falseDistance = new HashMap();
        for (ExecutionResult result : results) {
            if (result.hasTimeout() || result.hasTestException()) continue;
            for (Map.Entry entry : result.getTrace().getPredicateExecutionCount().entrySet()) {
                if (!predicateCount.containsKey(entry.getKey())) {
                    predicateCount.put(entry.getKey(), entry.getValue());
                    continue;
                }
                predicateCount.put(entry.getKey(), (Integer)predicateCount.get(entry.getKey()) + (Integer)entry.getValue());
            }
            for (Map.Entry entry : result.getTrace().getTrueDistances().entrySet()) {
                if (!trueDistance.containsKey(entry.getKey())) {
                    trueDistance.put(entry.getKey(), entry.getValue());
                    continue;
                }
                trueDistance.put(entry.getKey(), Math.min((Double)trueDistance.get(entry.getKey()), (Double)entry.getValue()));
            }
            for (Map.Entry entry : result.getTrace().getFalseDistances().entrySet()) {
                if (!falseDistance.containsKey(entry.getKey())) {
                    falseDistance.put(entry.getKey(), entry.getValue());
                    continue;
                }
                falseDistance.put(entry.getKey(), Math.min((Double)falseDistance.get(entry.getKey()), (Double)entry.getValue()));
            }
        }
        double distance = 0.0;
        for (Integer n : this.branchesToCoverBoth) {
            if (!predicateCount.containsKey(n)) {
                distance += 2.0;
                continue;
            }
            if ((Integer)predicateCount.get(n) == 1) {
                distance += 1.0;
                continue;
            }
            distance += LineCoverageSuiteFitness.normalize((Double)trueDistance.get(n));
            distance += LineCoverageSuiteFitness.normalize((Double)falseDistance.get(n));
        }
        for (Integer n : this.branchesToCoverTrue) {
            if (!trueDistance.containsKey(n)) {
                distance += 1.0;
                continue;
            }
            distance += LineCoverageSuiteFitness.normalize((Double)trueDistance.get(n));
        }
        for (Integer n : this.branchesToCoverFalse) {
            if (!falseDistance.containsKey(n)) {
                distance += 1.0;
                continue;
            }
            distance += LineCoverageSuiteFitness.normalize((Double)falseDistance.get(n));
        }
        return distance;
    }

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite) {
        logger.trace("Calculating branch fitness");
        double fitness = 0.0;
        List<ExecutionResult> results = this.runTestSuite(suite);
        logger.info("Branch distances: " + (fitness += this.getControlDependencyGuidance(results)));
        HashMap<String, Integer> callCount = new HashMap<String, Integer>();
        HashSet<Integer> covered_lines = new HashSet<Integer>();
        boolean hasTimeoutOrTestException = this.analyzeTraces(results, callCount);
        this.handleConstructorExceptions(results, callCount);
        for (ExecutionResult result : results) {
            covered_lines.addAll(result.getTrace().getCoveredLines());
        }
        int totalLines = this.lines.size();
        int coveredLines = covered_lines.size();
        logger.info("Covered " + coveredLines + " out of " + totalLines + " lines");
        this.printStatusMessages(suite, coveredLines, fitness += LineCoverageSuiteFitness.normalize(totalLines - coveredLines));
        if (totalLines > 0) {
            suite.setCoverage(this, (double)coveredLines / (double)totalLines);
        } else {
            suite.setCoverage(this, 1.0);
        }
        suite.setNumOfCoveredGoals(this, coveredLines);
        if (hasTimeoutOrTestException) {
            logger.info("Test suite has timed out, setting fitness to max value " + totalLines);
            fitness = totalLines;
        }
        this.updateIndividual(this, suite, fitness);
        assert (coveredLines <= totalLines) : "Covered " + coveredLines + " vs total goals " + totalLines;
        assert (fitness >= 0.0);
        assert (fitness != 0.0 || coveredLines == totalLines) : "Fitness: " + fitness + ", " + "coverage: " + coveredLines + "/" + totalLines;
        assert (suite.getCoverage(this) <= 1.0 && suite.getCoverage(this) >= 0.0) : "Wrong coverage value " + suite.getCoverage(this);
        return fitness;
    }

    private void printStatusMessages(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite, int coveredLines, double fitness) {
        if (coveredLines > this.maxCoveredLines) {
            this.maxCoveredLines = coveredLines;
            logger.info("(Lines) Best individual covers " + coveredLines + "/" + this.lines + " lines");
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
        if (fitness < this.bestFitness) {
            logger.info("(Fitness) Best individual covers " + coveredLines + "/" + this.lines + " lines");
            this.bestFitness = fitness;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
    }
}

