/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.line.archive;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.archive.TestsArchive;
import org.evosuite.coverage.line.LineCoverageFactory;
import org.evosuite.coverage.line.LineCoverageTestFitness;
import org.evosuite.instrumentation.LinePool;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveOnlyLineCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = -6369027784777941998L;
    private final TestsArchive testArchive;
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteFitnessFunction.class);
    public final Set<Integer> lines = new HashSet<Integer>();
    public final Set<Integer> removedLines = new HashSet<Integer>();
    public final Set<Integer> toRemoveLines = new HashSet<Integer>();
    public int maxCoveredLines = 0;
    public double bestFitness = Double.MAX_VALUE;
    private final Map<Integer, TestFitnessFunction> linesCoverageMap = new HashMap<Integer, TestFitnessFunction>();

    public ArchiveOnlyLineCoverageSuiteFitness() {
        this(TestsArchive.instance);
    }

    public ArchiveOnlyLineCoverageSuiteFitness(TestsArchive bestChromoBuilder) {
        this.testArchive = bestChromoBuilder;
        String prefix = Properties.TARGET_CLASS_PREFIX;
        for (String className : LinePool.getKnownClasses()) {
            this.lines.addAll(LinePool.getLines(className));
        }
        logger.info("Total line coverage goals: " + this.lines);
        List<LineCoverageTestFitness> goals = new LineCoverageFactory().getCoverageGoals();
        for (LineCoverageTestFitness goal : goals) {
            this.linesCoverageMap.put(goal.getLine(), goal);
            this.testArchive.addGoalToCover(goal);
        }
    }

    @Override
    public boolean updateCoveredGoals() {
        for (Integer line : this.toRemoveLines) {
            boolean removed = this.lines.remove(line);
            TestFitnessFunction f = this.linesCoverageMap.remove(line);
            if (removed && f != null) {
                this.removedLines.add(line);
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        this.toRemoveLines.clear();
        logger.info("Current state of archive: " + this.testArchive.toString());
        return true;
    }

    private boolean analyzeTraces(List<ExecutionResult> results, Map<String, Integer> callCount) {
        boolean hasTimeoutOrTestException = false;
        for (ExecutionResult result : results) {
            if (result.hasTimeout() || result.hasTestException()) {
                hasTimeoutOrTestException = true;
            }
            for (Integer line : result.getTrace().getCoveredLines()) {
                if (!this.linesCoverageMap.containsKey(line) || !this.lines.contains(line) || this.removedLines.contains(line)) continue;
                result.test.addCoveredGoal(this.linesCoverageMap.get(line));
                this.toRemoveLines.add(line);
                this.testArchive.putTest(this.linesCoverageMap.get(line), result.test);
            }
        }
        return hasTimeoutOrTestException;
    }

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite) {
        logger.trace("Calculating branch fitness");
        double fitness = 0.0;
        List<ExecutionResult> results = this.runTestSuite(suite);
        HashMap<String, Integer> callCount = new HashMap<String, Integer>();
        HashSet<Integer> covered_lines = new HashSet<Integer>();
        boolean hasTimeoutOrTestException = this.analyzeTraces(results, callCount);
        for (ExecutionResult result : results) {
            for (Integer line : result.getTrace().getCoveredLines()) {
                if (this.removedLines.contains(line)) continue;
                covered_lines.add(line);
            }
        }
        int totalLines = this.lines.size();
        int coveredLines = covered_lines.size();
        this.printStatusMessages(suite, coveredLines, fitness += ArchiveOnlyLineCoverageSuiteFitness.normalize(totalLines - coveredLines));
        if (totalLines > 0) {
            suite.setCoverage(this, (double)coveredLines / (double)totalLines);
        } else {
            suite.setCoverage(this, 1.0);
        }
        suite.setNumOfCoveredGoals(this, coveredLines);
        if (hasTimeoutOrTestException) {
            logger.info("Test suite has timed out, setting fitness to max value " + totalLines);
            fitness = totalLines;
        }
        this.updateIndividual(this, suite, fitness);
        assert (coveredLines <= totalLines) : "Covered " + coveredLines + " vs total goals " + totalLines;
        assert (fitness >= 0.0);
        assert (fitness != 0.0 || coveredLines == totalLines) : "Fitness: " + fitness + ", " + "coverage: " + coveredLines + "/" + totalLines;
        assert (suite.getCoverage(this) <= 1.0 && suite.getCoverage(this) >= 0.0) : "Wrong coverage value " + suite.getCoverage(this);
        return fitness;
    }

    private void printStatusMessages(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite, int coveredLines, double fitness) {
        if (coveredLines > this.maxCoveredLines) {
            this.maxCoveredLines = coveredLines;
            logger.info("(Lines) Best individual covers " + coveredLines + "/" + this.lines + " lines");
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
        if (fitness < this.bestFitness) {
            logger.info("(Fitness) Best individual covers " + coveredLines + "/" + this.lines + " lines");
            this.bestFitness = fitness;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
    }
}

