/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.mutation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.coverage.archive.TestsArchive;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.coverage.mutation.MutationSuiteFitness;
import org.evosuite.coverage.mutation.MutationTestFitness;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;

public class ArchiveOnlyMutationSuiteFitness
extends MutationSuiteFitness {
    private static final long serialVersionUID = -8194940669364526758L;
    private final TestsArchive testArchive;
    public final Set<Integer> mutants = new HashSet<Integer>();
    public final Set<Integer> removedMutants = new HashSet<Integer>();
    public final Set<Integer> toRemoveMutants = new HashSet<Integer>();
    public final Map<Integer, MutationTestFitness> mutantMap = new HashMap<Integer, MutationTestFitness>();

    public ArchiveOnlyMutationSuiteFitness() {
        this(TestsArchive.instance);
    }

    public ArchiveOnlyMutationSuiteFitness(TestsArchive archive) {
        this.testArchive = archive;
        for (MutationTestFitness goal : this.mutationGoals) {
            this.testArchive.addGoalToCover(goal);
            this.mutantMap.put(goal.getMutation().getId(), goal);
            this.mutants.add(goal.getMutation().getId());
        }
    }

    @Override
    public boolean updateCoveredGoals() {
        for (Integer mutant : this.toRemoveMutants) {
            boolean removed = this.mutants.remove(mutant);
            TestFitnessFunction f = this.mutantMap.remove(mutant);
            if (removed && f != null) {
                this.removedMutants.add(mutant);
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        this.toRemoveMutants.clear();
        logger.info("Current state of archive: " + this.testArchive.toString());
        return true;
    }

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> individual) {
        if (this.mutationGoals.size() == 0) {
            this.updateIndividual(this, individual, 0.0);
            ((TestSuiteChromosome)individual).setCoverage(this, 1.0);
            ((TestSuiteChromosome)individual).setNumOfCoveredGoals(this, 0);
            return 0.0;
        }
        List<ExecutionResult> results = this.runTestSuite(individual);
        double fitness = 0.0;
        HashMap<Integer, Double> mutant_distance = new HashMap<Integer, Double>();
        HashSet<Integer> touchedMutants = new HashSet<Integer>();
        for (ExecutionResult result : results) {
            touchedMutants.addAll(result.getTrace().getTouchedMutants());
            for (Map.Entry<Integer, Double> entry : result.getTrace().getMutationDistances().entrySet()) {
                if (!this.mutants.contains(entry.getKey()) || this.removedMutants.contains(entry.getKey())) continue;
                if (entry.getValue() == 0.0) {
                    this.toRemoveMutants.add(entry.getKey());
                    this.testArchive.putTest(this.mutantMap.get(entry.getKey()), result.test);
                    result.test.addCoveredGoal(this.mutantMap.get(entry.getKey()));
                }
                if (!mutant_distance.containsKey(entry.getKey())) {
                    mutant_distance.put(entry.getKey(), entry.getValue());
                    continue;
                }
                mutant_distance.put(entry.getKey(), Math.min((Double)mutant_distance.get(entry.getKey()), entry.getValue()));
            }
        }
        fitness += (double)(MutationPool.getMutantCounter() - touchedMutants.size());
        int covered = 0;
        for (Double distance : mutant_distance.values()) {
            if (distance < 0.0) {
                logger.warn("Distance is " + distance + " / " + Integer.MAX_VALUE + " / " + Integer.MIN_VALUE);
                distance = 0.0;
            }
            fitness += ArchiveOnlyMutationSuiteFitness.normalize(distance);
            if (distance != 0.0) continue;
            ++covered;
        }
        this.updateIndividual(this, individual, fitness);
        ((TestSuiteChromosome)individual).setCoverage(this, 1.0 * (double)covered / (double)this.mutationGoals.size());
        ((TestSuiteChromosome)individual).setNumOfCoveredGoals(this, covered);
        return fitness;
    }
}

