/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.mutation;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.coverage.mutation.MutationTestFitness;
import org.evosuite.coverage.mutation.MutationTimeoutStoppingCondition;
import org.evosuite.coverage.mutation.StrongMutationTestFitness;
import org.evosuite.coverage.mutation.WeakMutationTestFitness;
import org.evosuite.rmi.ClientServices;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testsuite.AbstractFitnessFactory;

public class MutationFactory
extends AbstractFitnessFactory<MutationTestFitness> {
    private boolean strong = true;
    private List<MutationTestFitness> goals = null;

    public MutationFactory() {
    }

    public MutationFactory(boolean strongMutation) {
        this.strong = strongMutation;
    }

    @Override
    public List<MutationTestFitness> getCoverageGoals() {
        return this.getCoverageGoals(null);
    }

    public List<MutationTestFitness> getCoverageGoals(String targetMethod) {
        if (this.goals != null) {
            return this.goals;
        }
        this.goals = new ArrayList<MutationTestFitness>();
        for (Mutation m : MutationPool.getMutants()) {
            if (targetMethod != null && !m.getMethodName().endsWith(targetMethod) || MutationTimeoutStoppingCondition.isDisabled(m)) continue;
            if (this.strong) {
                this.goals.add(new StrongMutationTestFitness(m));
                continue;
            }
            this.goals.add(new WeakMutationTestFitness(m));
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Mutants, this.goals.size());
        return this.goals;
    }
}

