/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.mutation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;

public class MutationPool {
    private static Map<String, Map<String, List<Mutation>>> mutationMap = new HashMap<String, Map<String, List<Mutation>>>();
    private static Map<Integer, Mutation> mutationIdMap = new HashMap<Integer, Mutation>();
    private static int numMutations = 0;

    public static Mutation addMutation(String className, String methodName, String mutationName, BytecodeInstruction instruction, AbstractInsnNode mutation, InsnList distance) {
        if (!mutationMap.containsKey(className)) {
            mutationMap.put(className, new HashMap());
        }
        if (!mutationMap.get(className).containsKey(methodName)) {
            mutationMap.get(className).put(methodName, new ArrayList());
        }
        Mutation mutationObject = new Mutation(className, methodName, mutationName, numMutations++, instruction, mutation, distance);
        mutationMap.get(className).get(methodName).add(mutationObject);
        mutationIdMap.put(mutationObject.getId(), mutationObject);
        return mutationObject;
    }

    public static Mutation addMutation(String className, String methodName, String mutationName, BytecodeInstruction instruction, InsnList mutation, InsnList distance) {
        if (!mutationMap.containsKey(className)) {
            mutationMap.put(className, new HashMap());
        }
        if (!mutationMap.get(className).containsKey(methodName)) {
            mutationMap.get(className).put(methodName, new ArrayList());
        }
        Mutation mutationObject = new Mutation(className, methodName, mutationName, numMutations++, instruction, mutation, distance);
        mutationMap.get(className).get(methodName).add(mutationObject);
        mutationIdMap.put(mutationObject.getId(), mutationObject);
        return mutationObject;
    }

    public static List<Mutation> retrieveMutationsInMethod(String className, String methodName) {
        ArrayList<Mutation> r = new ArrayList<Mutation>();
        if (mutationMap.get(className) == null) {
            return r;
        }
        List<Mutation> mutants = mutationMap.get(className).get(methodName);
        if (mutants != null) {
            r.addAll(mutants);
        }
        return r;
    }

    public static List<Mutation> getMutants() {
        ArrayList<Mutation> mutants = new ArrayList<Mutation>();
        mutants.addAll(mutationIdMap.values());
        return mutants;
    }

    public static Mutation getMutant(int id) {
        return mutationIdMap.get(id);
    }

    public static void clear() {
        mutationMap.clear();
        mutationIdMap.clear();
        numMutations = 0;
    }

    public static int getMutantCounter() {
        return numMutations;
    }
}

