/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.mutation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Set;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.ControlFlowDistance;
import org.evosuite.coverage.branch.BranchCoverageGoal;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationObserver;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.cfg.ActualControlFlowGraph;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.TestCaseExecutor;

public abstract class MutationTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = 596930765039928708L;
    protected transient Mutation mutation;
    protected final Set<BranchCoverageGoal> controlDependencies = new HashSet<BranchCoverageGoal>();
    protected final int diameter;

    public MutationTestFitness(Mutation mutation) {
        this.mutation = mutation;
        this.controlDependencies.addAll(mutation.getControlDependencies());
        ActualControlFlowGraph cfg = GraphPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getActualCFG(mutation.getClassName(), mutation.getMethodName());
        this.diameter = cfg.getDiameter();
    }

    public Mutation getMutation() {
        return this.mutation;
    }

    @Override
    public ExecutionResult runTest(TestCase test) {
        return MutationTestFitness.runTest(test, null);
    }

    public static ExecutionResult runTest(TestCase test, Mutation mutant) {
        ExecutionResult result = new ExecutionResult(test, mutant);
        try {
            if (mutant != null) {
                logger.debug("Executing test for mutant " + mutant.getId() + ": \n" + test.toCode());
            } else {
                logger.debug("Executing test witout mutant");
            }
            if (mutant != null) {
                MutationObserver.activateMutation(mutant);
            }
            result = TestCaseExecutor.getInstance().execute(test);
            if (mutant != null) {
                MutationObserver.deactivateMutation(mutant);
            }
            int num = test.size();
            if (!result.noThrownExceptions()) {
                num = result.getFirstPositionOfThrownException();
            }
            MaxStatementsStoppingCondition.statementsExecuted(num);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        return result;
    }

    protected double getExecutionDistance(ExecutionResult result) {
        double fitness = 0.0;
        if (!result.getTrace().wasMutationTouched(this.mutation.getId())) {
            fitness += (double)this.diameter;
        }
        if (this.controlDependencies.isEmpty()) {
            String key = this.mutation.getClassName() + "." + this.mutation.getMethodName();
            if (result.getTrace().getCoveredMethods().contains(key)) {
                logger.debug("Target method " + key + " was executed");
            } else {
                logger.debug("Target method " + key + " was not executed");
                fitness += (double)this.diameter;
            }
        } else {
            ControlFlowDistance cfgDistance = null;
            for (BranchCoverageGoal dependency : this.controlDependencies) {
                logger.debug("Checking dependency...");
                ControlFlowDistance distance = dependency.getDistance(result);
                if (cfgDistance == null) {
                    cfgDistance = distance;
                    continue;
                }
                if (distance.compareTo(cfgDistance) >= 0) continue;
                cfgDistance = distance;
            }
            if (cfgDistance != null) {
                logger.debug("Found control dependency");
                fitness += cfgDistance.getResultingBranchFitness();
            }
        }
        return fitness;
    }

    @Override
    public abstract double getFitness(TestChromosome var1, ExecutionResult var2);

    public String toString() {
        return this.mutation.toString();
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other instanceof MutationTestFitness) {
            return this.mutation.compareTo(((MutationTestFitness)other).getMutation());
        }
        return 0;
    }

    @Override
    public String getTargetClass() {
        return this.mutation.getClassName();
    }

    @Override
    public String getTargetMethod() {
        return this.mutation.getMethodName();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeInt(this.mutation.getId());
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        int mutationId = ois.readInt();
        this.mutation = MutationPool.getMutant(mutationId);
    }
}

