/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.mutation;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.ga.stoppingconditions.StoppingConditionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutationTimeoutStoppingCondition
extends StoppingConditionImpl {
    private final Logger logger = LoggerFactory.getLogger(MutationTimeoutStoppingCondition.class);
    private static final long serialVersionUID = -7347443938884126325L;
    private static int timeouts = 0;
    private static boolean hasException = false;
    private static int MAX_TIMEOUTS = Properties.MUTATION_TIMEOUTS;
    private static Set<Mutation> disabled = new HashSet<Mutation>();

    public static boolean isDisabled(Mutation mutation) {
        return disabled.contains(mutation);
    }

    @Override
    public long getCurrentValue() {
        return timeouts;
    }

    @Override
    public boolean isFinished() {
        this.logger.debug("Number of timeouts registered for this mutant: " + timeouts + "/" + MAX_TIMEOUTS);
        if (timeouts >= MAX_TIMEOUTS) {
            this.logger.debug("Mutation timed out, stopping search");
        }
        return timeouts >= MAX_TIMEOUTS || hasException;
    }

    @Override
    public void reset() {
        timeouts = 0;
        hasException = false;
    }

    @Override
    public void setLimit(long limit) {
        MAX_TIMEOUTS = (int)limit;
    }

    @Override
    public long getLimit() {
        return MAX_TIMEOUTS;
    }

    public static void timeOut(Mutation mutation) {
        if (++timeouts >= MAX_TIMEOUTS) {
            disabled.add(mutation);
        }
    }

    public static void raisedException(Mutation mutation) {
        hasException = true;
        disabled.add(mutation);
    }

    @Override
    public void forceCurrentValue(long value) {
        timeouts = (int)value;
    }
}

