/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.mutation;

import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationTestFitness;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;

public class OnlyMutationTestFitness
extends MutationTestFitness {
    private static final long serialVersionUID = -6724941216935595963L;

    public OnlyMutationTestFitness(Mutation m) {
        super(m);
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        double fitness = 0.0;
        if (!result.getTrace().wasMutationTouched(this.mutation.getId())) {
            fitness = 1.0;
        } else {
            fitness = OnlyMutationTestFitness.normalize(result.getTrace().getMutationDistance(this.mutation.getId()));
            logger.debug("Infection distance for mutation = " + fitness);
        }
        this.updateIndividual(this, individual, fitness);
        if (fitness == 0.0) {
            individual.getTestCase().addCoveredGoal(this);
        }
        return fitness;
    }

    @Override
    public String getTargetMethod() {
        return "Weak " + this.mutation.toString();
    }
}

