/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.mutation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationSuiteFitness;
import org.evosuite.coverage.mutation.MutationTestFitness;
import org.evosuite.coverage.mutation.MutationTestPool;
import org.evosuite.coverage.mutation.MutationTimeoutStoppingCondition;
import org.evosuite.coverage.mutation.StrongMutationTestFitness;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;

public class StrongMutationSuiteFitness
extends MutationSuiteFitness
implements SearchListener {
    private static final long serialVersionUID = -9124328839917834720L;
    private static Queue<MutationTestFitness> remainingGoals = new LinkedList<MutationTestFitness>();
    private static Set<MutationTestFitness> currentGoals = new HashSet<MutationTestFitness>();
    private int unchangedGenerations = 0;
    private boolean changed = false;

    @Override
    public ExecutionResult runTest(TestCase test) {
        return this.runTest(test, null);
    }

    @Override
    public ExecutionResult runTest(TestCase test, Mutation mutant) {
        return StrongMutationTestFitness.runTest(test, mutant);
    }

    private List<TestChromosome> prioritizeTests(TestSuiteChromosome individual) {
        ArrayList<TestChromosome> executionOrder = new ArrayList<TestChromosome>(individual.getTestChromosomes());
        Collections.sort(executionOrder, new Comparator<TestChromosome>(){

            @Override
            public int compare(TestChromosome tc1, TestChromosome tc2) {
                ExecutionResult result1 = tc1.getLastExecutionResult();
                ExecutionResult result2 = tc2.getLastExecutionResult();
                long diff = result1.getExecutionTime() - result2.getExecutionTime();
                if (diff == 0L) {
                    return 0;
                }
                if (diff < 0L) {
                    return -1;
                }
                return 1;
            }
        });
        return executionOrder;
    }

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> individual) {
        this.runTestSuite(individual);
        TestSuiteChromosome suite = (TestSuiteChromosome)individual;
        HashMap<Integer, Double> infectionDistance = new HashMap<Integer, Double>();
        for (TestChromosome test : suite.getTestChromosomes()) {
            ExecutionResult result = test.getLastExecutionResult();
            if (result.hasTimeout()) {
                logger.debug("Skipping test with timeout");
                double fitness = this.branchFitness.totalBranches * 2 + this.branchFitness.totalMethods + 3 * this.mutationGoals.size();
                this.updateIndividual(this, individual, fitness);
                suite.setCoverage(this, 0.0);
                logger.info("Test case has timed out, setting fitness to max value " + fitness);
                return fitness;
            }
            for (Integer mutationId : result.getTrace().getTouchedMutants()) {
                if (infectionDistance.containsKey(mutationId)) {
                    infectionDistance.put(mutationId, Math.min((Double)infectionDistance.get(mutationId), result.getTrace().getMutationDistance(mutationId)));
                    continue;
                }
                infectionDistance.put(mutationId, result.getTrace().getMutationDistance(mutationId));
            }
        }
        logger.debug("Calculating branch fitness: ");
        double fitness = this.branchFitness.getFitness(individual);
        HashSet<Integer> touchedMutants = new HashSet<Integer>();
        HashMap<Mutation, Double> minMutantFitness = new HashMap<Mutation, Double>();
        for (TestFitnessFunction testFitnessFunction : currentGoals) {
            MutationTestFitness mutantFitness = (MutationTestFitness)testFitnessFunction;
            minMutantFitness.put(mutantFitness.getMutation(), 3.0);
        }
        int mutantsChecked = 0;
        List<TestChromosome> list = this.prioritizeTests(suite);
        block3: for (TestChromosome test : list) {
            ExecutionResult result = test.getLastExecutionResult();
            ExecutionTrace trace = result.getTrace();
            touchedMutants.addAll(trace.getTouchedMutants());
            logger.debug("Tests touched " + touchedMutants.size() + " mutants");
            for (TestFitnessFunction testFitnessFunction : currentGoals) {
                double mutantFitnessValue;
                MutationTestFitness mutantFitness = (MutationTestFitness)testFitnessFunction;
                if (MutationTimeoutStoppingCondition.isDisabled(mutantFitness.getMutation())) {
                    logger.debug("Skipping timed out mutation " + mutantFitness.getMutation().getId());
                    this.changed = true;
                    continue;
                }
                if (MutationTestPool.isCovered(mutantFitness.getMutation()) || !trace.getTouchedMutants().contains(mutantFitness.getMutation().getId())) continue;
                ++mutantsChecked;
                double mutantInfectionDistance = trace.getMutationDistance(mutantFitness.getMutation().getId());
                if (mutantInfectionDistance == 0.0) {
                    logger.debug("Executing test against mutant " + mutantFitness.getMutation());
                    mutantFitnessValue = testFitnessFunction.getFitness(test, result);
                    minMutantFitness.put(mutantFitness.getMutation(), Math.min(StrongMutationSuiteFitness.normalize(mutantFitnessValue), (Double)minMutantFitness.get(mutantFitness.getMutation())));
                    if (mutantFitnessValue != 0.0) continue;
                    MutationTestPool.addTest(mutantFitness.getMutation(), test);
                    this.changed = true;
                    continue block3;
                }
                mutantFitnessValue = 1.0 + mutantInfectionDistance;
                minMutantFitness.put(mutantFitness.getMutation(), Math.min(StrongMutationSuiteFitness.normalize(mutantFitnessValue), (Double)minMutantFitness.get(mutantFitness.getMutation())));
            }
        }
        int numKilled = MutationTestPool.getCoveredMutants();
        for (Double fit : minMutantFitness.values()) {
            fitness += fit.doubleValue();
        }
        logger.debug("Mutants killed: {} (Checked: {})", (Object)numKilled, (Object)mutantsChecked);
        this.updateIndividual(this, individual, fitness += (double)(this.mutationGoals.size() - MutationTestPool.getCoveredMutants()));
        this.updateGoals();
        suite.setCoverage(this, 1.0 * (double)numKilled / (double)this.mutationGoals.size());
        suite.setNumOfCoveredGoals(this, numKilled);
        return fitness;
    }

    private void updateGoals() {
        logger.debug("Updating goal set. Old size: " + currentGoals.size());
        Iterator<MutationTestFitness> iterator = currentGoals.iterator();
        int numChanged = 0;
        while (iterator.hasNext()) {
            MutationTestFitness mutationFitness = iterator.next();
            Mutation m = mutationFitness.getMutation();
            if (!MutationTestPool.isCovered(m) && !MutationTimeoutStoppingCondition.isDisabled(m)) continue;
            iterator.remove();
            ++numChanged;
        }
        if (Properties.MAX_MUTANTS > 0) {
            if (numChanged > 0) {
                this.changed = true;
            }
            while (currentGoals.size() < Properties.MAX_MUTANTS && !remainingGoals.isEmpty()) {
                MutationTestFitness nextMutation = remainingGoals.poll();
                if (MutationTestPool.isCovered(nextMutation.getMutation()) || MutationTimeoutStoppingCondition.isDisabled(nextMutation.getMutation())) continue;
                currentGoals.add(nextMutation);
            }
        }
        logger.debug("Finished updating goal set. New size: " + currentGoals.size() + ", mutants replaced: " + numChanged + ", mutants left: " + remainingGoals.size());
    }

    private void replaceGoals() {
        logger.debug("Replacing current mutant set, mutants left: " + remainingGoals.size());
        HashSet<MutationTestFitness> newSet = new HashSet<MutationTestFitness>();
        int numMutants = Properties.MAX_MUTANTS;
        if (numMutants <= 0) {
            numMutants = remainingGoals.size();
        }
        while (numMutants > 0 && !remainingGoals.isEmpty()) {
            MutationTestFitness nextMutation = remainingGoals.poll();
            if (MutationTestPool.isCovered(nextMutation.getMutation()) || MutationTimeoutStoppingCondition.isDisabled(nextMutation.getMutation())) continue;
            --numMutants;
            newSet.add(nextMutation);
        }
        remainingGoals.addAll(currentGoals);
        currentGoals = newSet;
        if (currentGoals.size() < Properties.MAX_MUTANTS) {
            this.updateGoals();
        }
        logger.info("Replaced current mutant set, mutants left: " + remainingGoals.size());
    }

    @Override
    public void searchStarted(GeneticAlgorithm<?> algorithm) {
        this.unchangedGenerations = 0;
        remainingGoals.addAll(MutationTestPool.getUncoveredFitnessFunctions());
        if (Properties.MAX_MUTANTS > 0) {
            this.updateGoals();
        } else {
            currentGoals.addAll(remainingGoals);
        }
    }

    @Override
    public void iteration(GeneticAlgorithm<?> algorithm) {
        if (Properties.MAX_MUTANTS > 0) {
            if (!this.changed) {
                logger.debug("Generation without change: " + this.unchangedGenerations);
                ++this.unchangedGenerations;
                if (this.unchangedGenerations > Properties.MUTATION_GENERATIONS) {
                    this.replaceGoals();
                    this.unchangedGenerations = 0;
                }
            } else {
                logger.debug("Generation with change, mutants left: " + remainingGoals.size());
                this.changed = false;
                this.unchangedGenerations = 0;
            }
        }
    }

    @Override
    public void searchFinished(GeneticAlgorithm<?> algorithm) {
    }

    @Override
    public void fitnessEvaluation(Chromosome individual) {
    }

    @Override
    public void modification(Chromosome individual) {
    }
}

