/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.output;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.MethodNameMatcher;
import org.evosuite.coverage.output.OutputCoverageGoal;
import org.evosuite.coverage.output.OutputCoverageTestFitness;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.testsuite.AbstractFitnessFactory;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputCoverageFactory
extends AbstractFitnessFactory<OutputCoverageTestFitness> {
    private static final Logger logger = LoggerFactory.getLogger(OutputCoverageFactory.class);
    public static final String CHAR_ALPHA = "alpha";
    public static final String CHAR_DIGIT = "digit";
    public static final String CHAR_OTHER = "other";
    public static final String BOOL_TRUE = "true";
    public static final String BOOL_FALSE = "false";
    public static final String NUM_POSITIVE = "positive";
    public static final String NUM_ZERO = "zero";
    public static final String NUM_NEGATIVE = "negative";
    public static final String DEFAULT = "default";
    public static final String REF_NULL = "null";
    public static final String REF_NONNULL = "nonnull";

    @Override
    public List<OutputCoverageTestFitness> getCoverageGoals() {
        ArrayList<OutputCoverageTestFitness> goals = new ArrayList<OutputCoverageTestFitness>();
        long start = System.currentTimeMillis();
        String targetClass = Properties.TARGET_CLASS;
        MethodNameMatcher matcher = new MethodNameMatcher();
        for (String className : BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).knownClasses()) {
            if (!targetClass.equals("") && !className.endsWith(targetClass)) continue;
            for (String methodName : BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).knownMethods(className)) {
                if (!matcher.methodMatches(methodName)) continue;
                logger.info("Adding goals for method " + className + "." + methodName);
                Type returnType = Type.getReturnType((String)methodName);
                switch (returnType.getSort()) {
                    case 1: {
                        goals.add(new OutputCoverageTestFitness(new OutputCoverageGoal(className, methodName, returnType.toString(), BOOL_TRUE)));
                        goals.add(new OutputCoverageTestFitness(new OutputCoverageGoal(className, methodName, returnType.toString(), BOOL_FALSE)));
                        break;
                    }
                    case 2: {
                        goals.add(new OutputCoverageTestFitness(new OutputCoverageGoal(className, methodName, returnType.toString(), CHAR_ALPHA)));
                        goals.add(new OutputCoverageTestFitness(new OutputCoverageGoal(className, methodName, returnType.toString(), CHAR_DIGIT)));
                        goals.add(new OutputCoverageTestFitness(new OutputCoverageGoal(className, methodName, returnType.toString(), CHAR_OTHER)));
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        goals.add(new OutputCoverageTestFitness(new OutputCoverageGoal(className, methodName, returnType.toString(), NUM_NEGATIVE)));
                        goals.add(new OutputCoverageTestFitness(new OutputCoverageGoal(className, methodName, returnType.toString(), NUM_ZERO)));
                        goals.add(new OutputCoverageTestFitness(new OutputCoverageGoal(className, methodName, returnType.toString(), NUM_POSITIVE)));
                        break;
                    }
                    case 9: 
                    case 10: {
                        goals.add(new OutputCoverageTestFitness(new OutputCoverageGoal(className, methodName, returnType.toString(), REF_NULL)));
                        goals.add(new OutputCoverageTestFitness(new OutputCoverageGoal(className, methodName, returnType.toString(), REF_NONNULL)));
                        break;
                    }
                }
            }
        }
        goalComputationTime = System.currentTimeMillis() - start;
        return goals;
    }

    public static String goalString(String className, String methodName, String suffix) {
        return new String(className + "." + methodName + ":" + suffix);
    }
}

