/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.output;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.evosuite.coverage.output.OutputCoverageFactory;
import org.evosuite.coverage.output.OutputCoverageTestFitness;
import org.evosuite.coverage.output.OutputObserver;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.objectweb.asm.Type;

public class OutputCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = -8345906214972153096L;
    public final int totalGoals;
    public int maxCoveredGoals = 0;
    public double bestFitness = Double.MAX_VALUE;
    private final Map<String, TestFitnessFunction> outputCoverageMap = new HashMap<String, TestFitnessFunction>();

    public OutputCoverageSuiteFitness() {
        TestCaseExecutor executor = TestCaseExecutor.getInstance();
        OutputObserver observer = new OutputObserver();
        executor.addObserver(observer);
        this.determineCoverageGoals();
        this.totalGoals = this.outputCoverageMap.size();
    }

    private void determineCoverageGoals() {
        List<OutputCoverageTestFitness> goals = new OutputCoverageFactory().getCoverageGoals();
        for (OutputCoverageTestFitness goal : goals) {
            this.outputCoverageMap.put(goal.toString(), goal);
        }
    }

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite) {
        logger.trace("Calculating test suite fitness");
        double fitness = 0.0;
        List<ExecutionResult> results = this.runTestSuite(suite);
        HashSet<String> setOfCoveredGoals = new HashSet<String>();
        boolean hasTimeoutOrTestException = false;
        for (ExecutionResult result : results) {
            if (result.hasTimeout() || result.hasTestException()) {
                hasTimeoutOrTestException = true;
                continue;
            }
            this.updateCoveredGoals(result, setOfCoveredGoals);
        }
        int coveredGoals = setOfCoveredGoals.size();
        if (hasTimeoutOrTestException) {
            logger.info("Test suite has timed out, setting fitness to max value " + this.totalGoals);
            fitness = this.totalGoals;
        } else {
            fitness = this.computeDistance(results, setOfCoveredGoals);
        }
        if (this.totalGoals > 0) {
            suite.setCoverage(this, (double)coveredGoals / (double)this.totalGoals);
        } else {
            suite.setCoverage(this, 1.0);
        }
        suite.setNumOfCoveredGoals(this, coveredGoals);
        this.printStatusMessages(suite, coveredGoals, fitness);
        this.updateIndividual(this, suite, fitness);
        assert (coveredGoals <= this.totalGoals) : "Covered " + coveredGoals + " vs total goals " + this.totalGoals;
        assert (fitness >= 0.0);
        assert (fitness != 0.0 || coveredGoals == this.totalGoals) : "Fitness: " + fitness + ", " + "coverage: " + coveredGoals + "/" + this.totalGoals;
        assert (suite.getCoverage(this) <= 1.0 && suite.getCoverage(this) >= 0.0) : "Wrong coverage value " + suite.getCoverage(this);
        return fitness;
    }

    private void updateCoveredGoals(ExecutionResult result, HashSet<String> setOfCoveredGoals) {
        HashSet<String> strGoals = OutputCoverageTestFitness.listCoveredGoals(result.getReturnValues());
        for (String strGoal : strGoals) {
            if (!this.outputCoverageMap.containsKey(strGoal)) continue;
            setOfCoveredGoals.add(strGoal);
            result.test.addCoveredGoal(this.outputCoverageMap.get(strGoal));
        }
    }

    public double computeDistance(List<ExecutionResult> results, HashSet<String> setOfCoveredGoals) {
        HashMap<String, Double> mapDistances = new HashMap<String, Double>();
        for (ExecutionResult result : results) {
            if (result.hasTimeout() || result.hasTestException() || result.noThrownExceptions()) continue;
            Map<MethodStatement, Object> returnValues = result.getReturnValues();
            block7: for (Map.Entry<MethodStatement, Object> entry : returnValues.entrySet()) {
                String strGoal;
                String className = entry.getKey().getMethod().getMethod().getDeclaringClass().getName();
                String methodName = entry.getKey().getMethod().getName() + Type.getMethodDescriptor((Method)entry.getKey().getMethod().getMethod());
                Type returnType = Type.getReturnType((Method)entry.getKey().getMethod().getMethod());
                Object returnValue = entry.getValue();
                String goalSuffix = "";
                switch (returnType.getSort()) {
                    case 1: {
                        if (((Boolean)returnValue).booleanValue()) {
                            goalSuffix = "true";
                            break;
                        }
                        goalSuffix = "false";
                        break;
                    }
                    case 2: {
                        char c = ((Character)returnValue).charValue();
                        if (Character.isAlphabetic(c)) {
                            goalSuffix = "alpha";
                            break;
                        }
                        if (Character.isDigit(c)) {
                            goalSuffix = "digit";
                            break;
                        }
                        goalSuffix = "other";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        assert (returnValue != null);
                        assert (returnValue instanceof Number);
                        double value = ((Number)returnValue).doubleValue();
                        if (Double.isNaN(value)) continue block7;
                        goalSuffix = value < 0.0 ? "negative" : (value == 0.0 ? "zero" : "positive");
                        this.updateDistances(mapDistances, className, methodName, value);
                        break;
                    }
                    case 9: 
                    case 10: {
                        if (returnValue == null) {
                            goalSuffix = "null";
                            break;
                        }
                        goalSuffix = "nonnull";
                        break;
                    }
                }
                if (goalSuffix.isEmpty() || !this.outputCoverageMap.containsKey(strGoal = OutputCoverageFactory.goalString(className, methodName, goalSuffix))) continue;
                setOfCoveredGoals.add(strGoal);
                result.test.addCoveredGoal(this.outputCoverageMap.get(strGoal));
            }
        }
        double distance = 0.0;
        for (String strG : this.outputCoverageMap.keySet()) {
            if (setOfCoveredGoals.contains(strG)) continue;
            if (mapDistances.containsKey(strG)) {
                distance += OutputCoverageSuiteFitness.normalize((Double)mapDistances.get(strG));
                continue;
            }
            distance += 1.0;
        }
        return distance;
    }

    private void updateDistances(Map<String, Double> mapDistances, String className, String methodName, double value) {
        String goalNegative = OutputCoverageFactory.goalString(className, methodName, "negative");
        String goalZero = OutputCoverageFactory.goalString(className, methodName, "zero");
        String goalPositive = OutputCoverageFactory.goalString(className, methodName, "positive");
        double distanceToNegative = 0.0;
        double distanceToZero = 0.0;
        double distanceToPositive = 0.0;
        if (value < 0.0) {
            distanceToNegative = 0.0;
            distanceToZero = Math.abs(value);
            distanceToPositive = Math.abs(value) + 1.0;
        } else if (value == 0.0) {
            distanceToNegative = 1.0;
            distanceToZero = 0.0;
            distanceToPositive = 1.0;
        } else {
            distanceToNegative = value + 1.0;
            distanceToZero = value;
            distanceToPositive = 0.0;
        }
        if (mapDistances.containsKey(goalNegative)) {
            if (distanceToNegative < mapDistances.get(goalNegative)) {
                mapDistances.put(goalNegative, distanceToNegative);
            }
        } else {
            mapDistances.put(goalNegative, distanceToNegative);
        }
        if (mapDistances.containsKey(goalZero)) {
            if (distanceToZero < mapDistances.get(goalZero)) {
                mapDistances.put(goalZero, distanceToZero);
            }
        } else {
            mapDistances.put(goalZero, distanceToZero);
        }
        if (mapDistances.containsKey(goalPositive)) {
            if (distanceToPositive < mapDistances.get(goalPositive)) {
                mapDistances.put(goalPositive, distanceToPositive);
            }
        } else {
            mapDistances.put(goalPositive, distanceToPositive);
        }
    }

    private void printStatusMessages(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite, int coveredGoals, double fitness) {
        if (coveredGoals > this.maxCoveredGoals) {
            logger.info("(Output Goals) Best individual covers " + coveredGoals + "/" + this.totalGoals + " output goals");
            this.maxCoveredGoals = coveredGoals;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
        if (fitness < this.bestFitness) {
            logger.info("(Fitness) Best individual covers " + coveredGoals + "/" + this.totalGoals + " output goals");
            this.bestFitness = fitness;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
    }
}

