/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.output;

import java.util.HashMap;
import java.util.Map;
import org.evosuite.testcase.execution.ExecutionObserver;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputObserver
extends ExecutionObserver {
    private Map<MethodStatement, Object> returnValues = new HashMap<MethodStatement, Object>();
    private static final Logger logger = LoggerFactory.getLogger(OutputObserver.class);

    @Override
    public void output(int position, String output) {
    }

    @Override
    public void beforeStatement(Statement statement, Scope scope) {
    }

    @Override
    public void afterStatement(Statement statement, Scope scope, Throwable exception) {
        if (statement instanceof MethodStatement) {
            MethodStatement methodStmt = (MethodStatement)statement;
            VariableReference varRef = methodStmt.getReturnValue();
            Object returnObject = scope.getObject(varRef);
            if (exception == null && !methodStmt.getReturnType().equals(Void.TYPE)) {
                this.returnValues.put(methodStmt, returnObject);
            }
        }
    }

    @Override
    public void testExecutionFinished(ExecutionResult r) {
        logger.info("Adding returnValues map to ExecutionResult");
        r.setReturnValues(this.returnValues);
    }

    @Override
    public void clear() {
        this.returnValues = new HashMap<MethodStatement, Object>();
    }

    public Map<MethodStatement, Object> getreturnValues() {
        return this.returnValues;
    }
}

