/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.rho;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.MethodNameMatcher;
import org.evosuite.coverage.rho.RhoCoverageTestFitness;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.testsuite.AbstractFitnessFactory;

public class RhoCoverageFactory
extends AbstractFitnessFactory<RhoCoverageTestFitness> {
    private static boolean called = false;
    private static List<RhoCoverageTestFitness> goals = new ArrayList<RhoCoverageTestFitness>();
    private static int number_of_ones = 0;
    private static int number_of_test_cases = 0;
    private static LinkedHashSet<Integer> lineNumbers = new LinkedHashSet();

    private static void computeGoals() {
        if (called) {
            return;
        }
        String targetClass = Properties.TARGET_CLASS;
        MethodNameMatcher matcher = new MethodNameMatcher();
        for (String className : BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).knownClasses()) {
            if (!targetClass.equals("") && !className.endsWith(targetClass)) continue;
            for (String methodName : BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).knownMethods(className)) {
                if (!matcher.methodMatches(methodName)) continue;
                for (BytecodeInstruction ins : BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getInstructionsIn(className, methodName)) {
                    if (!RhoCoverageFactory.isUsable(ins)) continue;
                    goals.add(new RhoCoverageTestFitness(ins));
                }
            }
        }
        called = true;
        RhoCoverageFactory.loadCoverage();
    }

    private static boolean isUsable(BytecodeInstruction ins) {
        if (!lineNumbers.add(ins.getLineNumber())) {
            return false;
        }
        return ins.isLineNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void loadCoverage() {
        BufferedReader br = null;
        try {
            String sCurrentLine;
            br = new BufferedReader(new FileReader(Properties.REPORT_DIR + File.separator + "data" + File.separator + Properties.TARGET_CLASS + ".matrix"));
            while ((sCurrentLine = br.readLine()) != null) {
                String[] split = sCurrentLine.split(" ");
                for (int i = 0; i < split.length - 1; ++i) {
                    if (split[i].compareTo("1") != 0) continue;
                    ++number_of_ones;
                }
                ++number_of_test_cases;
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public List<RhoCoverageTestFitness> getCoverageGoals() {
        if (!called) {
            RhoCoverageFactory.computeGoals();
        }
        return goals;
    }

    public static List<RhoCoverageTestFitness> retrieveCoverageGoals() {
        if (!called) {
            RhoCoverageFactory.computeGoals();
        }
        return goals;
    }

    public static int getNumberOnes() {
        return number_of_ones;
    }

    public static int getNumberTestCases() {
        return number_of_test_cases;
    }
}

