/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.rho;

import java.util.List;
import org.evosuite.coverage.rho.RhoCoverageFactory;
import org.evosuite.coverage.rho.RhoCoverageTestFitness;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class RhoCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = 9062499323967883418L;

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite) {
        List<ExecutionResult> results = this.runTestSuite(suite);
        List<RhoCoverageTestFitness> goals = RhoCoverageFactory.retrieveCoverageGoals();
        double fitness = 0.0;
        double n_ones = RhoCoverageFactory.getNumberOnes();
        for (ExecutionResult result : results) {
            for (TestFitnessFunction testFitnessFunction : goals) {
                if (!testFitnessFunction.isCovered(result)) continue;
                n_ones += 1.0;
            }
        }
        double n_tests = (double)suite.size() + (double)RhoCoverageFactory.getNumberTestCases();
        fitness = n_ones / n_tests / (double)goals.size();
        fitness = Math.abs(0.5 - fitness);
        this.updateIndividual(this, suite, fitness);
        return fitness;
    }

    @Override
    public boolean isMaximizationFunction() {
        return false;
    }
}

