/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga;

import org.evosuite.ga.SecondaryObjective;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class IBranchSecondaryObjective
extends SecondaryObjective<AbstractTestSuiteChromosome<? extends ExecutableChromosome>> {
    private TestSuiteFitnessFunction ff;
    private static final long serialVersionUID = 7211557650429998223L;

    public IBranchSecondaryObjective(TestSuiteFitnessFunction fitness) {
        this.ff = fitness;
    }

    @Override
    public int compareChromosomes(AbstractTestSuiteChromosome<? extends ExecutableChromosome> chromosome1, AbstractTestSuiteChromosome<? extends ExecutableChromosome> chromosome2) {
        if (!chromosome1.hasExecutedFitness(this.ff) || chromosome1.isChanged()) {
            this.ff.getFitness(chromosome1);
        }
        if (!chromosome2.hasExecutedFitness(this.ff) || chromosome2.isChanged()) {
            this.ff.getFitness(chromosome2);
        }
        logger.debug("Comparing sizes: " + chromosome1.getFitness(this.ff) + " vs " + chromosome2.getFitness(this.ff));
        int i = (int)Math.signum(chromosome1.getFitness(this.ff) - chromosome2.getFitness(this.ff));
        this.ff.updateCoveredGoals();
        return i;
    }

    @Override
    public int compareGenerations(AbstractTestSuiteChromosome<? extends ExecutableChromosome> parent1, AbstractTestSuiteChromosome<? extends ExecutableChromosome> parent2, AbstractTestSuiteChromosome<? extends ExecutableChromosome> child1, AbstractTestSuiteChromosome<? extends ExecutableChromosome> child2) {
        double minChildren;
        double minParents;
        logger.debug("Comparing sizes: " + parent1.size() + ", " + parent1.size() + " vs " + child1.size() + ", " + child2.size());
        if (!parent1.hasExecutedFitness(this.ff) || parent1.isChanged()) {
            this.ff.getFitness(parent1);
        }
        if (!parent2.hasExecutedFitness(this.ff) || parent2.isChanged()) {
            this.ff.getFitness(parent2);
        }
        if (!child1.hasExecutedFitness(this.ff) || child1.isChanged()) {
            this.ff.getFitness(child1);
        }
        if (!child2.hasExecutedFitness(this.ff) || child2.isChanged()) {
            this.ff.getFitness(child2);
        }
        if ((minParents = Math.min(parent1.getFitness(this.ff), parent2.getFitness(this.ff))) < (minChildren = Math.min(child1.getFitness(this.ff), child2.getFitness(this.ff)))) {
            return -1;
        }
        if (minParents > minChildren) {
            return 1;
        }
        return 0;
    }
}

