/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import java.util.ArrayList;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.FitnessReplacementFunction;
import org.evosuite.ga.ReplacementFunction;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonotonicGA<T extends Chromosome>
extends GeneticAlgorithm<T> {
    private static final long serialVersionUID = 7846967347821123201L;
    protected ReplacementFunction replacementFunction;
    private final Logger logger = LoggerFactory.getLogger(MonotonicGA.class);

    public MonotonicGA(ChromosomeFactory<T> factory) {
        super(factory);
        this.setReplacementFunction(new FitnessReplacementFunction());
    }

    protected boolean keepOffspring(Chromosome parent1, Chromosome parent2, Chromosome offspring1, Chromosome offspring2) {
        return this.replacementFunction.keepOffspring(parent1, parent2, offspring1, offspring2);
    }

    @Override
    protected void evolve() {
        ArrayList<Object> newGeneration = new ArrayList<Object>();
        this.logger.debug("Elitism");
        newGeneration.addAll(this.elitism());
        while (!this.isNextPopulationFull(newGeneration) && !this.isFinished()) {
            Chromosome offspring2;
            Chromosome offspring1;
            T parent2;
            Object parent1;
            block14: {
                this.logger.debug("Generating offspring");
                parent1 = this.selectionFunction.select(this.population);
                parent2 = Properties.HEADLESS_CHICKEN_TEST ? this.newRandomIndividual() : this.selectionFunction.select(this.population);
                offspring1 = ((Chromosome)parent1).clone();
                offspring2 = ((Chromosome)parent2).clone();
                try {
                    if (!(Randomness.nextDouble() <= Properties.CROSSOVER_RATE)) break block14;
                    this.crossoverFunction.crossOver(offspring1, offspring2);
                }
                catch (ConstructionFailedException e) {
                    this.logger.info("CrossOver failed");
                    continue;
                }
            }
            this.notifyMutation(offspring1);
            offspring1.mutate();
            this.notifyMutation(offspring2);
            offspring2.mutate();
            if (offspring1.isChanged()) {
                offspring1.updateAge(this.currentIteration);
            }
            if (offspring2.isChanged()) {
                offspring2.updateAge(this.currentIteration);
            }
            for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
                fitnessFunction.getFitness(offspring1);
                this.notifyEvaluation(offspring1);
                fitnessFunction.getFitness(offspring2);
                this.notifyEvaluation(offspring2);
            }
            if (this.keepOffspring((Chromosome)parent1, (Chromosome)parent2, offspring1, offspring2)) {
                this.logger.debug("Keeping offspring");
                int rejected = 0;
                if (this.isTooLong(offspring1) || offspring1.size() == 0) {
                    ++rejected;
                } else {
                    newGeneration.add(offspring1);
                }
                if (this.isTooLong(offspring2) || offspring2.size() == 0) {
                    ++rejected;
                } else {
                    newGeneration.add(offspring2);
                }
                if (rejected == 1) {
                    newGeneration.add(Randomness.choice(parent1, parent2));
                    continue;
                }
                if (rejected != 2) continue;
                newGeneration.add(parent1);
                newGeneration.add(parent2);
                continue;
            }
            this.logger.debug("Keeping parents");
            newGeneration.add(parent1);
            newGeneration.add(parent2);
        }
        this.population = newGeneration;
        this.updateFitnessFuntions();
        for (Chromosome t : this.population) {
            if (!t.isToBeUpdated()) continue;
            for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
                fitnessFunction.getFitness(t);
            }
            t.isToBeUpdated(false);
        }
        ++this.currentIteration;
    }

    private T newRandomIndividual() {
        Object randomChromosome = this.chromosomeFactory.getChromosome();
        for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
            ((Chromosome)randomChromosome).addFitness(fitnessFunction);
        }
        return randomChromosome;
    }

    @Override
    public void initializePopulation() {
        this.notifySearchStarted();
        this.currentIteration = 0;
        this.generateInitialPopulation(Properties.POPULATION);
        this.logger.debug("Calculating fitness of initial population");
        this.calculateFitnessAndSortPopulation();
        this.notifyIteration();
    }

    @Override
    public void generateSolution() {
        if (Properties.ENABLE_SECONDARY_OBJECTIVE_AFTER > 0 || Properties.ENABLE_SECONDARY_OBJECTIVE_STARVATION) {
            this.disableFirstSecondaryCriterion();
        }
        if (this.population.isEmpty()) {
            this.initializePopulation();
        }
        this.logger.debug("Starting evolution");
        int starvationCounter = 0;
        double bestFitness = Double.MAX_VALUE;
        double lastBestFitness = Double.MAX_VALUE;
        if (this.getFitnessFunction().isMaximizationFunction()) {
            bestFitness = 0.0;
            lastBestFitness = 0.0;
        }
        while (!this.isFinished()) {
            this.logger.info("Population size before: " + this.population.size());
            this.evolve();
            this.sortPopulation();
            this.applyLocalSearch();
            double newFitness = this.getBestIndividual().getFitness();
            if (this.getFitnessFunction().isMaximizationFunction() ? !$assertionsDisabled && !(newFitness >= bestFitness) : !$assertionsDisabled && !(newFitness <= bestFitness)) {
                throw new AssertionError((Object)("Best fitness was: " + bestFitness + ", now best fitness is " + newFitness));
            }
            bestFitness = newFitness;
            if (Double.compare(bestFitness, lastBestFitness) == 0) {
                ++starvationCounter;
            } else {
                this.logger.info("reset starvationCounter after " + starvationCounter + " iterations");
                starvationCounter = 0;
                lastBestFitness = bestFitness;
            }
            this.updateSecondaryCriterion(starvationCounter);
            this.logger.info("Current iteration: " + this.currentIteration);
            this.notifyIteration();
            this.logger.info("Population size: " + this.population.size());
            this.logger.info("Best individual has fitness: " + ((Chromosome)this.population.get(0)).getFitness());
            this.logger.info("Worst individual has fitness: " + ((Chromosome)this.population.get(this.population.size() - 1)).getFitness());
        }
        this.retrieveBestSuiteFromArchives();
        this.notifySearchFinished();
    }

    public void setReplacementFunction(ReplacementFunction replacement_function) {
        this.replacementFunction = replacement_function;
    }

    public ReplacementFunction getReplacementFunction() {
        return this.replacementFunction;
    }
}

