/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnePlusOneEA<T extends Chromosome>
extends GeneticAlgorithm<T> {
    private static final long serialVersionUID = 5229089847512798127L;
    private final Logger logger = LoggerFactory.getLogger(OnePlusOneEA.class);

    public OnePlusOneEA(ChromosomeFactory<T> factory) {
        super(factory);
    }

    @Override
    protected void evolve() {
        Chromosome parent = (Chromosome)this.population.get(0);
        Chromosome offspring = parent.clone();
        offspring.updateAge(this.currentIteration);
        this.notifyMutation(offspring);
        do {
            offspring.mutate();
        } while (!offspring.isChanged());
        for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
            fitnessFunction.getFitness(offspring);
            this.notifyEvaluation(offspring);
        }
        this.notifyEvaluation(offspring);
        if (this.isBetterOrEqual(offspring, parent)) {
            this.population.set(0, offspring);
        }
        ++this.currentIteration;
    }

    @Override
    public void initializePopulation() {
        this.notifySearchStarted();
        this.currentIteration = 0;
        this.generateRandomPopulation(1);
        this.getFitnessFunction().getFitness((Chromosome)this.population.get(0));
        this.notifyIteration();
        this.logger.info("Initial fitness: " + ((Chromosome)this.population.get(0)).getFitness());
    }

    @Override
    public void generateSolution() {
        if (this.population.isEmpty()) {
            this.initializePopulation();
        }
        double fitness = ((Chromosome)this.population.get(0)).getFitness();
        while (!this.isFinished()) {
            if (this.getFitnessFunction().isMaximizationFunction() && this.getBestIndividual().getFitness() > fitness || !this.getFitnessFunction().isMaximizationFunction() && this.getBestIndividual().getFitness() < fitness) {
                this.logger.info("Current generation: " + this.getAge());
                this.logger.info("Best fitness: " + this.getBestIndividual().getFitness());
                fitness = ((Chromosome)this.population.get(0)).getFitness();
            }
            this.evolve();
            this.applyLocalSearch();
            this.notifyIteration();
        }
        this.notifySearchFinished();
    }
}

