/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.MonotonicGA;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SteadyStateGA<T extends Chromosome>
extends MonotonicGA<T> {
    private static final long serialVersionUID = 7301010503732698233L;
    private final Logger logger = LoggerFactory.getLogger(SteadyStateGA.class);

    public SteadyStateGA(ChromosomeFactory<T> factory) {
        super(factory);
    }

    @Override
    protected void evolve() {
        this.logger.debug("Generating offspring");
        ++this.currentIteration;
        Object parent1 = this.selectionFunction.select(this.population);
        Object parent2 = this.selectionFunction.select(this.population);
        Chromosome offspring1 = ((Chromosome)parent1).clone();
        Chromosome offspring2 = ((Chromosome)parent2).clone();
        try {
            if (Randomness.nextDouble() <= Properties.CROSSOVER_RATE) {
                this.crossoverFunction.crossOver(offspring1, offspring2);
            }
            this.notifyMutation(offspring1);
            offspring1.mutate();
            this.notifyMutation(offspring2);
            offspring2.mutate();
            if (offspring1.isChanged()) {
                offspring1.updateAge(this.currentIteration);
            }
            if (offspring2.isChanged()) {
                offspring2.updateAge(this.currentIteration);
            }
        }
        catch (ConstructionFailedException e) {
            this.logger.info("CrossOver/Mutation failed");
            return;
        }
        for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
            fitnessFunction.getFitness(offspring1);
            this.notifyEvaluation(offspring1);
            fitnessFunction.getFitness(offspring2);
            this.notifyEvaluation(offspring2);
        }
        if (!Properties.PARENT_CHECK || this.keepOffspring((Chromosome)parent1, (Chromosome)parent2, offspring1, offspring2)) {
            this.logger.debug("Keeping offspring");
            if (!this.isTooLong(offspring1)) {
                this.population.remove(parent1);
                this.population.add(offspring1);
            }
            if (!this.isTooLong(offspring2)) {
                this.population.remove(parent2);
                this.population.add(offspring2);
            }
        } else {
            this.logger.debug("Keeping parents");
        }
        this.updateFitnessFuntions();
        for (Chromosome t : this.population) {
            if (!t.isToBeUpdated()) continue;
            for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
                fitnessFunction.getFitness(t);
            }
            t.isToBeUpdated(false);
        }
    }
}

