/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.stoppingconditions;

import org.evosuite.Properties;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.stoppingconditions.StoppingConditionImpl;

public class MaxTimeStoppingCondition
extends StoppingConditionImpl {
    private static final long serialVersionUID = -4524853279562896768L;
    protected long maxSeconds = Properties.SEARCH_BUDGET;
    protected long startTime;

    @Override
    public void searchStarted(GeneticAlgorithm<?> algorithm) {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public boolean isFinished() {
        long currentTime = System.currentTimeMillis();
        return (currentTime - this.startTime) / 1000L > this.maxSeconds;
    }

    @Override
    public void reset() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void setLimit(long limit) {
        this.maxSeconds = limit;
    }

    @Override
    public long getLimit() {
        return this.maxSeconds;
    }

    @Override
    public long getCurrentValue() {
        long currentTime = System.currentTimeMillis();
        return (currentTime - this.startTime) / 1000L;
    }

    @Override
    public void forceCurrentValue(long value) {
        this.startTime = value;
    }
}

