/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.stoppingconditions;

import org.evosuite.Properties;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.stoppingconditions.StoppingConditionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeDeltaStoppingCondition
extends StoppingConditionImpl {
    private static final long serialVersionUID = -7029615280866928031L;
    protected long startTime = 0L;
    protected long lastImprovement = 0L;
    protected long lastGeneration = 0L;
    protected double lastFitness = 0.0;
    private static final Logger logger = LoggerFactory.getLogger(TimeDeltaStoppingCondition.class);

    @Override
    public void searchStarted(GeneticAlgorithm<?> algorithm) {
        this.lastFitness = algorithm.getFitnessFunction().isMaximizationFunction() ? 0.0 : Double.MAX_VALUE;
        this.startTime = System.currentTimeMillis();
        this.lastGeneration = 0L;
    }

    @Override
    public void iteration(GeneticAlgorithm<?> algorithm) {
        double currentBestFitness = algorithm.getBestIndividual().getFitness();
        if (algorithm.getFitnessFunction().isMaximizationFunction()) {
            if (currentBestFitness > this.lastFitness) {
                this.lastFitness = currentBestFitness;
                this.lastImprovement = System.currentTimeMillis();
            }
        } else if (currentBestFitness < this.lastFitness) {
            this.lastFitness = currentBestFitness;
            this.lastImprovement = System.currentTimeMillis();
        }
        this.lastGeneration = System.currentTimeMillis();
    }

    @Override
    public long getCurrentValue() {
        long current_time = System.currentTimeMillis();
        return (int)((current_time - this.startTime) / 1000L);
    }

    @Override
    public boolean isFinished() {
        long current_time = System.currentTimeMillis();
        if (Properties.GLOBAL_TIMEOUT != 0 && this.startTime != 0L && (current_time - this.startTime) / 1000L > (long)Properties.GLOBAL_TIMEOUT) {
            logger.info("Global timeout reached");
            return true;
        }
        if (this.lastImprovement < this.startTime) {
            logger.info("Waiting for first generation.");
            return false;
        }
        if ((current_time - this.lastGeneration) / 1000L > Properties.SEARCH_BUDGET) {
            logger.info("Waiting for at least a generation within the timeout.");
            return false;
        }
        if ((current_time - this.lastImprovement) / 1000L > Properties.SEARCH_BUDGET) {
            logger.info("No improvement timeout.");
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
    }

    @Override
    public void setLimit(long limit) {
    }

    @Override
    public long getLimit() {
        return Properties.GLOBAL_TIMEOUT;
    }

    @Override
    public void forceCurrentValue(long value) {
    }
}

