/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.cdg;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class DominatorNode<V> {
    final V node;
    int n = 0;
    DominatorNode<V> parent;
    DominatorNode<V> semiDominator;
    DominatorNode<V> immediateDominator;
    Set<DominatorNode<V>> bucket = new HashSet<DominatorNode<V>>();
    DominatorNode<V> ancestor;
    DominatorNode<V> label;

    DominatorNode(V node) {
        this.node = node;
        this.label = this;
    }

    void link(DominatorNode<V> v) {
        this.ancestor = v;
    }

    DominatorNode<V> eval() {
        if (this.ancestor == null) {
            return this;
        }
        this.compress();
        return this.label;
    }

    void compress() {
        if (this.ancestor == null) {
            throw new IllegalStateException("may only be called when ancestor is set");
        }
        if (this.ancestor.ancestor != null) {
            this.ancestor.compress();
            if (this.ancestor.label.semiDominator.n < this.label.semiDominator.n) {
                this.label = this.ancestor.label;
            }
            this.ancestor = this.ancestor.ancestor;
        }
    }

    DominatorNode<V> getFromBucket() {
        Iterator<DominatorNode<V>> i$ = this.bucket.iterator();
        if (i$.hasNext()) {
            DominatorNode<V> r = i$.next();
            return r;
        }
        return null;
    }

    public boolean isRootNode() {
        return this.n == 1;
    }

    public String toString() {
        return "DTNode " + this.n + " - " + this.node;
    }
}

