/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.cfg;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.coverage.dataflow.DefUsePool;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.cdg.ControlDependenceGraph;
import org.evosuite.graphs.cfg.ASMWrapper;
import org.evosuite.graphs.cfg.ActualControlFlowGraph;
import org.evosuite.graphs.cfg.BasicBlock;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.graphs.cfg.CFGFrame;
import org.evosuite.graphs.cfg.ControlDependency;
import org.evosuite.graphs.cfg.RawControlFlowGraph;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.SourceValue;

public class BytecodeInstruction
extends ASMWrapper
implements Serializable,
Comparable<BytecodeInstruction> {
    private static final long serialVersionUID = 3630449183355518857L;
    protected ClassLoader classLoader;
    protected String className;
    protected String methodName;
    protected int instructionId;
    protected int bytecodeOffset;
    private int lineNumber = -1;
    private BasicBlock basicBlock;

    public BytecodeInstruction(ClassLoader classLoader, String className, String methodName, int instructionId, int bytecodeOffset, AbstractInsnNode asmNode) {
        if (className == null || methodName == null || asmNode == null) {
            throw new IllegalArgumentException("null given");
        }
        if (instructionId < 0) {
            throw new IllegalArgumentException("expect instructionId to be positive, not " + instructionId);
        }
        this.instructionId = instructionId;
        this.bytecodeOffset = bytecodeOffset;
        this.asmNode = asmNode;
        this.classLoader = classLoader;
        this.setClassName(className);
        this.setMethodName(methodName);
    }

    public BytecodeInstruction(BytecodeInstruction wrap) {
        this(wrap.classLoader, wrap.className, wrap.methodName, wrap.instructionId, wrap.bytecodeOffset, wrap.asmNode, wrap.lineNumber, wrap.basicBlock);
        this.forcedBranch = wrap.forcedBranch;
        this.frame = wrap.frame;
    }

    public BytecodeInstruction(ClassLoader classLoader, String className, String methodName, int instructionId, int bytecodeOffset, AbstractInsnNode asmNode, int lineNumber, BasicBlock basicBlock) {
        this(classLoader, className, methodName, instructionId, bytecodeOffset, asmNode, lineNumber);
        this.basicBlock = basicBlock;
    }

    public BytecodeInstruction(ClassLoader classLoader, String className, String methodName, int instructionId, int bytecodeOffset, AbstractInsnNode asmNode, int lineNumber) {
        this(classLoader, className, methodName, instructionId, bytecodeOffset, asmNode);
        if (lineNumber != -1) {
            this.setLineNumber(lineNumber);
        }
    }

    private void setMethodName(String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("null given");
        }
        this.methodName = methodName;
    }

    private void setClassName(String className) {
        if (className == null) {
            throw new IllegalArgumentException("null given");
        }
        this.className = className;
    }

    public void setCFGFrame(CFGFrame frame) {
        this.frame = frame;
    }

    @Override
    public int getInstructionId() {
        return this.instructionId;
    }

    public int getBytecodeOffset() {
        return this.bytecodeOffset;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return "BytecodeInstruction " + this.instructionId + " in " + this.methodName;
    }

    public BasicBlock getBasicBlock() {
        if (!this.hasBasicBlockSet()) {
            this.retrieveBasicBlock();
        }
        return this.basicBlock;
    }

    private void retrieveBasicBlock() {
        if (this.basicBlock == null) {
            this.basicBlock = this.getActualCFG().getBlockOf(this);
        }
    }

    public void setBasicBlock(BasicBlock block) {
        if (block == null) {
            throw new IllegalArgumentException("null given");
        }
        if (!block.getClassName().equals(this.getClassName()) || !block.getMethodName().equals(this.getMethodName())) {
            throw new IllegalArgumentException("expect block to be for the same method and class as this instruction");
        }
        if (this.basicBlock != null) {
            throw new IllegalArgumentException("basicBlock already set! not allowed to overwrite");
        }
        this.basicBlock = block;
    }

    public boolean hasBasicBlockSet() {
        return this.basicBlock != null;
    }

    @Override
    public int getLineNumber() {
        if (this.lineNumber == -1 && this.isLineNumber()) {
            this.retrieveLineNumber();
        }
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        if (lineNumber <= 0) {
            throw new IllegalArgumentException("expect lineNumber value to be positive");
        }
        if (this.isLabel()) {
            return;
        }
        if (this.isLineNumber()) {
            int asmLine = super.getLineNumber();
            if (lineNumber != -1 && asmLine != lineNumber) {
                throw new IllegalStateException("linenumber instruction has lineNumber field set to a value different from instruction linenumber");
            }
            this.lineNumber = asmLine;
        } else {
            this.lineNumber = lineNumber;
        }
    }

    public boolean hasLineNumberSet() {
        this.retrieveLineNumber();
        return this.lineNumber != -1;
    }

    private void retrieveLineNumber() {
        if (this.isLineNumber()) {
            int asmLine = super.getLineNumber();
            if (this.lineNumber != -1 && asmLine != this.lineNumber) {
                throw new IllegalStateException("lineNumber field was manually set to a value different from the actual lineNumber contained in LineNumberNode");
            }
            this.lineNumber = asmLine;
        }
    }

    public ActualControlFlowGraph getActualCFG() {
        ActualControlFlowGraph myCFG = GraphPool.getInstance(this.classLoader).getActualCFG(this.className, this.methodName);
        if (myCFG == null) {
            throw new IllegalStateException("expect GraphPool to know CFG for every method for which an instruction is known");
        }
        return myCFG;
    }

    @Override
    public RawControlFlowGraph getRawCFG() {
        RawControlFlowGraph myCFG = GraphPool.getInstance(this.classLoader).getRawCFG(this.className, this.methodName);
        if (myCFG == null) {
            throw new IllegalStateException("expect GraphPool to know CFG for every method for which an instruction is known");
        }
        return myCFG;
    }

    public ControlDependenceGraph getCDG() {
        ControlDependenceGraph myCDG = GraphPool.getInstance(this.classLoader).getCDG(this.className, this.methodName);
        if (myCDG == null) {
            throw new IllegalStateException("expect GraphPool to know CDG for every method for which an instruction is known");
        }
        return myCDG;
    }

    public Set<ControlDependency> getControlDependencies() {
        BasicBlock myBlock = this.getBasicBlock();
        return myBlock.getControlDependencies();
    }

    public Branch getControlDependentBranch() {
        Set<ControlDependency> controlDependentBranches = this.getControlDependencies();
        Iterator<ControlDependency> i$ = controlDependentBranches.iterator();
        if (i$.hasNext()) {
            ControlDependency cd = i$.next();
            return cd.getBranch();
        }
        return null;
    }

    public Set<Integer> getControlDependentBranchIds() {
        BasicBlock myBlock = this.getBasicBlock();
        return myBlock.getControlDependentBranchIds();
    }

    public boolean isRootBranchDependent() {
        return this.getControlDependencies().isEmpty();
    }

    public int getControlDependentBranchId() {
        Branch b = this.getControlDependentBranch();
        if (b == null) {
            return -1;
        }
        return b.getActualBranchId();
    }

    public boolean getControlDependentBranchExpressionValue() {
        Branch b = this.getControlDependentBranch();
        return this.getBranchExpressionValue(b);
    }

    public boolean getBranchExpressionValue(Branch b) {
        if (!this.isDirectlyControlDependentOn(b)) {
            throw new IllegalArgumentException("this method can only be called for branches that this instruction is directly control dependent on.");
        }
        if (b == null) {
            return true;
        }
        return this.getControlDependency(b).getBranchExpressionValue();
    }

    public boolean isDirectlyControlDependentOn(Branch branch) {
        if (branch == null) {
            return this.getControlDependentBranchIds().contains(-1);
        }
        for (ControlDependency cd : this.getControlDependencies()) {
            if (!cd.getBranch().equals(branch)) continue;
            return true;
        }
        return false;
    }

    public ControlDependency getControlDependency(Branch branch) {
        if (!this.isDirectlyControlDependentOn(branch)) {
            throw new IllegalArgumentException("instruction not directly control dependent on given branch");
        }
        for (ControlDependency cd : this.getControlDependencies()) {
            if (!cd.getBranch().equals(branch)) continue;
            return cd;
        }
        throw new IllegalStateException("expect getControlDependencies() to contain a CD for each branch that isDirectlyControlDependentOn() returns true on");
    }

    public int getCDGDepth() {
        int min = Integer.MAX_VALUE;
        Set<ControlDependency> dependencies = this.getControlDependencies();
        if (dependencies.isEmpty()) {
            min = 1;
        }
        for (ControlDependency dependency : dependencies) {
            int depth = this.getCDG().getControlDependenceDepth(dependency);
            if (depth >= min) continue;
            min = depth;
        }
        return min;
    }

    public String explain() {
        if (this.isBranch()) {
            if (BranchPool.isKnownAsBranch(this)) {
                Branch b = BranchPool.getBranchForInstruction(this);
                if (b == null) {
                    throw new IllegalStateException("expect BranchPool to be able to return Branches for instructions fullfilling BranchPool.isKnownAsBranch()");
                }
                return "Branch " + b.getActualBranchId() + " - " + this.getInstructionType();
            }
            return "UNKNOWN Branch I" + this.instructionId + " " + this.getInstructionType() + ", jump to " + ((JumpInsnNode)this.asmNode).label.getLabel();
        }
        return this.getASMNodeString();
    }

    public String getASMNodeString() {
        String type = this.getType();
        String opcode = this.getInstructionType();
        String stack = "";
        if (this.frame == null) {
            stack = "null";
        } else {
            for (int i = 0; i < this.frame.getStackSize(); ++i) {
                stack = stack + this.frame.getStack(i) + ",";
            }
        }
        if (this.asmNode instanceof LabelNode) {
            return "LABEL " + ((LabelNode)this.asmNode).getLabel().toString();
        }
        if (this.asmNode instanceof FieldInsnNode) {
            return "Field " + ((FieldInsnNode)this.asmNode).owner + "." + ((FieldInsnNode)this.asmNode).name + " Type=" + type + ", Opcode=" + opcode;
        }
        if (this.asmNode instanceof FrameNode) {
            return "Frame " + this.asmNode.getOpcode() + " Type=" + type + ", Opcode=" + opcode;
        }
        if (this.asmNode instanceof IincInsnNode) {
            return "IINC " + ((IincInsnNode)this.asmNode).var + " Type=" + type + ", Opcode=" + opcode;
        }
        if (this.asmNode instanceof InsnNode) {
            return "" + opcode;
        }
        if (this.asmNode instanceof IntInsnNode) {
            return "INT " + ((IntInsnNode)this.asmNode).operand + " Type=" + type + ", Opcode=" + opcode;
        }
        if (this.asmNode instanceof MethodInsnNode) {
            return opcode + " " + ((MethodInsnNode)this.asmNode).owner + "." + ((MethodInsnNode)this.asmNode).name + ((MethodInsnNode)this.asmNode).desc;
        }
        if (this.asmNode instanceof JumpInsnNode) {
            return "JUMP " + ((JumpInsnNode)this.asmNode).label.getLabel() + " Type=" + type + ", Opcode=" + opcode + ", Stack: " + stack + " - Line: " + this.lineNumber;
        }
        if (this.asmNode instanceof LdcInsnNode) {
            return "LDC " + ((LdcInsnNode)this.asmNode).cst + " Type=" + type;
        }
        if (this.asmNode instanceof LineNumberNode) {
            return "LINE  " + ((LineNumberNode)this.asmNode).line;
        }
        if (this.asmNode instanceof LookupSwitchInsnNode) {
            return "LookupSwitchInsnNode " + this.asmNode.getOpcode() + " Type=" + type + ", Opcode=" + opcode;
        }
        if (this.asmNode instanceof MultiANewArrayInsnNode) {
            return "MULTIANEWARRAY  " + this.asmNode.getOpcode() + " Type=" + type + ", Opcode=" + opcode;
        }
        if (this.asmNode instanceof TableSwitchInsnNode) {
            return "TableSwitchInsnNode " + this.asmNode.getOpcode() + " Type=" + type + ", Opcode=" + opcode;
        }
        if (this.asmNode instanceof TypeInsnNode) {
            return "NEW " + ((TypeInsnNode)this.asmNode).desc;
        }
        if (this.asmNode instanceof VarInsnNode) {
            return opcode + " " + ((VarInsnNode)this.asmNode).var;
        }
        return "Unknown node Type=" + type + ", Opcode=" + opcode;
    }

    public void printFrameInformation() {
        BytecodeInstruction ins;
        AbstractInsnNode node;
        SourceValue v;
        int i;
        System.out.println("Frame STACK:");
        for (i = 0; i < this.frame.getStackSize(); ++i) {
            v = (SourceValue)this.frame.getStack(i);
            System.out.print(" " + i + "(" + v.insns.size() + "): ");
            for (Object n : v.insns) {
                node = (AbstractInsnNode)n;
                ins = BytecodeInstructionPool.getInstance(this.classLoader).getInstruction(this.className, this.methodName, node);
                System.out.print(ins.toString() + ", ");
            }
            System.out.println();
        }
        System.out.println("Frame LOCALS:");
        for (i = 1; i < this.frame.getLocals(); ++i) {
            v = (SourceValue)this.frame.getLocal(i);
            System.out.print(" " + i + "(" + v.insns.size() + "): ");
            for (Object n : v.insns) {
                node = (AbstractInsnNode)n;
                ins = BytecodeInstructionPool.getInstance(this.classLoader).getInstruction(this.className, this.methodName, node);
                System.out.print(ins.toString() + ", ");
            }
            System.out.println();
        }
    }

    public String toString() {
        String r = "I" + this.instructionId;
        r = r + " (" + this.bytecodeOffset + ")";
        r = r + " " + this.explain();
        if (this.hasLineNumberSet() && !this.isLineNumber()) {
            r = r + " l" + this.getLineNumber();
        }
        return r;
    }

    public Branch toBranch() {
        try {
            return BranchPool.getBranchForInstruction(this);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean proceedsOwnConstructorInvocation() {
        RawControlFlowGraph cfg = this.getRawCFG();
        for (BytecodeInstruction other : cfg.vertexSet()) {
            if (!other.isConstructorInvocation() || !other.isMethodCallOnSameObject() || this.getInstructionId() >= other.getInstructionId()) continue;
            return true;
        }
        return false;
    }

    public boolean isWithinConstructor() {
        return this.getMethodName().startsWith("<init>");
    }

    public boolean isLastInstructionInMethod() {
        return this.equals(this.getRawCFG().getInstructionWithBiggestId());
    }

    public boolean canBeExitPoint() {
        return this.canReturnFromMethod() || this.isLastInstructionInMethod();
    }

    public RawControlFlowGraph getCalledCFG() {
        if (!this.isMethodCall()) {
            return null;
        }
        return GraphPool.getInstance(this.classLoader).getRawCFG(this.getCalledMethodsClass(), this.getCalledMethod());
    }

    public boolean isMethodCallOnSameObject() {
        BytecodeInstruction srcInstruction = this.getSourceOfMethodInvocationInstruction();
        if (srcInstruction == null) {
            return false;
        }
        return srcInstruction.loadsReferenceToThis();
    }

    @Override
    public boolean isMethodCallOfField() {
        if (!this.isMethodCall()) {
            return false;
        }
        if (this.isInvokeStatic()) {
            return false;
        }
        if (this.methodName.contains("<clinit>")) {
            return false;
        }
        BytecodeInstruction srcInstruction = this.getSourceOfMethodInvocationInstruction();
        if (srcInstruction == null) {
            return false;
        }
        if (srcInstruction.isFieldNodeUse()) {
            if (srcInstruction.isStaticDefUse()) {
                if (srcInstruction.asmNode instanceof FieldInsnNode) {
                    String classNameField = ((FieldInsnNode)srcInstruction.asmNode).owner;
                    if ((classNameField = classNameField.replace("/", ".")).equals(this.className)) {
                        return true;
                    }
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getFieldMethodCallName() {
        BytecodeInstruction srcInstruction = this.getSourceOfMethodInvocationInstruction();
        if (srcInstruction == null) {
            return null;
        }
        return srcInstruction.getVariableName();
    }

    public BytecodeInstruction getSourceOfMethodInvocationInstruction() {
        if (!this.isMethodCall()) {
            return null;
        }
        return this.getSourceOfStackInstruction(this.getCalledMethodsArgumentCount());
    }

    @Override
    public BytecodeInstruction getSourceOfArrayReference() {
        if (this.isArrayStoreInstruction()) {
            return this.getSourceOfStackInstruction(2);
        }
        if (this.isArrayLoadInstruction()) {
            return this.getSourceOfStackInstruction(1);
        }
        return null;
    }

    public BytecodeInstruction getSourceOfStackInstruction(int positionFromTop) {
        if (this.frame == null) {
            throw new IllegalStateException("expect each BytecodeInstruction to have its CFGFrame set");
        }
        int stackPos = this.frame.getStackSize() - (1 + positionFromTop);
        if (stackPos < 0) {
            StackTraceElement[] se = new Throwable().getStackTrace();
            System.out.println("Stack trace: ");
            for (int t = 0; t < se.length; ++t) {
                System.out.println(se[t]);
            }
            return null;
        }
        SourceValue source = (SourceValue)this.frame.getStack(stackPos);
        if (source.insns.size() != 1) {
            return null;
        }
        Object sourceIns = source.insns.iterator().next();
        AbstractInsnNode sourceInstruction = (AbstractInsnNode)sourceIns;
        BytecodeInstruction src = BytecodeInstructionPool.getInstance(this.classLoader).getInstruction(this.className, this.methodName, sourceInstruction);
        return src;
    }

    @Override
    public boolean isFieldMethodCallDefinition() {
        if (!this.isMethodCallOfField()) {
            return false;
        }
        if (!DefUsePool.isKnownAsUse(this) || !DefUsePool.isKnownAsFieldMethodCall(this)) {
            return true;
        }
        return DefUsePool.isKnownAsDefinition(this);
    }

    @Override
    public boolean isFieldMethodCallUse() {
        if (!this.isMethodCallOfField()) {
            return false;
        }
        if (DefUsePool.isKnownAsFieldMethodCall(this) && !DefUsePool.isKnownAsDefinition(this)) {
            return true;
        }
        return DefUsePool.isKnownAsUse(this);
    }

    public boolean isCallToPublicMethod() {
        if (!this.isMethodCall()) {
            return false;
        }
        if (this.getCalledCFG() == null) {
            return false;
        }
        return this.getCalledCFG().isPublicMethod();
    }

    public boolean isCallToStaticMethod() {
        if (!this.isMethodCall()) {
            return false;
        }
        if (this.getCalledCFG() == null) {
            return false;
        }
        return this.getCalledCFG().isStaticMethod();
    }

    public boolean canBeInstrumented() {
        return !this.isWithinConstructor() || !this.proceedsOwnConstructorInvocation();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + this.instructionId;
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BytecodeInstruction other = (BytecodeInstruction)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.instructionId != other.instructionId) {
            return false;
        }
        return !(this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName));
    }

    @Override
    public int compareTo(BytecodeInstruction o) {
        return this.getLineNumber() - o.getLineNumber();
    }
}

