/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.cfg;

import java.io.Serializable;
import org.evosuite.coverage.branch.Branch;

public class ControlDependency
implements Serializable {
    private static final long serialVersionUID = 6288839964561655730L;
    private final Branch branch;
    private final boolean branchExpressionValue;

    public ControlDependency(Branch branch, boolean branchExpressionValue) {
        if (branch == null) {
            throw new IllegalArgumentException("control dependencies for the root branch are not permitted (null)");
        }
        this.branch = branch;
        this.branchExpressionValue = branchExpressionValue;
    }

    public Branch getBranch() {
        return this.branch;
    }

    public boolean getBranchExpressionValue() {
        return this.branchExpressionValue;
    }

    public String toString() {
        String r = "CD " + this.branch.toString();
        if (!this.branch.isSwitchCaseBranch()) {
            r = this.branchExpressionValue ? r + " - TRUE" : r + " - FALSE";
        }
        return r;
    }
}

