/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.cfg;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.evosuite.graphs.EvoSuiteGraph;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.ControlFlowEdge;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ControlFlowGraph<V>
extends EvoSuiteGraph<V, ControlFlowEdge> {
    private static Logger logger = LoggerFactory.getLogger(ControlFlowGraph.class);
    protected String className;
    protected String methodName;
    protected int access;
    private int diameter = -1;

    protected ControlFlowGraph(String className, String methodName, int access) {
        super(ControlFlowEdge.class);
        if (className == null || methodName == null) {
            throw new IllegalArgumentException("null given");
        }
        this.className = className;
        this.methodName = methodName;
        this.access = access;
    }

    protected ControlFlowGraph(String className, String methodName, int access, DefaultDirectedGraph<V, ControlFlowEdge> jGraph) {
        super(jGraph, ControlFlowEdge.class);
        if (className == null || methodName == null) {
            throw new IllegalArgumentException("null given");
        }
        this.className = className;
        this.methodName = methodName;
        this.access = access;
    }

    public boolean leadsToNode(ControlFlowEdge e, V b) {
        HashSet handled = new HashSet();
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.add(this.getEdgeTarget(e));
        while (!queue.isEmpty()) {
            Object current = queue.poll();
            if (handled.contains(current)) continue;
            handled.add(current);
            for (Object next : this.getChildren(current)) {
                if (next.equals(b)) {
                    return true;
                }
                queue.add(next);
            }
        }
        return false;
    }

    public abstract BytecodeInstruction getInstruction(int var1);

    public abstract boolean containsInstruction(BytecodeInstruction var1);

    public void finalise() {
        this.computeDiameter();
    }

    public int getDiameter() {
        if (this.diameter == -1) {
            logger.debug("diameter not computed yet. calling computeDiameter() first!");
            this.computeDiameter();
        }
        return this.diameter;
    }

    public int getCyclomaticComplexity() {
        int E = this.edgeCount();
        int N = this.vertexCount();
        return E - N + 2;
    }

    protected void computeDiameter() {
        this.diameter = this.edgeCount();
    }

    public V determineEntryPoint() {
        Set candidates = this.determineEntryPoints();
        if (candidates.size() > 1) {
            throw new IllegalStateException("expect CFG of a method to contain at most one instruction with no parent in " + this.methodName);
        }
        Iterator i$ = candidates.iterator();
        if (i$.hasNext()) {
            Object instruction = i$.next();
            return instruction;
        }
        return null;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getMethodAccess() {
        return this.access;
    }

    public boolean isPublicMethod() {
        return (this.access & 1) == 1;
    }

    public boolean isStaticMethod() {
        return (this.access & 8) == 8;
    }

    @Override
    public String getName() {
        return this.methodName + " " + this.getCFGType();
    }

    @Override
    protected String dotSubFolder() {
        return this.toFileString(this.className) + "/" + this.getCFGType() + "/";
    }

    public abstract String getCFGType();
}

