/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanArrayInterpreter
extends BasicInterpreter {
    protected static Logger logger = LoggerFactory.getLogger(BooleanArrayInterpreter.class);
    public static final BasicValue BYTE = new BasicValue(null);
    public static final BasicValue BOOLEAN = new BasicValue(null);
    public static final BasicValue BOOLEAN_ARRAY = new BasicValue(null);
    public static final BasicValue BYTE_ARRAY = new BasicValue(null);
    public static final BasicValue INT_ARRAY = new BasicValue(null);

    public BasicValue newValue(Type type) {
        if (type == null) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        switch (type.getSort()) {
            case 9: {
                String desc = type.getDescriptor();
                if (desc.equals("[Z")) {
                    return BOOLEAN_ARRAY;
                }
                if (desc.equals("[I")) {
                    return INT_ARRAY;
                }
                if (desc.equals("[B")) {
                    return BYTE_ARRAY;
                }
                return super.newValue(type);
            }
        }
        return super.newValue(type);
    }

    public BasicValue naryOperation(AbstractInsnNode insn, List values) throws AnalyzerException {
        if (insn.getOpcode() == 184 || insn.getOpcode() == 182 || insn.getOpcode() == 185) {
            MethodInsnNode mn = (MethodInsnNode)insn;
            if (Type.getReturnType((String)mn.desc).equals((Object)Type.BOOLEAN_TYPE)) {
                return BOOLEAN;
            }
            if (mn.desc.equals("[Z")) {
                return BOOLEAN_ARRAY;
            }
            if (mn.desc.equals("[B")) {
                return BYTE_ARRAY;
            }
            if (mn.desc.equals("[I")) {
                return INT_ARRAY;
            }
            if (Type.getReturnType((String)mn.desc).equals((Object)Type.BYTE_TYPE)) {
                return BYTE;
            }
            if (mn.name.equals("clone") && mn.owner.equals("[I")) {
                return INT_ARRAY;
            }
            if (mn.name.equals("clone") && mn.owner.equals("[Z")) {
                return BOOLEAN_ARRAY;
            }
            if (mn.name.equals("clone") && mn.owner.equals("[B")) {
                return BYTE_ARRAY;
            }
            return super.naryOperation(insn, values);
        }
        return super.naryOperation(insn, values);
    }
}

