/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.evosuite.Properties;
import org.evosuite.instrumentation.RegexDistance;
import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.setup.TestCluster;

public class BooleanHelper {
    public static final int K = 0x7FFFFFFD;
    private static final int TRUE = 0x7FFFFFFD;
    private static final int FALSE = -2147483645;
    static Map<Integer, Integer> lastDistance = new HashMap<Integer, Integer>();
    private static Stack<Object> parametersObject = new Stack();
    private static Stack<Boolean> parametersBoolean = new Stack();
    private static Stack<Character> parametersChar = new Stack();
    private static Stack<Byte> parametersByte = new Stack();
    private static Stack<Short> parametersShort = new Stack();
    private static Stack<Integer> parametersInteger = new Stack();
    private static Stack<Float> parametersFloat = new Stack();
    private static Stack<Long> parametersLong = new Stack();
    private static Stack<Double> parametersDouble = new Stack();

    public static void clearStack() {
        lastDistance.clear();
    }

    public static int objectEquals(Object obj1, Object obj2) {
        return obj1.equals(obj2) ? 0x7FFFFFFD : -2147483645;
    }

    public static int collectionIsEmpty(Collection<?> c) {
        return c.isEmpty() ? 0x7FFFFFFD : -c.size();
    }

    public static int collectionContains(Collection<?> c, Object o1) {
        if (o1 != null) {
            TestCluster.getInstance().addCastClassForContainer(o1.getClass());
        }
        int matching = 0;
        double min_distance = Double.MAX_VALUE;
        for (Object o2 : c) {
            if (o2.equals(o1)) {
                ++matching;
                continue;
            }
            if (o2 == null || o1 == null || !o2.getClass().equals(o1.getClass())) continue;
            if (o1 instanceof Number) {
                Number n1 = (Number)o1;
                Number n2 = (Number)o2;
                min_distance = Math.min(min_distance, Math.abs(n1.doubleValue() - n2.doubleValue()));
                continue;
            }
            if (!(o2 instanceof String)) continue;
            ConstantPoolManager.getInstance().addDynamicConstant(o1);
            min_distance = Math.min(min_distance, (double)BooleanHelper.editDistance((String)o1, (String)o2));
        }
        if (matching > 0) {
            return matching;
        }
        if (min_distance == Double.MAX_VALUE) {
            return -c.size() - 1;
        }
        return -1 * (int)Math.ceil(2.147483645E9 * min_distance / (min_distance + 1.0));
    }

    public static int collectionContainsAll(Collection<?> c, Collection<?> c2) {
        int mismatch = 0;
        for (Object o : c2) {
            if (c.contains(o)) continue;
            ++mismatch;
        }
        return mismatch > 0 ? -mismatch : c2.size() + 1;
    }

    public static int mapContainsKey(Map<?, ?> m, Object o1) {
        if (o1 != null) {
            TestCluster.getInstance().addCastClassForContainer(o1.getClass());
        }
        return BooleanHelper.collectionContains(m.keySet(), o1);
    }

    public static int mapContainsValue(Map<?, ?> m, Object o1) {
        if (o1 != null) {
            TestCluster.getInstance().addCastClassForContainer(o1.getClass());
        }
        return BooleanHelper.collectionContains(m.values(), o1);
    }

    public static int mapIsEmpty(Map<?, ?> m) {
        return m.isEmpty() ? 0x7FFFFFFD : -m.size();
    }

    public static void pushPredicate(int distance, int branchId) {
        lastDistance.put(branchId, Math.abs(distance));
    }

    public static int getDistance(int branchId, int approximationLevel, int value) {
        double val;
        int d;
        int distance = Integer.MAX_VALUE;
        if (branchId > 0 && lastDistance.containsKey(branchId)) {
            distance = lastDistance.get(branchId);
        }
        if ((d = (int)Math.ceil(2.147483645E9 * (val = (1.0 + BooleanHelper.normalize(distance)) / Math.pow(2.0, approximationLevel)))) == 0) {
            d = 1;
        }
        if (value <= 0) {
            d = -d;
        }
        return d;
    }

    private static double normalize(int distance) {
        double k = Properties.MAX_INT;
        double d = distance;
        return d / (d + 0.5 * k);
    }

    public static int doubleSub(double d1, double d2) {
        if (d1 == d2) {
            if (Properties.DYNAMIC_SEEDING) {
                ConstantPoolManager.getInstance().addDynamicConstant(d1);
            }
            return 0;
        }
        double diff = d1 - d2;
        double diff2 = diff / (1.0 + Math.abs(diff));
        if (Double.isNaN(d1) || Double.isNaN(d2) || Double.isInfinite(d1) || Double.isInfinite(d2)) {
            return Double.compare(d1, d2);
        }
        int d3 = (int)(diff2 < 0.0 ? Math.floor(2.147483647E9 * diff2) : Math.ceil(2.147483647E9 * diff2));
        if (Properties.DYNAMIC_SEEDING) {
            ConstantPoolManager.getInstance().addDynamicConstant(d1);
            ConstantPoolManager.getInstance().addDynamicConstant(d2);
        }
        return d3;
    }

    public static int floatSub(float f1, float f2) {
        if (f1 == f2) {
            if (Properties.DYNAMIC_SEEDING) {
                ConstantPoolManager.getInstance().addDynamicConstant(Float.valueOf(f1));
            }
            return 0;
        }
        double diff = f1 - f2;
        double diff2 = Math.signum(diff) * Math.abs(diff) / (1.0 + Math.abs(diff));
        if (Float.isNaN(f1) || Float.isNaN(f2) || Float.isInfinite(f1) || Float.isInfinite(f2)) {
            return Float.compare(f1, f2);
        }
        int d3 = (int)Math.ceil(2.147483647E9 * diff2);
        if (Properties.DYNAMIC_SEEDING) {
            ConstantPoolManager.getInstance().addDynamicConstant(Float.valueOf(f1));
            ConstantPoolManager.getInstance().addDynamicConstant(Float.valueOf(f2));
        }
        return d3;
    }

    public static int intSub(int a, int b) {
        long sub = (long)a - (long)b;
        if (sub < -2147483645L) {
            return -2147483645;
        }
        if (sub > 0x7FFFFFFDL) {
            return 0x7FFFFFFD;
        }
        return (int)sub;
    }

    public static int longSub(long l1, long l2) {
        if (l1 == l2) {
            if (Properties.DYNAMIC_SEEDING) {
                ConstantPoolManager.getInstance().addDynamicConstant(l1);
            }
            return 0;
        }
        double diff = l1 - l2;
        double diff2 = Math.signum(diff) * Math.abs(diff) / (1.0 + Math.abs(diff));
        int d3 = (int)Math.ceil(2.147483647E9 * diff2);
        if (Properties.DYNAMIC_SEEDING) {
            ConstantPoolManager.getInstance().addDynamicConstant(l1);
            ConstantPoolManager.getInstance().addDynamicConstant(l2);
        }
        return d3;
    }

    @Deprecated
    public static int fromDouble(double d) {
        if (d == 0.0) {
            return 0;
        }
        double d2 = Math.signum(d) * Math.abs(d) / (1.0 + Math.abs(d));
        int d3 = (int)Math.round(2.147483647E9 * d2);
        return d3;
    }

    @Deprecated
    public static int fromFloat(float d) {
        if (d == 0.0f) {
            return 0;
        }
        float d2 = Math.signum(d) * Math.abs(d) / (1.0f + Math.abs(d));
        int d3 = Math.round(2.1474836E9f * d2);
        return d3;
    }

    @Deprecated
    public static int fromLong(long d) {
        if (d == 0L) {
            return 0;
        }
        double d2 = Math.signum(d) * (float)Math.abs(d) / (float)(1L + Math.abs(d));
        int d3 = (int)Math.round(2.147483647E9 * d2);
        return d3;
    }

    public static int booleanToInt(boolean b) {
        if (b) {
            return 0x7FFFFFFD;
        }
        return -2147483645;
    }

    public static boolean intToBoolean(int x) {
        return x > 0;
    }

    public static int min(int a, int b, int c) {
        if (a < b) {
            return Math.min(a, c);
        }
        return Math.min(b, c);
    }

    public static int compareBoolean(int a, int b) {
        if (a > 0 && b > 0 || a <= 0 && b <= 0) {
            return Math.abs(a - b);
        }
        return -1 * Math.abs(a - b);
    }

    public static int editDistance_old(String s, String t) {
        int j;
        int i;
        int k = 127;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 127;
                d[i][j] = BooleanHelper.min(d[i - 1][j] + k, d[i][j - 1] + k, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    public static int editDistance(String s, String t) {
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static int StringEquals(String first, Object second) {
        if (first == null) {
            throw new NullPointerException("StringEquals is not supposed to work on a null caller");
        }
        if (second == null) {
            return -2147483645;
        }
        if (first.equals(second)) {
            return 0x7FFFFFFD;
        }
        ConstantPoolManager.getInstance().addDynamicConstant(first);
        ConstantPoolManager.getInstance().addDynamicConstant(second);
        return -BooleanHelper.getDistanceBasedOnLeftAlignment(first, second.toString());
    }

    public static double StringEqualsCharacterDistance(String first, Object second) {
        if (first == null) {
            throw new IllegalArgumentException("StringEquals is not supposed to work on a null caller");
        }
        if (second == null) {
            return -2.147483645E9;
        }
        if (first.equals(second)) {
            return 2.147483645E9;
        }
        return -BooleanHelper.getDistanceBasedOnLeftAlignmentCharacterDistance(first, second.toString());
    }

    public static int StringMatches(String str, String regex) {
        int distance = RegexDistance.getDistance(str, regex);
        if (Properties.DYNAMIC_POOL > 0.0) {
            if (distance > 0) {
                String instance = RegexDistance.getRegexInstance(regex);
                ConstantPoolManager.getInstance().addDynamicConstant(instance);
            } else {
                String instance = RegexDistance.getNonMatchingRegexInstance(regex);
                ConstantPoolManager.getInstance().addDynamicConstant(instance);
            }
        }
        if (distance > 0) {
            return -distance;
        }
        return 0x7FFFFFFD;
    }

    public static int StringMatchRegex(String regex, CharSequence input) {
        int distance = RegexDistance.getDistance(input.toString(), regex);
        if (Properties.DYNAMIC_POOL > 0.0) {
            if (distance > 0) {
                String instance = RegexDistance.getRegexInstance(regex);
                ConstantPoolManager.getInstance().addDynamicConstant(instance);
            } else {
                String instance = RegexDistance.getNonMatchingRegexInstance(regex);
                ConstantPoolManager.getInstance().addDynamicConstant(instance);
            }
        }
        if (distance > 0) {
            return -distance;
        }
        return 0x7FFFFFFD;
    }

    public static int StringMatchRegex(Matcher matcher) {
        Pattern pattern = matcher.pattern();
        String regex = pattern.pattern();
        try {
            Field textField = Matcher.class.getDeclaredField("text");
            textField.setAccessible(true);
            CharSequence input = (CharSequence)textField.get(matcher);
            int distance = RegexDistance.getDistance(input.toString(), regex);
            if (Properties.DYNAMIC_POOL > 0.0) {
                if (distance > 0) {
                    String instance = RegexDistance.getRegexInstance(regex);
                    ConstantPoolManager.getInstance().addDynamicConstant(instance);
                } else {
                    String instance = RegexDistance.getNonMatchingRegexInstance(regex);
                    ConstantPoolManager.getInstance().addDynamicConstant(instance);
                }
            }
            if (distance > 0) {
                return -distance;
            }
            return 0x7FFFFFFD;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return matcher.matches() ? 1 : -1;
        }
    }

    protected static int getDistanceBasedOnLeftAlignment(String a, String b) {
        int differences = 0;
        int min = Math.min(a.length(), b.length());
        int max = Math.max(a.length(), b.length());
        differences += max - min;
        for (int i = 0; i < min; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            ++differences;
        }
        return differences;
    }

    public static double getDistanceBasedOnLeftAlignmentCharacterDistance(String a, String b) {
        if (a == b) {
            return 2.147483645E9;
        }
        if (a == null && b != null) {
            return b.length() + 1;
        }
        if (a != null && b == null) {
            return a.length() + 1;
        }
        double differences = 0.0;
        int min = Math.min(a.length(), b.length());
        int max = Math.max(a.length(), b.length());
        differences += (double)(max - min);
        for (int i = 0; i < min; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            differences += BooleanHelper.normalize(Math.abs(a.charAt(i) - b.charAt(i)));
        }
        return differences;
    }

    public static int StringEqualsIgnoreCase(String first, String second) {
        if (first == null) {
            throw new NullPointerException("StringEquals is not supposed to work on a null caller");
        }
        if (second == null) {
            return -2147483645;
        }
        return BooleanHelper.StringEquals(first.toLowerCase(), second.toLowerCase());
    }

    public static int StringStartsWith(String value, String prefix, int start) {
        int len = Math.min(prefix.length(), value.length());
        ConstantPoolManager.getInstance().addDynamicConstant(prefix + value);
        return BooleanHelper.StringEquals(value.substring(start, start + len), prefix);
    }

    public static int StringEndsWith(String value, String suffix) {
        int len = Math.min(suffix.length(), value.length());
        String val1 = value.substring(value.length() - len);
        ConstantPoolManager.getInstance().addDynamicConstant(value + suffix);
        return BooleanHelper.StringEquals(val1, suffix);
    }

    public static int StringIsEmpty(String value) {
        int len = value.length();
        if (len == 0) {
            return 0x7FFFFFFD;
        }
        return -len;
    }

    public static int StringRegionMatches(String value, boolean ignoreCase, int thisStart, String string, int start, int length) {
        if (value == null || string == null) {
            throw new NullPointerException();
        }
        if (start < 0 || string.length() - start < length) {
            return -2147483645;
        }
        if (thisStart < 0 || value.length() - thisStart < length) {
            return -2147483645;
        }
        if (length <= 0) {
            return 0x7FFFFFFD;
        }
        String s1 = value;
        String s2 = string;
        if (ignoreCase) {
            s1 = s1.toLowerCase();
            s2 = s2.toLowerCase();
        }
        if (Properties.DYNAMIC_POOL > 0.0) {
            String sub1 = s1.substring(thisStart, length + thisStart);
            String sub2 = s2.substring(start, length + start);
            String sn1 = s1.substring(0, thisStart) + sub2 + s1.substring(thisStart + length);
            String sn2 = s2.substring(0, start) + sub1 + s2.substring(start + length);
            ConstantPoolManager.getInstance().addDynamicConstant(sn1);
            ConstantPoolManager.getInstance().addDynamicConstant(sn2);
        }
        return BooleanHelper.StringEquals(s1.substring(thisStart, length + thisStart), s2.substring(start, length + start));
    }

    public static int StringRegionMatches(String value, int thisStart, String string, int start, int length) {
        return BooleanHelper.StringRegionMatches(value, false, thisStart, string, start, length);
    }

    public static int instanceOf(Object o, Class<?> c) {
        if (o == null) {
            return -2147483645;
        }
        return c.isAssignableFrom(o.getClass()) ? 0x7FFFFFFD : -2147483645;
    }

    public static int isNull(Object o, int opcode) {
        if (opcode == 198) {
            return o == null ? 0x7FFFFFFD : -2147483645;
        }
        return o != null ? 0x7FFFFFFD : -2147483645;
    }

    public static int IOR(int a, int b) {
        int ret = 0;
        if (a > 0 || b > 0) {
            ret = a;
            if (b > 0 && b < a) {
                ret = b;
            }
        } else {
            ret = a;
            if (b > a) {
                ret = b;
            }
        }
        return ret;
    }

    public static int IAND(int a, int b) {
        return Math.min(a, b);
    }

    public static int IXOR(int a, int b) {
        int ret = 0;
        ret = a > 0 && b <= 0 ? a : (b > 0 && a <= 0 ? b : -Math.abs(a - b));
        return ret;
    }

    public static int isEqual(Object o1, Object o2, int opcode) {
        if (opcode == 165) {
            return o1 == o2 ? 0x7FFFFFFD : -2147483645;
        }
        return o1 != o2 ? 0x7FFFFFFD : -2147483645;
    }

    public static boolean popParameterBooleanFromInt() {
        int i = parametersInteger.pop();
        boolean result = i > 0;
        return result;
    }

    public static int popParameterIntFromBoolean() {
        boolean i = parametersBoolean.pop();
        if (i) {
            return 0x7FFFFFFD;
        }
        return -2147483645;
    }

    public static boolean popParameterBoolean() {
        return parametersBoolean.pop();
    }

    public static char popParameterChar() {
        return parametersChar.pop().charValue();
    }

    public static byte popParameterByte() {
        return parametersByte.pop();
    }

    public static short popParameterShort() {
        return parametersShort.pop();
    }

    public static int popParameterInt() {
        return parametersInteger.pop();
    }

    public static float popParameterFloat() {
        return parametersFloat.pop().floatValue();
    }

    public static long popParameterLong() {
        return parametersLong.pop();
    }

    public static double popParameterDouble() {
        return parametersDouble.pop();
    }

    public static Object popParameterObject() {
        return parametersObject.pop();
    }

    public static Object popParameter(Object o) {
        return parametersObject.pop();
    }

    public static void pushParameter(boolean o) {
        parametersBoolean.push(o);
    }

    public static void pushParameter(char o) {
        parametersChar.push(Character.valueOf(o));
    }

    public static void pushParameter(byte o) {
        parametersByte.push(o);
    }

    public static void pushParameter(short o) {
        parametersShort.push(o);
    }

    public static void pushParameter(int o) {
        parametersInteger.push(o);
    }

    public static void pushParameter(float o) {
        parametersFloat.push(Float.valueOf(o));
    }

    public static void pushParameter(long o) {
        parametersLong.push(o);
    }

    public static void pushParameter(double o) {
        parametersDouble.push(o);
    }

    public static void pushParameter(Object o) {
        parametersObject.push(o);
    }
}

