/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.assertion.CheapPurityAnalyzer;
import org.evosuite.classpath.ResourceList;
import org.evosuite.graphs.cfg.CFGClassAdapter;
import org.evosuite.instrumentation.AccessibleClassAdapter;
import org.evosuite.instrumentation.BooleanTestabilityTransformation;
import org.evosuite.instrumentation.ClassAdapterFactory;
import org.evosuite.instrumentation.ComparisonTransformation;
import org.evosuite.instrumentation.ContainerTransformation;
import org.evosuite.instrumentation.ErrorConditionClassAdapter;
import org.evosuite.instrumentation.ExecutionPathClassAdapter;
import org.evosuite.instrumentation.ExitClassInitAdapter;
import org.evosuite.instrumentation.NonTargetClassAdapter;
import org.evosuite.instrumentation.PurityAnalysisClassVisitor;
import org.evosuite.instrumentation.PutStaticClassAdapter;
import org.evosuite.instrumentation.StringTransformation;
import org.evosuite.instrumentation.TransformationStatistics;
import org.evosuite.junit.writer.TestSuiteWriterUtils;
import org.evosuite.runtime.instrumentation.AnnotatedClassNode;
import org.evosuite.runtime.instrumentation.CreateClassResetClassAdapter;
import org.evosuite.runtime.instrumentation.MethodCallReplacementClassAdapter;
import org.evosuite.runtime.instrumentation.RuntimeInstrumentation;
import org.evosuite.runtime.reset.ResetManager;
import org.evosuite.runtime.util.ComputeClassWriter;
import org.evosuite.seeding.PrimitiveClassAdapter;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.TestCluster;
import org.evosuite.testcarver.instrument.Instrumenter;
import org.evosuite.testcarver.instrument.TransformerUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.TraceClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytecodeInstrumentation {
    private static Logger logger = LoggerFactory.getLogger(BytecodeInstrumentation.class);
    private static List<ClassAdapterFactory> externalPreVisitors = new ArrayList<ClassAdapterFactory>();
    private static List<ClassAdapterFactory> externalPostVisitors = new ArrayList<ClassAdapterFactory>();
    private final Instrumenter testCarvingInstrumenter = new Instrumenter();

    public static void addClassAdapter(ClassAdapterFactory factory) {
        externalPostVisitors.add(factory);
    }

    public static void addPreClassAdapter(ClassAdapterFactory factory) {
        externalPreVisitors.add(factory);
    }

    private static String[] getEvoSuitePackages() {
        return new String[]{"org.evosuite", "org.exsyst", "de.unisb.cs.st.testcarver", "de.unisb.cs.st.evosuite", "testing.generation.evosuite", "de.unisl.cs.st.bugex"};
    }

    public static boolean checkIfCanInstrument(String className) {
        return RuntimeInstrumentation.checkIfCanInstrument((String)className);
    }

    public static boolean checkIfEvoSuitePackage(String className) {
        for (String s : BytecodeInstrumentation.getEvoSuitePackages()) {
            if (!className.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldTransform(String className) {
        if (!Properties.TT) {
            return false;
        }
        switch (Properties.TT_SCOPE) {
            case ALL: {
                logger.info("Allowing transformation of " + className);
                return true;
            }
            case TARGET: {
                if (!className.equals(Properties.TARGET_CLASS) && !className.startsWith(Properties.TARGET_CLASS + "$")) break;
                return true;
            }
            case PREFIX: {
                if (!className.startsWith(Properties.PROJECT_PREFIX)) break;
                return true;
            }
        }
        logger.info("Preventing transformation of " + className);
        return false;
    }

    private boolean isTargetClassName(String className) {
        return TestCluster.isTargetClassName(className);
    }

    public byte[] transformBytes(ClassLoader classLoader, String className, ClassReader reader) {
        ComputeClassWriter writer;
        String classNameWithDots;
        int readFlags = 4;
        if (Properties.INSTRUMENTATION_SKIP_DEBUG) {
            readFlags |= 2;
        }
        if (!BytecodeInstrumentation.checkIfCanInstrument(classNameWithDots = ResourceList.getClassNameFromResourcePath(className))) {
            throw new RuntimeException("Should not transform a shared class (" + classNameWithDots + ")! Load by parent (JVM) classloader.");
        }
        TransformationStatistics.reset();
        int asmFlags = 2;
        Object cv = writer = new ComputeClassWriter(asmFlags);
        if (logger.isDebugEnabled()) {
            cv = new TraceClassVisitor((ClassVisitor)cv, new PrintWriter(System.err));
        }
        if (Properties.RESET_STATIC_FIELDS) {
            cv = new PutStaticClassAdapter((ClassVisitor)cv, className);
        }
        if (Properties.PURE_INSPECTORS) {
            CheapPurityAnalyzer purityAnalyzer = CheapPurityAnalyzer.getInstance();
            cv = new PurityAnalysisClassVisitor((ClassVisitor)cv, className, purityAnalyzer);
        }
        if (DependencyAnalysis.shouldAnalyze(classNameWithDots)) {
            logger.debug("Applying target transformation to class " + classNameWithDots);
            if (!Properties.TEST_CARVING && Properties.MAKE_ACCESSIBLE) {
                cv = new AccessibleClassAdapter((ClassVisitor)cv, className);
            }
            for (ClassAdapterFactory factory : externalPostVisitors) {
                cv = factory.getVisitor((ClassVisitor)cv, className);
            }
            cv = new ExecutionPathClassAdapter((ClassVisitor)cv, className);
            cv = new CFGClassAdapter(classLoader, (ClassVisitor)cv, className);
            if (Properties.ERROR_BRANCHES) {
                cv = new ErrorConditionClassAdapter((ClassVisitor)cv, className);
            }
            for (ClassAdapterFactory factory : externalPreVisitors) {
                cv = factory.getVisitor((ClassVisitor)cv, className);
            }
        } else {
            logger.debug("Not applying target transformation");
            cv = new NonTargetClassAdapter((ClassVisitor)cv, className);
            if (Properties.MAKE_ACCESSIBLE) {
                cv = new AccessibleClassAdapter((ClassVisitor)cv, className);
            }
            if (Properties.TT && classNameWithDots.startsWith(Properties.CLASS_PREFIX)) {
                cv = new CFGClassAdapter(classLoader, (ClassVisitor)cv, className);
            }
        }
        cv = new PrimitiveClassAdapter((ClassVisitor)cv, className);
        if (Properties.RESET_STATIC_FIELDS) {
            CreateClassResetClassAdapter resetClassAdapter = new CreateClassResetClassAdapter((ClassVisitor)cv, className);
            if (ResetManager.getInstance().getResetFinalFields()) {
                resetClassAdapter.setRemoveFinalModifierOnStaticFields(true);
            } else {
                resetClassAdapter.setRemoveFinalModifierOnStaticFields(false);
            }
            cv = resetClassAdapter;
            ExitClassInitAdapter exitClassInitAdapter = new ExitClassInitAdapter((ClassVisitor)cv, className);
            cv = exitClassInitAdapter;
        }
        if (TestSuiteWriterUtils.needToUseAgent()) {
            cv = new MethodCallReplacementClassAdapter((ClassVisitor)cv, className);
        }
        if (classNameWithDots.startsWith(Properties.PROJECT_PREFIX) || !Properties.TARGET_CLASS_PREFIX.isEmpty() && classNameWithDots.startsWith(Properties.TARGET_CLASS_PREFIX) || this.shouldTransform(classNameWithDots)) {
            AnnotatedClassNode cn = new AnnotatedClassNode();
            reader.accept((ClassVisitor)cn, readFlags);
            logger.info("Starting transformation of " + className);
            if (Properties.STRING_REPLACEMENT) {
                StringTransformation st = new StringTransformation((ClassNode)cn);
                if (this.isTargetClassName(classNameWithDots) || this.shouldTransform(classNameWithDots)) {
                    cn = st.transform();
                }
            }
            ComparisonTransformation cmp = new ComparisonTransformation((ClassNode)cn);
            if (this.isTargetClassName(classNameWithDots) || this.shouldTransform(classNameWithDots)) {
                cn = cmp.transform();
                ContainerTransformation ct = new ContainerTransformation((ClassNode)cn);
                cn = ct.transform();
            }
            if (this.shouldTransform(classNameWithDots)) {
                logger.info("Testability Transforming " + className);
                BooleanTestabilityTransformation tt = new BooleanTestabilityTransformation((ClassNode)cn, classLoader);
                try {
                    cn = tt.transform();
                }
                catch (Throwable t) {
                    throw new Error(t);
                }
                logger.info("Testability Transformation done: " + className);
            }
            cn.accept((ClassVisitor)cv);
            if (Properties.TEST_CARVING && TransformerUtil.isClassConsideredForInstrumentation(className)) {
                ClassReader cr = new ClassReader(writer.toByteArray());
                ClassNode cn2 = new ClassNode();
                cr.accept((ClassVisitor)cn2, 8);
                this.testCarvingInstrumenter.transformClassNode(cn2, className);
                ClassWriter cw = new ClassWriter(1);
                cn2.accept((ClassVisitor)cw);
                if (logger.isDebugEnabled()) {
                    StringWriter sw = new StringWriter();
                    cn2.accept((ClassVisitor)new TraceClassVisitor(new PrintWriter(sw)));
                    logger.debug("test carving instrumentation result:\n{}", (Object)sw);
                }
                return cw.toByteArray();
            }
        } else {
            reader.accept((ClassVisitor)cv, readFlags);
        }
        return writer.toByteArray();
    }
}

