/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.util.List;
import org.evosuite.instrumentation.BooleanHelper;
import org.evosuite.instrumentation.TransformationStatistics;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ComparisonTransformation {
    ClassNode cn;

    public ComparisonTransformation(ClassNode cn) {
        this.cn = cn;
    }

    public ClassNode transform() {
        List methodNodes = this.cn.methods;
        for (MethodNode mn : methodNodes) {
            this.transformMethod(mn);
        }
        return this.cn;
    }

    public void transformMethod(MethodNode mn) {
        AbstractInsnNode node = mn.instructions.getFirst();
        while (node != mn.instructions.getLast()) {
            AbstractInsnNode next = node.getNext();
            if (node instanceof InsnNode) {
                InsnNode in = (InsnNode)node;
                if (in.getOpcode() == 148) {
                    this.insertLongComparison((AbstractInsnNode)in, mn.instructions);
                    TransformationStatistics.transformedComparison();
                } else if (in.getOpcode() == 152) {
                    TransformationStatistics.transformedComparison();
                    this.insertDoubleComparison((AbstractInsnNode)in, mn.instructions);
                } else if (in.getOpcode() == 151) {
                    TransformationStatistics.transformedComparison();
                    this.insertDoubleComparison((AbstractInsnNode)in, mn.instructions);
                } else if (in.getOpcode() == 150) {
                    TransformationStatistics.transformedComparison();
                    this.insertFloatComparison((AbstractInsnNode)in, mn.instructions);
                } else if (in.getOpcode() == 149) {
                    TransformationStatistics.transformedComparison();
                    this.insertFloatComparison((AbstractInsnNode)in, mn.instructions);
                }
            }
            node = next;
        }
    }

    private void insertLongComparison(AbstractInsnNode position, InsnList list) {
        MethodInsnNode get = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "longSub", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.LONG_TYPE, Type.LONG_TYPE}), false);
        list.insert(position, (AbstractInsnNode)get);
        list.remove(position);
    }

    private void insertFloatComparison(AbstractInsnNode position, InsnList list) {
        MethodInsnNode get = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "floatSub", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.FLOAT_TYPE, Type.FLOAT_TYPE}), false);
        list.insert(position, (AbstractInsnNode)get);
        list.remove(position);
    }

    private void insertDoubleComparison(AbstractInsnNode position, InsnList list) {
        MethodInsnNode get = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "doubleSub", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.DOUBLE_TYPE, Type.DOUBLE_TYPE}), false);
        list.insert(position, (AbstractInsnNode)get);
        list.remove(position);
    }
}

