/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.evosuite.instrumentation.BooleanHelper;
import org.evosuite.instrumentation.TransformationStatistics;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerTransformation {
    private static Logger logger = LoggerFactory.getLogger(ContainerTransformation.class);
    ClassNode cn;

    public ContainerTransformation(ClassNode cn) {
        this.cn = cn;
    }

    public ClassNode transform() {
        List methodNodes = this.cn.methods;
        for (MethodNode mn : methodNodes) {
            if (!this.transformMethod(mn)) continue;
            ++mn.maxStack;
        }
        return this.cn;
    }

    public boolean transformMethod(MethodNode mn) {
        boolean changed = false;
        for (AbstractInsnNode node : mn.instructions) {
            InsnList il;
            MethodInsnNode n;
            if (!(node instanceof MethodInsnNode)) continue;
            MethodInsnNode methodNode = (MethodInsnNode)node;
            if (methodNode.owner.equals("java/util/Collection") || methodNode.owner.equals("java/util/List") || methodNode.owner.equals("java/util/ArrayList") || methodNode.owner.equals("java/util/Set") || methodNode.owner.equals("java/util/Queue") || methodNode.owner.equals("java/util/SortedSet")) {
                if (methodNode.name.equals("isEmpty")) {
                    logger.debug("Test Transformation of " + methodNode.owner + "." + methodNode.name + " -> " + Type.getInternalName(BooleanHelper.class) + "." + "collectionIsEmpty");
                    n = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "collectionIsEmpty", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(Collection.class)}), false);
                    il = ContainerTransformation.createNewIfThenElse(n);
                    mn.instructions.insertBefore(node, il);
                    mn.instructions.remove(node);
                    TransformationStatistics.transformedContainerComparison();
                    changed = true;
                    continue;
                }
                if (methodNode.name.equals("contains")) {
                    logger.debug("Test Transformation of " + methodNode.owner + "." + methodNode.name + " -> " + Type.getInternalName(BooleanHelper.class) + "." + "collectionContains");
                    n = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "collectionContains", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(Collection.class), Type.getType(Object.class)}), false);
                    il = ContainerTransformation.createNewIfThenElse(n);
                    mn.instructions.insertBefore(node, il);
                    mn.instructions.remove(node);
                    TransformationStatistics.transformedContainerComparison();
                    changed = true;
                    continue;
                }
                if (!methodNode.name.equals("containsAll")) continue;
                logger.debug("Test Transformation of " + methodNode.owner + "." + methodNode.name + " -> " + Type.getInternalName(BooleanHelper.class) + "." + "collectionContainsAll");
                n = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "collectionContainsAll", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(Collection.class), Type.getType(Collection.class)}), false);
                il = ContainerTransformation.createNewIfThenElse(n);
                mn.instructions.insertBefore(node, il);
                mn.instructions.remove(node);
                TransformationStatistics.transformedContainerComparison();
                changed = true;
                continue;
            }
            if (!methodNode.owner.equals("java/util/Map")) continue;
            if (methodNode.name.equals("isEmpty")) {
                logger.debug("Test Transformation of " + methodNode.owner + "." + methodNode.name + " -> " + Type.getInternalName(BooleanHelper.class) + "." + "mapIsEmpty");
                n = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "mapIsEmpty", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(Map.class)}), false);
                il = ContainerTransformation.createNewIfThenElse(n);
                mn.instructions.insertBefore(node, il);
                mn.instructions.remove(node);
                TransformationStatistics.transformedContainerComparison();
                changed = true;
                continue;
            }
            if (methodNode.name.equals("containsKey")) {
                logger.debug("Test Transformation of " + methodNode.owner + "." + methodNode.name + " -> " + Type.getInternalName(BooleanHelper.class) + "." + "mapContainsKey");
                n = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "mapContainsKey", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(Map.class), Type.getType(Object.class)}), false);
                il = ContainerTransformation.createNewIfThenElse(n);
                mn.instructions.insertBefore(node, il);
                mn.instructions.remove(node);
                TransformationStatistics.transformedContainerComparison();
                changed = true;
                continue;
            }
            if (!methodNode.name.equals("containsValue")) continue;
            logger.debug("Test Transformation of " + methodNode.owner + "." + methodNode.name + " -> " + Type.getInternalName(BooleanHelper.class) + "." + "mapContainsValue");
            n = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "mapContainsValue", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(Map.class), Type.getType(Object.class)}), false);
            il = ContainerTransformation.createNewIfThenElse(n);
            mn.instructions.insertBefore(node, il);
            mn.instructions.remove(node);
            TransformationStatistics.transformedContainerComparison();
            changed = true;
        }
        return changed;
    }

    private static InsnList createNewIfThenElse(MethodInsnNode n) {
        LabelNode labelIsNotEmpty = new LabelNode();
        LabelNode labelEndif = new LabelNode();
        InsnList il = new InsnList();
        il.add((AbstractInsnNode)n);
        il.add((AbstractInsnNode)new JumpInsnNode(158, labelIsNotEmpty));
        il.add((AbstractInsnNode)new InsnNode(4));
        il.add((AbstractInsnNode)new JumpInsnNode(167, labelEndif));
        il.add((AbstractInsnNode)labelIsNotEmpty);
        il.add((AbstractInsnNode)new InsnNode(3));
        il.add((AbstractInsnNode)labelEndif);
        return il;
    }
}

