/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.evosuite.Properties;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescriptorMapping {
    private static int id = 0;
    private final Map<String, String> descriptorMapping = new HashMap<String, String>();
    private static Logger logger = LoggerFactory.getLogger(DescriptorMapping.class);
    private static DescriptorMapping instance = null;
    final Map<String, String> originalDesc = new HashMap<String, String>();
    final Map<String, String> originalName = new HashMap<String, String>();
    private final Map<String, String> nameMapping = new HashMap<String, String>();

    private DescriptorMapping() {
    }

    public static DescriptorMapping getInstance() {
        if (instance == null) {
            instance = new DescriptorMapping();
        }
        return instance;
    }

    public static boolean shouldTransform(String classNameUnknown) {
        String className = classNameUnknown.replace("/", ".");
        switch (Properties.TT_SCOPE) {
            case ALL: {
                return true;
            }
            case TARGET: {
                if (!className.equals(Properties.TARGET_CLASS) && !className.startsWith(Properties.TARGET_CLASS + "$")) break;
                return true;
            }
            case PREFIX: {
                if (!className.startsWith(Properties.PROJECT_PREFIX)) break;
                return true;
            }
        }
        return false;
    }

    public boolean isTransformedMethod(String className, String methodName, String desc) {
        logger.info("Initiating transformation of " + methodName);
        this.getMethodDesc(className, methodName, desc);
        return this.descriptorMapping.containsKey(className.replace(".", "/") + "/" + methodName + desc);
    }

    public boolean hasTransformedArguments(String className, String methodName, String desc) {
        this.getMethodDesc(className, methodName, desc);
        if (!this.originalDesc.containsKey(className.replace(".", "/") + "/" + methodName + desc)) {
            return false;
        }
        String newDesc = this.originalDesc.get(className.replace(".", "/") + "/" + methodName + desc);
        for (Type type : Type.getArgumentTypes((String)newDesc)) {
            if (!type.equals((Object)Type.BOOLEAN_TYPE)) continue;
            return true;
        }
        return false;
    }

    public boolean isTransformedField(String className, String fieldName, String desc) {
        this.getFieldDesc(className, fieldName, desc);
        return this.descriptorMapping.containsKey(className.replace(".", "/") + "/" + fieldName + desc);
    }

    public boolean isTransformedOrBooleanMethod(String className, String methodName, String desc) {
        logger.info("Checking method: " + className + "." + methodName + desc);
        String new_desc = this.getMethodDesc(className, methodName, desc);
        logger.info("Transformed desc is " + new_desc);
        String name = className.replace(".", "/") + "/" + methodName + desc;
        if (this.originalDesc.containsKey(name)) {
            logger.info("Desc is already transformed");
        }
        return this.originalDesc.containsKey(name) || this.isBooleanMethod(desc);
    }

    private boolean isStringReplacement(String className, String methodName) {
        return className.equals("org/evosuite/instrumentation/TestabilityTransformation") && (methodName.equals("StringEquals") || methodName.equals("StringEqualsIgnoreCase") || methodName.equals("StringIsEmpty") || methodName.equals("StringStartsWith") || methodName.equals("StringEndsWith"));
    }

    public boolean isTransformedOrBooleanReturnMethod(String className, String methodName, String desc) {
        if (this.isStringReplacement(className, methodName)) {
            return true;
        }
        logger.info("Checking method: " + className + "." + methodName + desc);
        String new_desc = this.getMethodDesc(className, methodName, desc);
        logger.info("Transformed desc is " + new_desc);
        String name = className.replace(".", "/") + "/" + methodName + desc;
        if (this.originalDesc.containsKey(name)) {
            return Type.getReturnType((String)this.originalDesc.get(name)).equals((Object)Type.BOOLEAN_TYPE);
        }
        return Type.getReturnType((String)desc).equals((Object)Type.BOOLEAN_TYPE);
    }

    public boolean isTransformedOrBooleanField(String className, String fieldName, String desc) {
        logger.info("Checking field: " + className + "." + fieldName + desc);
        String new_desc = this.getFieldDesc(className, fieldName, desc);
        logger.info("Transformed desc is " + new_desc);
        String name = className.replace(".", "/") + "/" + fieldName + desc;
        if (this.originalDesc.containsKey(name)) {
            logger.info("Desc is already transformed");
        }
        return this.originalDesc.containsKey(name) || this.isBooleanField(desc);
    }

    public boolean isBooleanMethod(String desc) {
        Type[] types;
        for (Type type : types = Type.getArgumentTypes((String)desc)) {
            if (type.equals((Object)Type.BOOLEAN_TYPE)) {
                return true;
            }
            if (!type.getDescriptor().equals("[Z")) continue;
            return true;
        }
        Type type = Type.getReturnType((String)desc);
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            return true;
        }
        return type.getDescriptor().equals("[Z");
    }

    public boolean hasBooleanParameters(String desc) {
        for (Type t : Type.getArgumentTypes((String)desc)) {
            if (!t.equals((Object)Type.BOOLEAN_TYPE)) continue;
            return true;
        }
        return false;
    }

    private boolean isInside(String className) {
        String classNameWithDots = className.replace("/", ".");
        switch (Properties.TT_SCOPE) {
            case ALL: {
                if (!classNameWithDots.startsWith("java") && !classNameWithDots.startsWith("sun")) {
                    return true;
                }
            }
            case TARGET: {
                if (!classNameWithDots.equals(Properties.TARGET_CLASS) && !classNameWithDots.startsWith(Properties.TARGET_CLASS + "$")) break;
                return true;
            }
            case PREFIX: {
                if (!classNameWithDots.startsWith(Properties.PROJECT_PREFIX)) break;
                return true;
            }
        }
        return false;
    }

    private boolean isBooleanField(String desc) {
        logger.info("Checkign type of field " + desc);
        return desc.endsWith("Z");
    }

    private boolean isOutsideMethod(String className, String methodName, String desc) {
        HashSet<String> visited = new HashSet<String>();
        LinkedList<String> parents = new LinkedList<String>();
        parents.add(className);
        while (!parents.isEmpty()) {
            String name = (String)parents.poll();
            if (name == null) continue;
            visited.add(name);
            logger.info("Visiting class " + name + " while looking for source of " + className + "." + methodName);
            try {
                ClassReader reader = new ClassReader(name);
                ClassNode parent = new ClassNode();
                reader.accept((ClassVisitor)parent, 8);
                boolean isInside = this.isInside(parent.name);
                logger.info("Checking " + parent.name);
                for (Object o : parent.methods) {
                    MethodNode mn2 = (MethodNode)o;
                    if (!mn2.name.equals(methodName) || !mn2.desc.equals(desc)) continue;
                    if (!isInside) {
                        logger.info("Method " + name + " was defined outside the test package");
                        return true;
                    }
                    logger.info("Method " + name + " was defined outside the test package");
                }
                for (Object o : parent.interfaces) {
                    String par = (String)o;
                    if (visited.contains(par) || parents.contains(par)) continue;
                    parents.add(par);
                }
                if (visited.contains(parent.superName) || parents.contains(parent.superName)) continue;
                parents.add(parent.superName);
            }
            catch (IOException e) {
                logger.info("Error reading class " + name);
            }
        }
        return false;
    }

    private String transformMethodName(String className, String methodName, String desc, String transformedDesc) {
        HashSet<String> visited = new HashSet<String>();
        LinkedList<String> parents = new LinkedList<String>();
        parents.add(className);
        while (!parents.isEmpty()) {
            String name = (String)parents.poll();
            if (name == null) continue;
            visited.add(name);
            logger.info("Visiting class " + name + " while looking for name clashes of " + className + "." + methodName + transformedDesc);
            try {
                ClassReader reader = new ClassReader(name);
                ClassNode parent = new ClassNode();
                reader.accept((ClassVisitor)parent, 8);
                if (this.originalDesc.containsKey(className + "." + methodName + transformedDesc)) {
                    logger.info("Method " + methodName + " has conflicting transformed method");
                    return methodName + "_transformed" + id++;
                }
                for (Object o : parent.methods) {
                    MethodNode mn2 = (MethodNode)o;
                    if (!mn2.name.equals(methodName) || !mn2.desc.equals(transformedDesc)) continue;
                    logger.info("Method " + methodName + " has conflicting method");
                    if (methodName.equals("<init>")) {
                        return null;
                    }
                    return methodName + "_transformed" + id++;
                }
                for (Object o : parent.interfaces) {
                    String par = (String)o;
                    if (visited.contains(par) || parents.contains(par)) continue;
                    parents.add(par);
                }
                if (visited.contains(parent.superName) || parents.contains(parent.superName)) continue;
                parents.add(parent.superName);
            }
            catch (IOException e) {
                logger.info("Error reading class " + name);
            }
        }
        return methodName;
    }

    private boolean isOutsideField(String className, String fieldName, String desc) {
        HashSet<String> visited = new HashSet<String>();
        LinkedList<String> parents = new LinkedList<String>();
        parents.add(className);
        while (!parents.isEmpty()) {
            String name = (String)parents.poll();
            if (name == null) continue;
            visited.add(name);
            logger.info("Checking class " + name + " while looking for definition of field " + fieldName);
            try {
                ClassReader reader = new ClassReader(name);
                ClassNode parent = new ClassNode();
                reader.accept((ClassVisitor)parent, 8);
                boolean isInside = this.isInside(parent.name);
                for (Object o : parent.fields) {
                    FieldNode mn2 = (FieldNode)o;
                    if (!mn2.name.equals(fieldName) || !mn2.desc.equals(desc)) continue;
                    if (!isInside) {
                        logger.info("Field " + name + " was defined outside the test package - " + parent.name);
                        return true;
                    }
                    logger.info("Field " + name + " was defined inside the test package " + parent.name);
                    return false;
                }
                for (Object o : parent.interfaces) {
                    String par = (String)o;
                    if (visited.contains(par) || parents.contains(par)) continue;
                    parents.add(par);
                }
                if (visited.contains(parent.superName) || parents.contains(parent.superName)) continue;
                parents.add(parent.superName);
            }
            catch (IOException e) {
                logger.info("Error reading class " + name);
            }
        }
        return false;
    }

    private String transformMethodDescriptor(String desc) {
        Type[] types;
        String new_desc = "(";
        for (Type type : types = Type.getArgumentTypes((String)desc)) {
            new_desc = type.equals((Object)Type.BOOLEAN_TYPE) ? new_desc + "I" : (type.getDescriptor().equals("[Z") ? new_desc + "[I" : new_desc + type.getDescriptor());
        }
        new_desc = new_desc + ")";
        Type type = Type.getReturnType((String)desc);
        new_desc = type.equals((Object)Type.BOOLEAN_TYPE) ? new_desc + "I" : (type.getDescriptor().equals("[Z") ? new_desc + "[I" : new_desc + type.getDescriptor());
        return new_desc;
    }

    private String transformFieldDescriptor(String className, String desc) {
        if (!DescriptorMapping.shouldTransform(className)) {
            return desc;
        }
        logger.info("Transforming field instruction " + desc);
        if (this.isBooleanField(desc)) {
            if (desc.equals("Z")) {
                return "I";
            }
            if (desc.equals("[Z")) {
                return "[I";
            }
            return desc;
        }
        return desc;
    }

    public String getMethodName(String className, String methodName, String desc) {
        if (!DescriptorMapping.shouldTransform(className)) {
            return methodName;
        }
        String old = className + "." + methodName + desc;
        old = old.replace(".", "/");
        if (this.isBooleanMethod(desc)) {
            this.getMethodDesc(className, methodName, desc);
            return this.nameMapping.get(old);
        }
        if (this.nameMapping.containsKey(old)) {
            return this.nameMapping.get(old);
        }
        return methodName;
    }

    public String getMethodDesc(String className, String methodName, String desc) {
        if (!DescriptorMapping.shouldTransform(className)) {
            return desc;
        }
        if (this.isBooleanMethod(desc)) {
            String old = className.replace(".", "/") + "/" + methodName + desc;
            if (!this.descriptorMapping.containsKey(old)) {
                if (this.isOutsideMethod(className, methodName, desc)) {
                    logger.info("Is outside method: " + className + "." + methodName);
                    this.descriptorMapping.put(old, desc);
                    this.nameMapping.put(old, methodName);
                } else {
                    logger.info("Is inside method: " + className + "." + methodName);
                    String newDesc = this.transformMethodDescriptor(desc);
                    String newName = this.transformMethodName(className, methodName, desc, newDesc);
                    if (newName != null) {
                        this.descriptorMapping.put(old, newDesc);
                        this.nameMapping.put(old, newName);
                        logger.info("Keeping transformation from " + old + " to " + this.descriptorMapping.get(old) + " with new name " + newName);
                        this.originalDesc.put(className.replace(".", "/") + "/" + newName + newDesc, desc);
                        this.originalName.put(className.replace(".", "/") + "/" + newName + newDesc, methodName);
                    } else {
                        this.descriptorMapping.put(old, desc);
                        this.nameMapping.put(old, methodName);
                        this.originalDesc.put(className.replace(".", "/") + "/" + methodName + newDesc, desc);
                        this.originalName.put(className.replace(".", "/") + "/" + methodName + newDesc, methodName);
                    }
                }
            }
            return this.descriptorMapping.get(old);
        }
        return desc;
    }

    public String getFieldDesc(String className, String fieldName, String desc) {
        if (!DescriptorMapping.shouldTransform(className)) {
            return desc;
        }
        if (this.isBooleanField(desc)) {
            String old = className.replace(".", "/") + "/" + fieldName + desc;
            if (!this.descriptorMapping.containsKey(old)) {
                if (this.isOutsideField(className, fieldName, desc)) {
                    this.descriptorMapping.put(old, desc);
                } else {
                    this.descriptorMapping.put(old, this.transformFieldDescriptor(className, desc));
                    this.originalDesc.put(className.replace(".", "/") + "/" + fieldName + this.descriptorMapping.get(old), desc);
                }
            }
            return this.descriptorMapping.get(old);
        }
        return desc;
    }

    public String getOriginalName(String className, String methodName, String desc) {
        String key = className.replace(".", "/") + "/" + methodName + desc;
        if (this.originalName.containsKey(key)) {
            logger.info("Found transformed version of " + className + "." + methodName + desc);
            return this.originalName.get(key);
        }
        logger.info("Don't have transformed version of " + className + "." + methodName + desc);
        return methodName;
    }

    public String getOriginalDescriptor(String className, String methodName, String desc) {
        String key = className.replace(".", "/") + "/" + methodName + desc;
        if (this.originalDesc.containsKey(key)) {
            logger.info("Found transformed version of " + className + "." + methodName + desc);
            return this.originalDesc.get(key);
        }
        logger.info("Don't have transformed version of " + className + "." + methodName + desc);
        return desc;
    }

    public Type[] getOriginalTypes(String className, String methodName, String desc) {
        String key = className.replace(".", "/") + "/" + methodName + desc;
        if (this.originalDesc.containsKey(key)) {
            return Type.getArgumentTypes((String)this.originalDesc.get(key));
        }
        return Type.getArgumentTypes((String)desc);
    }
}

