/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import org.evosuite.classpath.ResourceList;
import org.evosuite.instrumentation.ErrorConditionMethodAdapter;
import org.evosuite.setup.DependencyAnalysis;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorConditionClassAdapter
extends ClassVisitor {
    private final String className;
    private static final Logger logger = LoggerFactory.getLogger(ErrorConditionClassAdapter.class);

    public ErrorConditionClassAdapter(ClassVisitor cv, String className) {
        super(327680, cv);
        this.className = className;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("<clinit>")) {
            return mv;
        }
        if (!DependencyAnalysis.shouldInstrument(ResourceList.getClassNameFromResourcePath(this.className), name + desc)) {
            return mv;
        }
        logger.info("Applying error transformation to " + this.className + ", method " + name + desc);
        return new ErrorConditionMethodAdapter(mv, this.className, name, access, desc);
    }
}

