/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import org.evosuite.instrumentation.LinePool;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineNumberMethodAdapter
extends MethodVisitor {
    private static Logger logger = LoggerFactory.getLogger(LineNumberMethodAdapter.class);
    private final String fullMethodName;
    private final String methodName;
    private final String className;
    private boolean hadInvokeSpecial = false;
    int currentLine = 0;

    public LineNumberMethodAdapter(MethodVisitor mv, String className, String methodName, String desc) {
        super(327680, mv);
        this.fullMethodName = methodName + desc;
        this.className = className;
        this.methodName = methodName;
        if (!methodName.equals("<init>")) {
            this.hadInvokeSpecial = true;
        }
    }

    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.currentLine = line;
        if (this.methodName.equals("<clinit>")) {
            return;
        }
        if (!this.hadInvokeSpecial) {
            return;
        }
        LinePool.addLine(this.className, this.fullMethodName, line);
        this.visitLdcInsn(this.className);
        this.visitLdcInsn(this.fullMethodName);
        this.visitLdcInsn(line);
        this.mv.visitMethodInsn(184, "org/evosuite/testcase/execution/ExecutionTracer", "passedLine", "(Ljava/lang/String;Ljava/lang/String;I)V", false);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (opcode == 183 && this.methodName.equals("<init>")) {
            this.hadInvokeSpecial = true;
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        int maxNum = 3;
        super.visitMaxs(Math.max(maxNum, maxStack), maxLocals);
    }
}

