/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import org.evosuite.assertion.CheapPurityAnalyzer;
import org.evosuite.instrumentation.BytecodeInstrumentation;
import org.evosuite.runtime.Random;
import org.objectweb.asm.MethodVisitor;

public class PurityAnalysisMethodVisitor
extends MethodVisitor {
    private boolean updatesField = false;
    private final CheapPurityAnalyzer purityAnalyzer;
    private final String classNameWithDots;
    private final String methodName;
    private final String descriptor;

    public PurityAnalysisMethodVisitor(String className, String methodName, String descriptor, MethodVisitor mv, CheapPurityAnalyzer purityAnalyzer) {
        super(327680, mv);
        this.purityAnalyzer = purityAnalyzer;
        this.classNameWithDots = className.replace("/", ".");
        this.methodName = methodName;
        this.descriptor = descriptor;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (opcode == 179 || opcode == 181) {
            this.updatesField = true;
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    public boolean updatesField() {
        return this.updatesField;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        String targetClassName = owner.replace("/", ".");
        if (targetClassName.equals(Random.class.getCanonicalName()) || !BytecodeInstrumentation.checkIfEvoSuitePackage(targetClassName)) {
            if (opcode == 184) {
                this.purityAnalyzer.addStaticCall(this.classNameWithDots, this.methodName, this.descriptor, targetClassName, name, desc);
            } else if (opcode == 182) {
                this.purityAnalyzer.addVirtualCall(this.classNameWithDots, this.methodName, this.descriptor, targetClassName, name, desc);
            } else if (opcode == 185) {
                this.purityAnalyzer.addInterfaceCall(this.classNameWithDots, this.methodName, this.descriptor, targetClassName, name, desc);
            } else if (opcode == 183) {
                this.purityAnalyzer.addSpecialCall(this.classNameWithDots, this.methodName, this.descriptor, targetClassName, name, desc);
            }
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }
}

