/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import org.evosuite.instrumentation.LineNumberMethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReturnValueAdapter
extends MethodVisitor {
    private static Logger logger = LoggerFactory.getLogger(LineNumberMethodAdapter.class);
    private final String fullMethodName;
    protected String className;
    protected String methodName;

    public ReturnValueAdapter(MethodVisitor mv, String className, String methodName, String desc) {
        super(327680, mv);
        this.fullMethodName = methodName + desc;
        this.methodName = methodName;
        this.className = className;
    }

    public void visitInsn(int opcode) {
        if (!this.methodName.equals("<clinit>")) {
            switch (opcode) {
                case 172: {
                    this.callLogIReturn();
                    break;
                }
                case 176: {
                    this.callLogAReturn();
                    break;
                }
                case 191: {
                    break;
                }
                case 175: {
                    this.callLogDReturn();
                    break;
                }
                case 174: {
                    this.callLogFReturn();
                    break;
                }
                case 173: {
                    this.callLogLReturn();
                    break;
                }
                case 177: {
                    break;
                }
            }
        }
        super.visitInsn(opcode);
    }

    private void callLogPrototype(String traceMethod, PDType type) {
        if (type != PDType.LONG && type != PDType.DOUBLE) {
            this.visitInsn(89);
            if (type == PDType.FLOAT) {
                this.visitMethodInsn(184, "java/lang/Float", "floatToRawIntBits", "(F)I", false);
            }
        } else {
            this.visitInsn(92);
            if (type == PDType.DOUBLE) {
                this.visitMethodInsn(184, "java/lang/Double", "doubleToRawLongBits", "(D)J", false);
            }
            this.visitInsn(92);
            this.visitIntInsn(16, 32);
            this.visitInsn(123);
            this.visitInsn(131);
            this.visitInsn(136);
        }
        this.visitLdcInsn(this.className);
        this.visitLdcInsn(this.fullMethodName);
        this.visitMethodInsn(184, "org/evosuite/testcase/execution/ExecutionTracer", "returnValue", "(ILjava/lang/String;Ljava/lang/String;)V", false);
    }

    private void callLogIReturn() {
        this.callLogPrototype("logIReturn", PDType.INTEGER);
    }

    private void callLogAReturn() {
        this.visitInsn(89);
        this.visitLdcInsn(this.className);
        this.visitLdcInsn(this.fullMethodName);
        this.visitMethodInsn(184, "org/evosuite/testcase/execution/ExecutionTracer", "returnValue", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)V", false);
    }

    private void callLogLReturn() {
        this.callLogPrototype("logLReturn", PDType.LONG);
    }

    private void callLogDReturn() {
        this.callLogPrototype("logDReturn", PDType.DOUBLE);
    }

    private void callLogFReturn() {
        this.callLogPrototype("logFReturn", PDType.FLOAT);
    }

    private static enum PDType {
        LONG,
        INTEGER,
        FLOAT,
        DOUBLE;

    }
}

