/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.util.List;
import java.util.regex.Matcher;
import org.evosuite.instrumentation.BooleanHelper;
import org.evosuite.instrumentation.StringBooleanInterpreter;
import org.evosuite.instrumentation.TransformationStatistics;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringTransformation {
    private static Logger logger = LoggerFactory.getLogger(StringTransformation.class);
    ClassNode cn;

    public StringTransformation(ClassNode cn) {
        this.cn = cn;
    }

    public ClassNode transform() {
        List methodNodes = this.cn.methods;
        for (MethodNode mn : methodNodes) {
            if (!this.transformMethod(mn)) continue;
            ++mn.maxStack;
        }
        return this.cn;
    }

    private boolean transformStrings(MethodNode mn) {
        logger.info("Current method: " + mn.name);
        boolean changed = false;
        for (AbstractInsnNode node : mn.instructions) {
            MethodInsnNode equalCheck;
            if (!(node instanceof MethodInsnNode)) continue;
            MethodInsnNode min = (MethodInsnNode)node;
            if (min.owner.equals("java/lang/String")) {
                MethodInsnNode equalCheck2;
                if (min.name.equals("equals")) {
                    changed = true;
                    equalCheck = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "StringEquals", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(Object.class)}), false);
                    mn.instructions.insertBefore(node, (AbstractInsnNode)equalCheck);
                    mn.instructions.remove(node);
                    TransformationStatistics.transformedStringComparison();
                    continue;
                }
                if (min.name.equals("equalsIgnoreCase")) {
                    changed = true;
                    equalCheck = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "StringEqualsIgnoreCase", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(String.class)}), false);
                    mn.instructions.insertBefore(node, (AbstractInsnNode)equalCheck);
                    mn.instructions.remove(node);
                    TransformationStatistics.transformedStringComparison();
                    continue;
                }
                if (min.name.equals("startsWith")) {
                    changed = true;
                    if (min.desc.equals("(Ljava/lang/String;)Z")) {
                        mn.instructions.insertBefore(node, (AbstractInsnNode)new InsnNode(3));
                    }
                    equalCheck = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "StringStartsWith", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(String.class), Type.INT_TYPE}), false);
                    mn.instructions.insertBefore(node, (AbstractInsnNode)equalCheck);
                    mn.instructions.remove(node);
                    TransformationStatistics.transformedStringComparison();
                    continue;
                }
                if (min.name.equals("endsWith")) {
                    changed = true;
                    equalCheck = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "StringEndsWith", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(String.class)}), false);
                    mn.instructions.insertBefore(node, (AbstractInsnNode)equalCheck);
                    mn.instructions.remove(node);
                    TransformationStatistics.transformedStringComparison();
                    continue;
                }
                if (min.name.equals("isEmpty")) {
                    changed = true;
                    equalCheck = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "StringIsEmpty", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(String.class)}), false);
                    mn.instructions.insertBefore(node, (AbstractInsnNode)equalCheck);
                    mn.instructions.remove(node);
                    TransformationStatistics.transformedStringComparison();
                    continue;
                }
                if (min.name.equals("matches")) {
                    changed = true;
                    equalCheck = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "StringMatches", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(String.class)}), false);
                    mn.instructions.insertBefore(node, (AbstractInsnNode)equalCheck);
                    mn.instructions.remove(node);
                    TransformationStatistics.transformedStringComparison();
                    continue;
                }
                if (!min.name.equals("regionMatches")) continue;
                Type[] argumentTypes = Type.getArgumentTypes((String)min.desc);
                if (argumentTypes.length == 4) {
                    changed = true;
                    equalCheck2 = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "StringRegionMatches", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.INT_TYPE, Type.getType(String.class), Type.INT_TYPE, Type.INT_TYPE}), false);
                    mn.instructions.insertBefore(node, (AbstractInsnNode)equalCheck2);
                    mn.instructions.remove(node);
                    TransformationStatistics.transformedStringComparison();
                    continue;
                }
                if (argumentTypes.length != 5) continue;
                changed = true;
                equalCheck2 = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "StringRegionMatches", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.BOOLEAN_TYPE, Type.INT_TYPE, Type.getType(String.class), Type.INT_TYPE, Type.INT_TYPE}), false);
                mn.instructions.insertBefore(node, (AbstractInsnNode)equalCheck2);
                mn.instructions.remove(node);
                TransformationStatistics.transformedStringComparison();
                continue;
            }
            if (min.owner.equals("java/util/regex/Pattern")) {
                if (!min.name.equals("matches")) continue;
                changed = true;
                equalCheck = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "StringMatchRegex", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(CharSequence.class)}), false);
                mn.instructions.insertBefore(node, (AbstractInsnNode)equalCheck);
                mn.instructions.remove(node);
                continue;
            }
            if (!min.owner.equals("java/util/regex/Matcher") || !min.name.equals("matches")) continue;
            changed = true;
            equalCheck = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "StringMatchRegex", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(Matcher.class)}), false);
            mn.instructions.insertBefore(node, (AbstractInsnNode)equalCheck);
            mn.instructions.remove(node);
        }
        return changed;
    }

    private static boolean isStringMethod(AbstractInsnNode node) {
        if (node.getOpcode() == 184) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)node;
            return methodInsnNode.owner.equals(Type.getInternalName(BooleanHelper.class)) && methodInsnNode.name.startsWith("String");
        }
        return false;
    }

    public boolean transformMethod(MethodNode mn) {
        boolean changed = this.transformStrings(mn);
        if (changed) {
            try {
                ++mn.maxStack;
                Analyzer a = new Analyzer((Interpreter)new StringBooleanInterpreter());
                a.analyze(this.cn.name, mn);
                Frame[] frames = a.getFrames();
                AbstractInsnNode node = mn.instructions.getFirst();
                boolean done = false;
                while (!done) {
                    Frame current;
                    if (node == mn.instructions.getLast()) {
                        done = true;
                    }
                    AbstractInsnNode next = node.getNext();
                    int index = mn.instructions.indexOf(node);
                    if (index < frames.length && (current = frames[index]) != null) {
                        JumpInsnNode branch;
                        int size = current.getStackSize();
                        if (node.getOpcode() == 154) {
                            branch = (JumpInsnNode)node;
                            if (current.getStack(size - 1) == StringBooleanInterpreter.STRING_BOOLEAN || StringTransformation.isStringMethod(node.getPrevious())) {
                                logger.info("IFNE -> IFGT");
                                branch.setOpcode(157);
                            }
                        } else if (node.getOpcode() == 153) {
                            branch = (JumpInsnNode)node;
                            if (current.getStack(size - 1) == StringBooleanInterpreter.STRING_BOOLEAN || StringTransformation.isStringMethod(node.getPrevious())) {
                                logger.info("IFEQ -> IFLE");
                                branch.setOpcode(158);
                            }
                        } else if (node.getOpcode() == 159) {
                            branch = (JumpInsnNode)node;
                            if (current.getStack(size - 2) == StringBooleanInterpreter.STRING_BOOLEAN || StringTransformation.isStringMethod(node.getPrevious().getPrevious())) {
                                if (node.getPrevious().getOpcode() == 3) {
                                    branch.setOpcode(158);
                                    mn.instructions.remove(node.getPrevious());
                                } else if (node.getPrevious().getOpcode() == 4) {
                                    branch.setOpcode(157);
                                    mn.instructions.remove(node.getPrevious());
                                }
                            }
                        } else if (node.getOpcode() == 160) {
                            branch = (JumpInsnNode)node;
                            if (current.getStack(size - 2) == StringBooleanInterpreter.STRING_BOOLEAN || StringTransformation.isStringMethod(node.getPrevious().getPrevious())) {
                                if (node.getPrevious().getOpcode() == 3) {
                                    branch.setOpcode(157);
                                    mn.instructions.remove(node.getPrevious());
                                } else if (node.getPrevious().getOpcode() == 4) {
                                    branch.setOpcode(158);
                                    mn.instructions.remove(node.getPrevious());
                                }
                            }
                        } else if (node.getOpcode() == 172 && (current.getStack(size - 1) == StringBooleanInterpreter.STRING_BOOLEAN || StringTransformation.isStringMethod(node.getPrevious()))) {
                            logger.info("IFEQ -> IFLE");
                            MethodInsnNode n = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "intToBoolean", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.INT_TYPE}), false);
                            mn.instructions.insertBefore(node, (AbstractInsnNode)n);
                        }
                        node = next;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.warn("EXCEPTION DURING STRING TRANSFORMATION: " + e);
                e.printStackTrace();
                return changed;
            }
        }
        return changed;
    }
}

