/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;

public class ThisInterpreter
extends BasicInterpreter {
    public static final BasicValue THIS_VALUE = new BasicValue(Type.INT_TYPE);

    public BasicValue copyOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        if (insn.getOpcode() == 25) {
            VarInsnNode varNode = (VarInsnNode)insn;
            if (varNode.var == 0) {
                return THIS_VALUE;
            }
        }
        return super.copyOperation(insn, value);
    }

    public BasicValue merge(BasicValue v, BasicValue w) {
        if (v == THIS_VALUE && w == BasicValue.REFERENCE_VALUE) {
            return BasicValue.REFERENCE_VALUE;
        }
        if (w == THIS_VALUE && v == BasicValue.REFERENCE_VALUE) {
            return BasicValue.REFERENCE_VALUE;
        }
        return super.merge(v, w);
    }
}

